/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.utils;

import com.clerk.backend_api.utils.Utils;
import java.util.concurrent.TimeUnit;

public class BackoffStrategy {
    private static final long DEFAULT_INITIAL_INTERVAL_MS = 500L;
    private static final long DEFAULT_MAX_INTERVAL_MS = 60000L;
    private static final long DEFAULT_MAX_ELAPSED_TIME_MS = 3600000L;
    private static final double DEFAULT_EXPONENT = 1.5;
    private static final double DEFAULT_JITTER_FACTOR = 0.5;
    private static final boolean DEFAULT_RETRY_CONNECT_ERROR = false;
    private static final boolean DEFAULT_RETRY_READ_TIMEOUT_ERROR = false;
    private final long initialIntervalMs;
    private final long maxIntervalMs;
    private final long maxElapsedTimeMs;
    private final double baseFactor;
    private final double jitterFactor;
    private final boolean retryConnectError;
    private final boolean retryReadTimeoutError;

    private BackoffStrategy(long initialIntervalMs, long maxIntervalMs, long maxElapsedTimeMs, double baseFactor, double jitterFactor, boolean retryConnectError, boolean retryReadTimeoutError) {
        this.initialIntervalMs = initialIntervalMs;
        this.maxIntervalMs = maxIntervalMs;
        this.maxElapsedTimeMs = maxElapsedTimeMs;
        this.baseFactor = baseFactor;
        this.jitterFactor = jitterFactor;
        this.retryConnectError = retryConnectError;
        this.retryReadTimeoutError = retryReadTimeoutError;
    }

    public static BackoffStrategy withDefaults() {
        return BackoffStrategy.builder().build();
    }

    public long initialIntervalMs() {
        return this.initialIntervalMs;
    }

    public long maxIntervalMs() {
        return this.maxIntervalMs;
    }

    public double baseFactor() {
        return this.baseFactor;
    }

    @Deprecated
    public double exponent() {
        return this.baseFactor;
    }

    public long maxElapsedTimeMs() {
        return this.maxElapsedTimeMs;
    }

    public double jitterFactor() {
        return this.jitterFactor;
    }

    public boolean retryConnectError() {
        return this.retryConnectError;
    }

    public boolean retryReadTimeoutError() {
        return this.retryReadTimeoutError;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private long initialIntervalMs = 500L;
        private long maxIntervalMs = 60000L;
        private long maxElapsedTimeMs = 3600000L;
        private double baseFactor = 1.5;
        private double jitterFactor = 0.5;
        private boolean retryConnectError = false;
        private boolean retryReadTimeoutError = false;

        private Builder() {
        }

        public Builder initialInterval(long duration, TimeUnit unit) {
            Utils.checkNotNull(unit, "unit");
            if (duration < 0L) {
                throw new IllegalArgumentException("initialInterval must be positive");
            }
            this.initialIntervalMs = unit.toMillis(duration);
            return this;
        }

        public Builder maxInterval(long duration, TimeUnit unit) {
            Utils.checkNotNull(unit, "unit");
            if (duration <= 0L) {
                throw new IllegalArgumentException("maxInterval must be strictly positive");
            }
            this.maxIntervalMs = unit.toMillis(duration);
            return this;
        }

        public Builder maxElapsedTime(long duration, TimeUnit unit) {
            Utils.checkNotNull(unit, "unit");
            if (duration < 0L) {
                throw new IllegalArgumentException("maxElapsedTime must be positive");
            }
            this.maxElapsedTimeMs = unit.toMillis(duration);
            return this;
        }

        public Builder baseFactor(double baseFactor) {
            if (baseFactor <= 0.0) {
                throw new IllegalArgumentException("baseFactor must be strictly positive");
            }
            this.baseFactor = baseFactor;
            return this;
        }

        @Deprecated
        public Builder exponent(double baseFactor) {
            if (baseFactor <= 0.0) {
                throw new IllegalArgumentException("baseFactor must be strictly positive");
            }
            this.baseFactor = baseFactor;
            return this;
        }

        public Builder jitterFactor(double jitterFactor) {
            if (jitterFactor < 0.0 || jitterFactor > 1.0) {
                throw new IllegalArgumentException("jitterFactor must be between 0 and 1");
            }
            this.jitterFactor = jitterFactor;
            return this;
        }

        public Builder retryConnectError(boolean retry) {
            this.retryConnectError = retry;
            return this;
        }

        public Builder throwConnectError() {
            this.retryConnectError = false;
            return this;
        }

        public Builder retryReadTimeoutError(boolean retry) {
            this.retryReadTimeoutError = retry;
            return this;
        }

        public Builder throwReadTimeoutError() {
            this.retryReadTimeoutError = false;
            return this;
        }

        public BackoffStrategy build() {
            return new BackoffStrategy(this.initialIntervalMs, this.maxIntervalMs, this.maxElapsedTimeMs, this.baseFactor, this.jitterFactor, this.retryConnectError, this.retryReadTimeoutError);
        }
    }
}

