/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.utils;

import com.clerk.backend_api.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public final class Globals {
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private final Map<String, String> pathParams = new HashMap<String, String>();
    private final Map<String, String> headerParams = new HashMap<String, String>();

    public void putParam(String type, String name, Object value) {
        if ("pathParam".equals(type)) {
            this.putPathParam(name, value);
        } else if ("queryParam".equals(type)) {
            this.putQueryParam(name, value);
        } else if ("header".equals(type)) {
            this.putHeader(name, value);
        } else {
            throw new IllegalArgumentException("Unknown parameter type: " + type);
        }
    }

    public Optional<String> getParam(String type, String name) {
        if ("pathParam".equals(type)) {
            return this.getPathParam(name);
        }
        if ("queryParam".equals(type)) {
            return this.getQueryParam(name);
        }
        if ("header".equals(type)) {
            return this.getHeader(name);
        }
        throw new IllegalArgumentException("Unknown parameter type: " + type);
    }

    public void putQueryParam(String name, Object value) {
        if (value != null) {
            this.queryParams.put(name, Utils.valToString(value));
        }
    }

    public void putPathParam(String name, Object value) {
        if (value != null) {
            this.pathParams.put(name, Utils.valToString(value));
        }
    }

    public void putHeader(String name, Object value) {
        if (value != null) {
            this.headerParams.put(name, Utils.valToString(value));
        }
    }

    public Optional<String> getQueryParam(String name) {
        return Optional.ofNullable(this.queryParams.get(name));
    }

    public Optional<String> getPathParam(String name) {
        return Optional.ofNullable(this.pathParams.get(name));
    }

    public Optional<String> getHeader(String name) {
        return Optional.ofNullable(this.headerParams.get(name));
    }

    public Stream<Map.Entry<String, String>> queryParamsAsStream() {
        return this.queryParams.entrySet().stream();
    }

    public Stream<Map.Entry<String, String>> pathParamsAsStream() {
        return this.pathParams.entrySet().stream();
    }

    public Stream<Map.Entry<String, String>> headerParamsAsStream() {
        return this.headerParams.entrySet().stream();
    }
}

