/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.utils;

import com.clerk.backend_api.utils.Exceptions;
import com.clerk.backend_api.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;

public final class Helpers {
    public static HttpRequest.Builder copy(HttpRequest request) {
        return Utils.copy(request);
    }

    public static HttpRequest.Builder copy(HttpRequest request, BiPredicate<String, String> filter) {
        return Utils.copy(request, filter);
    }

    public static byte[] bodyBytes(HttpRequest request) {
        return request.bodyPublisher().map(p -> {
            ByteBufferSubscriber sub = new ByteBufferSubscriber();
            p.subscribe(sub);
            return sub.bytes();
        }).orElse(new byte[0]);
    }

    public static String bodyUtf8(HttpRequest request) {
        return new String(Helpers.bodyBytes(request), StandardCharsets.UTF_8);
    }

    private static final class ByteBufferSubscriber
    implements Flow.Subscriber<ByteBuffer> {
        private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        private final CountDownLatch latch = new CountDownLatch(1);

        private ByteBufferSubscriber() {
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(ByteBuffer bb) {
            byte[] buffer = new byte[bb.remaining()];
            bb.get(buffer);
            try {
                this.bytes.write(buffer);
            }
            catch (IOException e) {
                this.onError(e);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.latch.countDown();
            Exceptions.rethrow(throwable);
        }

        @Override
        public void onComplete() {
            this.latch.countDown();
        }

        public byte[] bytes() {
            try {
                if (!this.latch.await(30L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("timed out waiting for next byte array");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.bytes.toByteArray();
        }
    }
}

