/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Reflections {
    public static Optional<?> getOpenEnumValue(Class<?> clazz, Object instance) {
        Objects.requireNonNull(clazz, "Class cannot be null");
        try {
            boolean hasFactoryMethod = Arrays.stream(clazz.getDeclaredMethods()).anyMatch(method -> Reflections.isValidFactoryMethod(method, clazz));
            if (!hasFactoryMethod) {
                return Optional.empty();
            }
            if (!Reflections.hasStaticConstants(clazz)) {
                return Optional.empty();
            }
            Method valueMethod = clazz.getMethod("value", new Class[0]);
            if (!Reflections.isValidValueMethod(valueMethod)) {
                return Optional.empty();
            }
            valueMethod.setAccessible(true);
            return Optional.of(valueMethod.invoke(instance, new Object[0]));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static boolean isNumericType(Class<?> type) {
        if (type.isPrimitive()) {
            return type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        return type == AtomicInteger.class || type == AtomicLong.class;
    }

    private static boolean isValidFactoryMethod(Method method, Class<?> clazz) {
        if (!"of".equals(method.getName())) {
            return false;
        }
        if (!Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(clazz)) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && (String.class.equals(parameterTypes[0]) || Reflections.isNumericType(parameterTypes[0]));
    }

    private static boolean isValidValueMethod(Method method) {
        return !Modifier.isStatic(method.getModifiers()) && (String.class.equals(method.getReturnType()) || Reflections.isNumericType(method.getReturnType()));
    }

    private static boolean hasStaticConstants(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).anyMatch(field -> {
            int modifiers = field.getModifiers();
            return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers) && clazz.equals(field.getType());
        });
    }
}

