/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.testcontainers.zookeeper;

import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class ZooKeeperContainer
extends GenericContainer<ZooKeeperContainer> {
    public static final String DEFAULT_TAG = "3.7";
    public static final String DEFAULT_IMAGE = "zookeeper";
    public static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"zookeeper").withTag("3.7");
    public static final Integer DEFAULT_CLIENT_PORT = 2181;
    public static final Integer DEFAULT_ADMIN_PORT = 8080;
    public static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofSeconds(60L);

    public ZooKeeperContainer() {
        this(DEFAULT_IMAGE_NAME, DEFAULT_STARTUP_TIMEOUT);
    }

    public ZooKeeperContainer(DockerImageName dockerImageName, Duration startUpTimeOut) {
        super(dockerImageName);
        this.withExposedPorts(new Integer[]{DEFAULT_CLIENT_PORT, DEFAULT_ADMIN_PORT});
        this.waitingFor(Wait.forListeningPort().withStartupTimeout(startUpTimeOut));
    }
}

