/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.play_widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.cleveroad.play_widget.OnShadowChangeListener;
import com.cleveroad.play_widget.R;
import com.cleveroad.play_widget.ShadowDrawable;
import com.cleveroad.play_widget.internal.DiffuserView;
import com.cleveroad.play_widget.internal.ProgressLineView;
import com.cleveroad.play_widget.internal.RoundRectImageView;
import com.cleveroad.play_widget.internal.Utils;

public class PlayLayout
extends RelativeLayout
implements OnShadowChangeListener {
    public static final int DEFAULT_DURATION = 430;
    public static final float SMALL_SHADOW_OPACITY = 0.75f;
    private static final int PROGRESS_LINE_ALPHA_ANIMATION_DURATION = 350;
    private static final float BIG_DIFFUSER_MIN_SHADOW_PERCENT = 0.25f;
    private static final float MEDIUM_DIFFUSER_MIN_SHADOW_PERCENT = 0.25f;
    private static final float SMALL_DIFFUSER_MIN_SHADOW_PERCENT = 0.3f;
    private ShadowPercentageProvider mShadowProvider;
    private ShadowDrawable mBigShadowDrawable;
    private ShadowDrawable mMediumShadowDrawable;
    private ShadowDrawable mSmallShadowDrawable;
    private AnimatorSet mRevealAnimatorSet = null;
    private AnimatorSet mDismissAnimatorSet = null;
    private FloatingActionButton mPlayButton;
    private int mDuration = 430;
    private RelativeLayout mRlImagesContainer;
    private RoundRectImageView mIvBackground;
    private DiffuserView mBigDiffuserImageView;
    private DiffuserView mMediumDiffuserImageView;
    private ImageView mSmallDiffuserImageView;
    private ProgressLineView mProgressLineView;
    private float mSmallDiffuserFullSize;
    private int mBigDiffuserShadowWidth;
    private int mMediumDiffuserShadowWidth;
    private int mSmallDiffuserShadowWidth;
    private float mRadiusPercentage = 0.0f;
    private int mButtonsSize;
    private int mDiffusersPadding;
    private ImageView mIvShuffle;
    private ImageView mIvSkipPrevious;
    private ImageView mIvSkipNext;
    private ImageView mIvRepeat;
    @Nullable
    private OnButtonsClickListener mClickListener;
    @Nullable
    private OnButtonsLongClickListener mLongClickListener;

    public PlayLayout(Context context) {
        this(context, null);
    }

    public PlayLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PlayLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public PlayLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.pw_reveal_view_content, (ViewGroup)this, true);
        this.mRlImagesContainer = (RelativeLayout)this.findViewById(R.id.pw_rlImagesContainer);
        this.mPlayButton = (FloatingActionButton)this.findViewById(R.id.pw_playButton);
        this.mIvBackground = (RoundRectImageView)this.findViewById(R.id.pw_ivBackground);
        this.mBigDiffuserImageView = (DiffuserView)this.findViewById(R.id.pw_ivBigDiffuser);
        this.mMediumDiffuserImageView = (DiffuserView)this.findViewById(R.id.pw_ivMediumDiffuser);
        this.mSmallDiffuserImageView = (ImageView)this.findViewById(R.id.pw_ivSmallDiffuser);
        this.mProgressLineView = (ProgressLineView)this.findViewById(R.id.pw_vProgressLine);
        this.mIvShuffle = (ImageView)this.findViewById(R.id.pw_ivShuffle);
        this.mIvSkipPrevious = (ImageView)this.findViewById(R.id.pw_ivSkipPrevious);
        this.mIvSkipNext = (ImageView)this.findViewById(R.id.pw_ivSkipNext);
        this.mIvRepeat = (ImageView)this.findViewById(R.id.pw_ivRepeat);
        this.initListeners();
        if (!this.isInEditMode()) {
            this.mProgressLineView.setAlpha(0.0f);
        }
        TypedArray typedArrayValues = context.obtainStyledAttributes(attrs, R.styleable.PlayWidget);
        this.mBigDiffuserShadowWidth = typedArrayValues.getDimensionPixelSize(R.styleable.PlayWidget_pw_big_diffuser_shadow_width, context.getResources().getDimensionPixelSize(R.dimen.pw_big_diffuser_shadow_width));
        this.mMediumDiffuserShadowWidth = typedArrayValues.getDimensionPixelSize(R.styleable.PlayWidget_pw_medium_diffuser_shadow_width, context.getResources().getDimensionPixelSize(R.dimen.pw_medium_diffuser_shadow_width));
        this.mSmallDiffuserShadowWidth = typedArrayValues.getDimensionPixelSize(R.styleable.PlayWidget_pw_small_diffuser_shadow_width, context.getResources().getDimensionPixelSize(R.dimen.pw_small_diffuser_shadow_width));
        this.mButtonsSize = typedArrayValues.getDimensionPixelSize(R.styleable.PlayWidget_pw_buttons_size, context.getResources().getDimensionPixelSize(R.dimen.pw_image_item_size));
        this.mBigDiffuserImageView.setShadowSize(this.mBigDiffuserShadowWidth);
        this.mMediumDiffuserImageView.setShadowSize(this.mMediumDiffuserShadowWidth);
        this.mProgressLineView.setEnabled(typedArrayValues.getBoolean(R.styleable.PlayWidget_pw_progress_line_enabled, true));
        this.mDiffusersPadding = typedArrayValues.getDimensionPixelSize(R.styleable.PlayWidget_pw_diffusers_padding, context.getResources().getDimensionPixelSize(R.dimen.pw_default_diffusers_padding));
        this.mProgressLineView.setPadding(typedArrayValues.getDimensionPixelSize(R.styleable.PlayWidget_pw_progress_line_padding, context.getResources().getDimensionPixelSize(R.dimen.pw_default_progress_line_padding)));
        int progressCompleteLineStrokeWidth = typedArrayValues.getDimensionPixelSize(R.styleable.PlayWidget_pw_progress_complete_line_stroke_width, context.getResources().getDimensionPixelSize(R.dimen.pw_progress_complete_line_stroke_width));
        int progressLineStrokeWidth = typedArrayValues.getDimensionPixelSize(R.styleable.PlayWidget_pw_progress_line_stroke_width, context.getResources().getDimensionPixelSize(R.dimen.pw_progress_line_stroke_width));
        int progressBallRadius = typedArrayValues.getDimensionPixelSize(R.styleable.PlayWidget_pw_progress_ball_radius, context.getResources().getDimensionPixelSize(R.dimen.pw_progress_ball_radius));
        if ((float)progressBallRadius * 2.0f < (float)progressCompleteLineStrokeWidth || (float)progressBallRadius * 2.0f < (float)progressLineStrokeWidth) {
            throw new IllegalStateException("Progress ball radius cannot be less then complete line stroke or line stroke");
        }
        this.mProgressLineView.setProgressCompleteLineStrokeWidth(progressCompleteLineStrokeWidth);
        this.mProgressLineView.setProgressBallRadius(progressBallRadius);
        this.mProgressLineView.setProgressLineStrokeWidth(progressLineStrokeWidth);
        Drawable d = typedArrayValues.getDrawable(R.styleable.PlayWidget_pw_image_src);
        if (d != null) {
            this.setImageDrawable(d);
        }
        int bigDiffuserColor = typedArrayValues.getColor(R.styleable.PlayWidget_pw_big_diffuser_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.pw_circle_color));
        int mediumDiffuserColor = typedArrayValues.getColor(R.styleable.PlayWidget_pw_medium_diffuser_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.pw_circle_color_translucent));
        this.setProgressLineColor(typedArrayValues.getColor(R.styleable.PlayWidget_pw_progress_line_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.pw_progress_line_color)));
        this.setProgressCompleteColor(typedArrayValues.getColor(R.styleable.PlayWidget_pw_progress_complete_line_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.pw_progress_complete_color)));
        this.setProgressBallColor(typedArrayValues.getColor(R.styleable.PlayWidget_pw_progress_ball_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.pw_progress_ball_color)));
        ColorStateList lFabBackgroundTint = typedArrayValues.getColorStateList(R.styleable.PlayWidget_pw_play_button_background_tint);
        if (lFabBackgroundTint != null) {
            this.mPlayButton.setBackgroundTintList(lFabBackgroundTint);
        }
        typedArrayValues.recycle();
        this.mSmallDiffuserFullSize = context.getResources().getDimensionPixelSize(R.dimen.pw_small_diffuser_size) + this.mSmallDiffuserShadowWidth * 2;
        this.mIvBackground.setColor(bigDiffuserColor);
        this.mBigShadowDrawable = new ShadowDrawable(this.getContext(), true);
        this.mBigShadowDrawable.hideShadow(false);
        this.setupDiffuserView((View)this.mBigDiffuserImageView, this.mBigShadowDrawable);
        this.mMediumDiffuserImageView.setColor(mediumDiffuserColor);
        this.mMediumDiffuserImageView.setMustDrawRevealAnimation(true);
        this.mMediumShadowDrawable = new ShadowDrawable(this.getContext());
        this.setupDiffuserView((View)this.mMediumDiffuserImageView, this.mMediumShadowDrawable);
        this.mMediumDiffuserImageView.setScaleX(0.0f);
        this.mMediumDiffuserImageView.setScaleY(0.0f);
        this.mSmallShadowDrawable = new ShadowDrawable(this.getContext());
        this.mSmallShadowDrawable.setup(this.mSmallDiffuserFullSize / 2.0f, this.mSmallDiffuserShadowWidth);
        this.setupDiffuserView((View)this.mSmallDiffuserImageView, this.mSmallShadowDrawable);
        this.mSmallShadowDrawable.hideShadow(false);
    }

    private void initListeners() {
        this.mIvShuffle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PlayLayout.this.mClickListener != null) {
                    PlayLayout.this.mClickListener.onShuffleClicked();
                }
            }
        });
        this.mIvSkipPrevious.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PlayLayout.this.mClickListener != null) {
                    PlayLayout.this.mClickListener.onSkipPreviousClicked();
                }
            }
        });
        this.mIvSkipNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PlayLayout.this.mClickListener != null) {
                    PlayLayout.this.mClickListener.onSkipNextClicked();
                }
            }
        });
        this.mIvRepeat.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PlayLayout.this.mClickListener != null) {
                    PlayLayout.this.mClickListener.onRepeatClicked();
                }
            }
        });
        this.mPlayButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PlayLayout.this.mClickListener != null) {
                    PlayLayout.this.mClickListener.onPlayButtonClicked();
                }
            }
        });
        this.mIvShuffle.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (PlayLayout.this.mLongClickListener != null) {
                    PlayLayout.this.mLongClickListener.onShuffleLongClicked();
                    return true;
                }
                return false;
            }
        });
        this.mIvSkipPrevious.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (PlayLayout.this.mLongClickListener != null) {
                    PlayLayout.this.mLongClickListener.onSkipPreviousLongClicked();
                    return true;
                }
                return false;
            }
        });
        this.mIvSkipNext.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (PlayLayout.this.mLongClickListener != null) {
                    PlayLayout.this.mLongClickListener.onSkipNextLongClicked();
                    return true;
                }
                return false;
            }
        });
        this.mIvRepeat.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (PlayLayout.this.mLongClickListener != null) {
                    PlayLayout.this.mLongClickListener.onRepeatLongClicked();
                    return true;
                }
                return false;
            }
        });
        this.mPlayButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (PlayLayout.this.mLongClickListener != null) {
                    PlayLayout.this.mLongClickListener.onPlayButtonLongClicked();
                    return true;
                }
                return false;
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mRlImagesContainer.setMinimumWidth(this.mPlayButton.getMeasuredWidth() + this.mButtonsSize * 4 + this.getContext().getResources().getDimensionPixelSize(R.dimen.pw_image_item_margin) * 4);
        this.mIvShuffle.getLayoutParams().width = this.mButtonsSize;
        this.mIvShuffle.getLayoutParams().height = this.mButtonsSize;
        this.mIvSkipPrevious.getLayoutParams().width = this.mButtonsSize;
        this.mIvSkipPrevious.getLayoutParams().height = this.mButtonsSize;
        this.mIvSkipNext.getLayoutParams().width = this.mButtonsSize;
        this.mIvSkipNext.getLayoutParams().height = this.mButtonsSize;
        this.mIvRepeat.getLayoutParams().width = this.mButtonsSize;
        this.mIvRepeat.getLayoutParams().height = this.mButtonsSize;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        int containerWidth = r - l - this.getPaddingLeft() - this.getPaddingRight();
        int containerHeight = b - t - this.getPaddingTop() - this.getPaddingBottom() - this.mPlayButton.getHeight();
        int containerSize = containerWidth < containerHeight ? containerWidth : containerHeight;
        int additionalPadding = (this.mRlImagesContainer.getMeasuredWidth() - containerSize) / 2;
        this.mRlImagesContainer.setPadding(0, 0, 0, this.mPlayButton.getHeight());
        this.mBigDiffuserImageView.layout(this.mDiffusersPadding + additionalPadding, this.mDiffusersPadding, containerSize - this.mDiffusersPadding + additionalPadding, containerSize - this.mDiffusersPadding);
        this.mProgressLineView.layout(additionalPadding, 0, containerSize + additionalPadding, containerSize);
        float bigDiffuserHalfRadius = (float)(this.mBigDiffuserImageView.getRight() - this.mBigDiffuserImageView.getLeft()) / 2.0f;
        this.mIvBackground.layout(this.mBigDiffuserShadowWidth + this.mDiffusersPadding + additionalPadding, this.mBigDiffuserShadowWidth + this.mDiffusersPadding, containerSize - this.mBigDiffuserShadowWidth - this.mDiffusersPadding + additionalPadding, containerSize - this.mBigDiffuserShadowWidth - this.mDiffusersPadding);
        this.mBigShadowDrawable.setup(bigDiffuserHalfRadius, this.mBigDiffuserShadowWidth);
        float mediumDiffuserHalfRadius = (bigDiffuserHalfRadius + (float)this.mPlayButton.getWidth()) / 2.2f;
        int mediumCircleShift = (int)(bigDiffuserHalfRadius - mediumDiffuserHalfRadius);
        this.mMediumDiffuserImageView.layout(this.mBigDiffuserImageView.getLeft() + mediumCircleShift, this.mBigDiffuserImageView.getTop() + mediumCircleShift, this.mBigDiffuserImageView.getRight() - mediumCircleShift, this.mBigDiffuserImageView.getBottom() - mediumCircleShift);
        this.mMediumShadowDrawable.setup(mediumDiffuserHalfRadius, this.mMediumDiffuserShadowWidth);
        int smallCircleShift = (int)(bigDiffuserHalfRadius - this.mSmallDiffuserFullSize / 2.0f);
        this.mSmallDiffuserImageView.layout(this.mBigDiffuserImageView.getLeft() + smallCircleShift, this.mBigDiffuserImageView.getTop() + smallCircleShift, this.mBigDiffuserImageView.getRight() - smallCircleShift, this.mBigDiffuserImageView.getBottom() - smallCircleShift);
        float smallDiffuserHalfRadius = this.mSmallDiffuserFullSize / 2.0f;
        this.mSmallShadowDrawable.setup(smallDiffuserHalfRadius, this.mSmallDiffuserShadowWidth);
        if (this.isOpenInner()) {
            this.mPlayButton.setTranslationY((float)this.calculateFabTransitionY());
        }
    }

    public void addView(View child) {
        if (child.getId() == R.id.pw_rlMainContainer) {
            super.addView(child);
        }
    }

    public void addView(View child, int index) {
        if (child.getId() == R.id.pw_rlMainContainer) {
            super.addView(child, index);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child.getId() == R.id.pw_rlMainContainer) {
            super.addView(child, index, params);
        }
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        if (child.getId() == R.id.pw_rlMainContainer) {
            super.addView(child, params);
        }
    }

    public void addView(View child, int width, int height) {
        if (child.getId() == R.id.pw_rlMainContainer) {
            super.addView(child, width, height);
        }
    }

    public void setOnButtonsClickListener(@Nullable OnButtonsClickListener listener) {
        this.mClickListener = listener;
    }

    public void setOnButtonsLongClickListener(@Nullable OnButtonsLongClickListener listener) {
        this.mLongClickListener = listener;
    }

    @TargetApi(value=16)
    private void setupDiffuserView(View ivDiffuser, Drawable background) {
        int currentApiVersion = Build.VERSION.SDK_INT;
        if (currentApiVersion > 15) {
            ivDiffuser.setBackground(background);
        } else {
            ivDiffuser.setBackgroundDrawable(background);
        }
    }

    private int calculateFabTransitionY() {
        return this.mSmallDiffuserImageView.getTop() + this.mSmallDiffuserImageView.getHeight() / 2 - this.mPlayButton.getTop() - this.mPlayButton.getHeight() / 2 + this.getPaddingTop();
    }

    public void fastOpen() {
        this.mIvBackground.setRevealDrawingAlpha(1.0f);
        this.mRadiusPercentage = 1.0f;
        if (this.mProgressLineView.isEnabled()) {
            this.mProgressLineView.setAlpha(1.0f);
        }
        this.mIvBackground.setRadiusPercentage(this.mRadiusPercentage);
        this.revealView();
    }

    public void startRevealAnimation() {
        if (this.mShadowProvider != null) {
            this.mShadowProvider.setAllowChangeShadow(true);
        }
        this.mBigShadowDrawable.setShadowSizeMultiplier(1.0f);
        this.mMediumShadowDrawable.setShadowSizeMultiplier(1.0f);
        this.mSmallShadowDrawable.setShadowSizeMultiplier(1.0f);
        this.mPlayButton.setImageResource(R.drawable.pw_pause);
        this.mIvBackground.setRevealDrawingAlpha(1.0f);
        this.mMediumDiffuserImageView.setAlpha(1.0f);
        this.mBigShadowDrawable.hideShadow(false);
        this.mSmallShadowDrawable.hideShadow(false);
        this.mIvBackground.setRevealAnimation(true);
        this.mMediumDiffuserImageView.setVisibility(0);
        if (this.mRevealAnimatorSet == null) {
            this.mRevealAnimatorSet = new AnimatorSet();
            ObjectAnimator centerYImageAnimator = ObjectAnimator.ofFloat((Object)((Object)this.mMediumDiffuserImageView), (String)"translationY", (float[])new float[]{this.getHeight() / 2, 0.0f});
            centerYImageAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.25f));
            ObjectAnimator scaleXImageAnimator = ObjectAnimator.ofFloat((Object)((Object)this.mMediumDiffuserImageView), (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator scaleYImageAnimator = ObjectAnimator.ofFloat((Object)((Object)this.mMediumDiffuserImageView), (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator alphaImageAnimator = ObjectAnimator.ofFloat((Object)((Object)this.mMediumDiffuserImageView), (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            alphaImageAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator(2.0f));
            ObjectAnimator radiusPercentageAnimator = ObjectAnimator.ofFloat((Object)this, (String)"radiusPercentage", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator fabTransitionAnimator = ObjectAnimator.ofFloat((Object)this.mPlayButton, (String)"translationY", (float[])new float[]{0.0f, this.calculateFabTransitionY()});
            fabTransitionAnimator.setInterpolator((TimeInterpolator)new OvershootInterpolator(0.8f));
            this.mRevealAnimatorSet.playTogether(new Animator[]{centerYImageAnimator, scaleXImageAnimator, scaleYImageAnimator, alphaImageAnimator, radiusPercentageAnimator, fabTransitionAnimator});
            this.mRevealAnimatorSet.setDuration((long)this.mDuration);
            this.mRevealAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    PlayLayout.this.mIvBackground.setRevealAnimation(false);
                    PlayLayout.this.mBigShadowDrawable.showShadow(true);
                    PlayLayout.this.mSmallShadowDrawable.showShadow(true, 0.75f);
                    ObjectAnimator.ofFloat((Object)((Object)PlayLayout.this.mProgressLineView), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(350L).start();
                }
            });
        }
        this.mRevealAnimatorSet.start();
    }

    private void revealView() {
        this.mPlayButton.setImageResource(R.drawable.pw_pause);
        this.mMediumDiffuserImageView.setRadiusPercentage(this.mRadiusPercentage);
        this.mMediumDiffuserImageView.setTranslationY(0.0f);
        this.mMediumDiffuserImageView.setScaleX(1.0f);
        this.mMediumDiffuserImageView.setScaleY(1.0f);
        this.mMediumDiffuserImageView.setAlpha(1.0f);
        this.mBigShadowDrawable.showShadow(false);
        this.mSmallShadowDrawable.showShadow(false, 0.75f);
    }

    public void startDismissAnimation() {
        if (this.mShadowProvider != null) {
            this.mShadowProvider.setAllowChangeShadow(false);
        }
        this.mIvBackground.setDismissAnimation(true);
        this.mMediumDiffuserImageView.setDismissAnimation(true);
        this.mBigShadowDrawable.hideShadow(true);
        ObjectAnimator progressViewDismissAnimator = ObjectAnimator.ofFloat((Object)((Object)this.mProgressLineView), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        progressViewDismissAnimator.setDuration(350L).start();
        this.mSmallShadowDrawable.hideShadow(true, 0.75f, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                Drawable fabPlayDrawable = Build.VERSION.SDK_INT >= 22 ? PlayLayout.this.getResources().getDrawable(R.drawable.pw_play, null) : PlayLayout.this.getResources().getDrawable(R.drawable.pw_play);
                PlayLayout.this.mPlayButton.setImageDrawable(fabPlayDrawable);
                if (PlayLayout.this.mDismissAnimatorSet == null) {
                    PlayLayout.this.mDismissAnimatorSet = new AnimatorSet();
                    ObjectAnimator alphaImageAnimator = ObjectAnimator.ofFloat((Object)((Object)PlayLayout.this.mMediumDiffuserImageView), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
                    alphaImageAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
                    ObjectAnimator alphaBigDiffuserAnimator = ObjectAnimator.ofFloat((Object)((Object)PlayLayout.this.mIvBackground), (String)"revealDrawingAlpha", (float[])new float[]{1.0f, 0.0f});
                    ObjectAnimator radiusPercentageAnimator = ObjectAnimator.ofFloat((Object)PlayLayout.this, (String)"radiusPercentage", (float[])new float[]{1.0f, 0.0f});
                    ObjectAnimator fabTransitionAnimator = ObjectAnimator.ofFloat((Object)PlayLayout.this.mPlayButton, (String)"translationY", (float[])new float[]{PlayLayout.this.calculateFabTransitionY(), 0.0f});
                    fabTransitionAnimator.setInterpolator((TimeInterpolator)new OvershootInterpolator(0.8f));
                    PlayLayout.this.mDismissAnimatorSet.playTogether(new Animator[]{alphaImageAnimator, radiusPercentageAnimator, alphaBigDiffuserAnimator, fabTransitionAnimator});
                    PlayLayout.this.mDismissAnimatorSet.setDuration((long)PlayLayout.this.mDuration);
                    PlayLayout.this.mDismissAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            super.onAnimationEnd(animation);
                            PlayLayout.this.mIvBackground.setDismissAnimation(false);
                            PlayLayout.this.mMediumDiffuserImageView.setDismissAnimation(false);
                        }
                    });
                }
                PlayLayout.this.mDismissAnimatorSet.start();
            }
        });
    }

    public void setProgress(float progress) {
        if (this.mProgressLineView.getVisibility() == 0) {
            this.mProgressLineView.setProgress(progress);
            this.mProgressLineView.invalidate();
        }
    }

    public void setPostProgress(final float progress) {
        this.post(new Runnable(){

            @Override
            public void run() {
                PlayLayout.this.setProgress(progress);
            }
        });
    }

    public void setImageResource(@DrawableRes int resId) {
        this.mIvBackground.setImageResource(resId);
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        this.mIvBackground.setImageDrawable(drawable2);
    }

    public void setImageURI(@Nullable Uri uri) {
        this.mIvBackground.setImageURI(uri);
    }

    public void setImageBitmap(Bitmap bm) {
        this.mIvBackground.setImageBitmap(bm);
    }

    public void setButtonsSize(int buttonsSize) {
        this.mButtonsSize = buttonsSize;
        this.requestLayout();
    }

    public void setButtonsSizeResource(@DimenRes int buttonsSizeRes) {
        this.setButtonsSize(this.getResources().getDimensionPixelSize(buttonsSizeRes));
    }

    public void setProgressEnabled(boolean enabled) {
        this.mProgressLineView.setEnabled(enabled);
    }

    public void setBigDiffuserShadowWidth(int shadowWidth) {
        this.mBigDiffuserShadowWidth = shadowWidth;
        this.mBigDiffuserImageView.setShadowSize(shadowWidth);
        this.requestLayout();
    }

    public void setBigDiffuserShadowWidthResource(@DimenRes int shadowWidth) {
        this.setBigDiffuserShadowWidth(this.getResources().getDimensionPixelSize(shadowWidth));
    }

    public void setMediumDiffuserShadowWidth(int shadowWidth) {
        this.mMediumDiffuserShadowWidth = shadowWidth;
        this.mMediumDiffuserImageView.setShadowSize(shadowWidth);
        this.requestLayout();
    }

    public void setMediumDiffuserShadowWidthResource(@DimenRes int shadowWidth) {
        this.setMediumDiffuserShadowWidth(this.getResources().getDimensionPixelSize(shadowWidth));
    }

    public void setSmallDiffuserShadowWidth(int shadowWidth) {
        this.mSmallDiffuserShadowWidth = shadowWidth;
        this.mSmallDiffuserFullSize = this.getContext().getResources().getDimensionPixelSize(R.dimen.pw_small_diffuser_size) + shadowWidth * 2;
        this.requestLayout();
    }

    public void setSmallDiffuserShadowWidthResource(@DimenRes int shadowWidth) {
        this.setSmallDiffuserShadowWidth(this.getResources().getDimensionPixelSize(shadowWidth));
    }

    public void setBigDiffuserColor(@ColorInt int color2) {
        this.mIvBackground.setColor(color2);
        this.mIvBackground.invalidate();
    }

    public void setBigDiffuserColorResource(@ColorRes int colorRes) {
        this.setBigDiffuserColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    public void setMediumDiffuserColor(@ColorInt int color2) {
        this.mMediumDiffuserImageView.setColor(color2);
        this.mMediumDiffuserImageView.invalidate();
    }

    public void setMediumDiffuserColorResource(@ColorRes int colorRes) {
        this.setMediumDiffuserColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    public void setPlayButtonBackgroundTintList(@Nullable ColorStateList tint) {
        this.mPlayButton.setBackgroundTintList(tint);
    }

    public void setProgressLinePadding(int padding) {
        this.mProgressLineView.setPadding(padding);
        this.requestLayout();
    }

    public void setProgressLinePadding(float padding) {
        this.mProgressLineView.setPadding(padding);
        this.requestLayout();
    }

    public void setProgressLinePaddingResource(@DimenRes int paddingRes) {
        this.setProgressLinePadding(this.getResources().getDimensionPixelSize(paddingRes));
    }

    public void setDiffusersPadding(int padding) {
        this.mDiffusersPadding = padding;
        this.requestLayout();
    }

    public void setDiffusersPaddingResource(@DimenRes int paddingRes) {
        this.setDiffusersPadding(this.getResources().getDimensionPixelSize(paddingRes));
    }

    public void setProgressBallRadius(float radius) {
        this.mProgressLineView.setProgressBallRadius(radius);
        this.requestLayout();
    }

    public void setProgressBallRadiusResource(@DimenRes int radiusRes) {
        this.setProgressBallRadius(this.getResources().getDimensionPixelSize(radiusRes));
    }

    public void setProgressCompleteLineStrokeWidth(float strokeWidth) {
        this.mProgressLineView.setProgressCompleteLineStrokeWidth(strokeWidth);
        this.requestLayout();
    }

    public void setProgressCompleteLineStrokeWidthResource(@DimenRes int strokeWidthRes) {
        this.setProgressCompleteLineStrokeWidth(this.getResources().getDimensionPixelSize(strokeWidthRes));
    }

    public void setProgressLineStrokeWidth(float strokeWidth) {
        this.mProgressLineView.setProgressLineStrokeWidth(strokeWidth);
        this.requestLayout();
    }

    public void setProgressLineStrokeWidthResource(@DimenRes int strokeWidthRes) {
        this.setProgressLineStrokeWidth(this.getResources().getDimensionPixelSize(strokeWidthRes));
    }

    public void setProgressLineColor(@ColorInt int color2) {
        this.mProgressLineView.setProgressLineColor(color2);
    }

    public void setProgressLineColorResource(@ColorRes int colorRes) {
        this.setProgressLineColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    public void setProgressCompleteColor(int color2) {
        this.mProgressLineView.setProgressCompleteColor(color2);
    }

    public void setProgressCompleteColorResource(@ColorRes int colorRes) {
        this.setProgressCompleteColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    public void setProgressBallColor(int color2) {
        color2 = Color.argb((int)255, (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
        this.mProgressLineView.setProgressBallColor(color2);
    }

    public void setProgressBallColorResource(@ColorRes int colorRes) {
        this.setProgressBallColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    public void setOnProgressChangedListener(@Nullable OnProgressChangedListener progressChangedListener) {
        this.mProgressLineView.setOnProgressChangedListener(progressChangedListener);
    }

    private boolean isOpenInner() {
        return this.mRadiusPercentage > 0.5f;
    }

    public boolean isOpen() {
        return this.isOpenInner();
    }

    private void setRadiusPercentage(float radiusPercentage) {
        this.mRadiusPercentage = radiusPercentage;
        this.mMediumDiffuserImageView.setRadiusPercentage(radiusPercentage);
        this.mIvBackground.setRadiusPercentage(radiusPercentage);
    }

    public void setShadowProvider(@NonNull ShadowPercentageProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("ShadowPercentageProvider cannot be null");
        }
        this.mShadowProvider = provider;
        provider.setShadowChangerListener(this);
        if (this.isOpenInner()) {
            provider.setAllowChangeShadow(true);
        }
    }

    @Override
    public void shadowChanged(float bigDiffuserShadowPercentage, float mediumDiffuserShadowPercentage, float smallDiffuserShadowPercentage) {
        this.mBigShadowDrawable.setShadowSizeMultiplier(Utils.betweenZeroOne(bigDiffuserShadowPercentage) * 0.75f + 0.25f);
        this.mMediumShadowDrawable.setShadowSizeMultiplier(Utils.betweenZeroOne(mediumDiffuserShadowPercentage) * 0.75f + 0.25f);
        this.mSmallShadowDrawable.setShadowSizeMultiplier(Utils.betweenZeroOne(smallDiffuserShadowPercentage) * 0.7f + 0.3f);
    }

    public ImageView getIvShuffle() {
        return this.mIvShuffle;
    }

    public ImageView getIvSkipPrevious() {
        return this.mIvSkipPrevious;
    }

    public ImageView getIvSkipNext() {
        return this.mIvSkipNext;
    }

    public ImageView getIvRepeat() {
        return this.mIvRepeat;
    }

    public FloatingActionButton getPlayButton() {
        return this.mPlayButton;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mShadowProvider != null) {
            this.mShadowProvider.setShadowChangerListener(this);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mShadowProvider != null) {
            this.mShadowProvider.setShadowChangerListener(null);
        }
        super.onDetachedFromWindow();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.radiusPercentage = this.mRadiusPercentage;
        ss.progressLineEnabled = this.mProgressLineView.isEnabled();
        ss.progress = this.mProgressLineView.getProgress();
        ss.bigDiffuserColor = this.mIvBackground.getColor();
        ss.mediumDiffuserColor = this.mMediumDiffuserImageView.getColor();
        ss.playButtonTint = this.mPlayButton.getBackgroundTintList();
        ss.bigDiffuserShadowWidth = this.mBigDiffuserShadowWidth;
        ss.mediumDiffuserShadowWidth = this.mMediumDiffuserShadowWidth;
        ss.smallDiffuserShadowWidth = this.mSmallDiffuserShadowWidth;
        ss.diffuserPadding = this.mDiffusersPadding;
        ss.progressViewPadding = this.mProgressLineView.getPadding();
        ss.buttonSize = this.mButtonsSize;
        ss.progressBallRadius = this.mProgressLineView.getProgressBallRadius();
        ss.progressCompleteStrokeWidth = this.mProgressLineView.getProgressCompleteLineStrokeWidth();
        ss.progressLineStrokeWidth = this.mProgressLineView.getProgressLineStrokeWidth();
        ss.progressBallColor = this.mProgressLineView.getProgressBallColor();
        ss.progressCompleteLineColor = this.mProgressLineView.getProgressCompleteLineColor();
        ss.progressLineColor = this.mProgressLineView.getProgressLineColor();
        if (this.mShadowProvider != null) {
            ss.isAllowShadowChanging = this.mShadowProvider.isAllowChangeShadow();
        }
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mRadiusPercentage = ss.radiusPercentage;
        this.mProgressLineView.setEnabled(ss.progressLineEnabled);
        if (this.mProgressLineView.isEnabled() && this.isOpenInner()) {
            this.setProgress(ss.progress);
            this.mProgressLineView.setAlpha(1.0f);
        }
        this.mIvBackground.setColor(ss.bigDiffuserColor);
        this.mMediumDiffuserImageView.setColor(ss.mediumDiffuserColor);
        this.mPlayButton.setBackgroundTintList(ss.playButtonTint);
        this.setBigDiffuserShadowWidth(ss.bigDiffuserShadowWidth);
        this.setMediumDiffuserShadowWidth(ss.mediumDiffuserShadowWidth);
        this.setSmallDiffuserShadowWidth(ss.smallDiffuserShadowWidth);
        this.setDiffusersPadding(ss.diffuserPadding);
        this.setProgressLinePadding(ss.progressViewPadding);
        this.setButtonsSize(ss.buttonSize);
        this.setProgressBallRadius(ss.progressBallRadius);
        this.setProgressCompleteLineStrokeWidth(ss.progressCompleteStrokeWidth);
        this.setProgressLineStrokeWidth(ss.progressLineStrokeWidth);
        this.setProgressBallColor(ss.progressBallColor);
        this.setProgressCompleteColor(ss.progressCompleteLineColor);
        this.setProgressLineColor(ss.progressLineColor);
        this.mIvBackground.setRevealDrawingAlpha(1.0f);
        this.mIvBackground.setRadiusPercentage(this.mRadiusPercentage);
        if (this.mShadowProvider != null) {
            this.mShadowProvider.setAllowChangeShadow(ss.isAllowShadowChanging);
        }
        if (this.isOpen()) {
            this.revealView();
        }
    }

    public static class Builder {
        private PlayLayout playLayout;

        public Builder(Context context) {
            this.playLayout = new PlayLayout(context);
        }

        public Builder setLayoutParams(ViewGroup.LayoutParams params) {
            this.playLayout.setLayoutParams(params);
            return this;
        }

        public Builder setImageResource(@DrawableRes int resId) {
            this.playLayout.setImageResource(resId);
            return this;
        }

        public Builder setImageDrawable(@Nullable Drawable drawable2) {
            this.playLayout.setImageDrawable(drawable2);
            return this;
        }

        public Builder setImageURI(@Nullable Uri uri) {
            this.playLayout.setImageURI(uri);
            return this;
        }

        public Builder setImageBitmap(Bitmap bm) {
            this.playLayout.setImageBitmap(bm);
            return this;
        }

        public Builder setButtonsSize(int buttonsSize) {
            this.playLayout.setButtonsSize(buttonsSize);
            return this;
        }

        public Builder setButtonsSizeResource(@DimenRes int buttonsSizeRes) {
            this.playLayout.setButtonsSizeResource(buttonsSizeRes);
            return this;
        }

        public Builder setProgressEnabled(boolean enabled) {
            this.playLayout.setProgressEnabled(enabled);
            return this;
        }

        public Builder setBigDiffuserShadowWidth(int shadowWidth) {
            this.playLayout.setBigDiffuserShadowWidth(shadowWidth);
            return this;
        }

        public Builder setBigDiffuserShadowWidthResource(@DimenRes int shadowWidth) {
            this.playLayout.setBigDiffuserShadowWidthResource(shadowWidth);
            return this;
        }

        public Builder setMediumDiffuserShadowWidth(int shadowWidth) {
            this.playLayout.setMediumDiffuserShadowWidth(shadowWidth);
            return this;
        }

        public Builder setMediumDiffuserShadowWidthResource(@DimenRes int shadowWidth) {
            this.playLayout.setMediumDiffuserShadowWidthResource(shadowWidth);
            return this;
        }

        public Builder setSmallDiffuserShadowWidth(int shadowWidth) {
            this.playLayout.setSmallDiffuserShadowWidth(shadowWidth);
            return this;
        }

        public Builder setSmallDiffuserShadowWidthResource(@DimenRes int shadowWidthRes) {
            this.playLayout.setSmallDiffuserShadowWidthResource(shadowWidthRes);
            return this;
        }

        public Builder setBigDiffuserColor(@ColorInt int color2) {
            this.playLayout.setBigDiffuserColor(color2);
            return this;
        }

        public Builder setBigDiffuserColorResource(@ColorRes int colorRes) {
            this.playLayout.setBigDiffuserColorResource(colorRes);
            return this;
        }

        public Builder setMediumDiffuserColor(@ColorInt int color2) {
            this.playLayout.setMediumDiffuserColor(color2);
            return this;
        }

        public Builder setMediumDiffuserColorResource(@ColorRes int colorRes) {
            this.playLayout.setMediumDiffuserColorResource(colorRes);
            return this;
        }

        public Builder setPlayButtonBackgroundTintList(@Nullable ColorStateList tint) {
            this.playLayout.setPlayButtonBackgroundTintList(tint);
            return this;
        }

        public Builder setProgressLinePadding(int padding) {
            this.playLayout.setProgressLinePadding(padding);
            return this;
        }

        public Builder setProgressLinePaddingResource(@DimenRes int paddingRes) {
            this.playLayout.setProgressLinePaddingResource(paddingRes);
            return this;
        }

        public Builder setDiffusersPadding(int padding) {
            this.playLayout.setDiffusersPadding(padding);
            return this;
        }

        public Builder setDiffusersPaddingResource(@DimenRes int paddingRes) {
            this.playLayout.setDiffusersPaddingResource(paddingRes);
            return this;
        }

        public Builder setProgressBallRadius(float radius) {
            this.playLayout.setProgressBallRadius(radius);
            return this;
        }

        public Builder setProgressBallRadiusResource(@DimenRes int radiusRes) {
            this.playLayout.setProgressBallRadiusResource(radiusRes);
            return this;
        }

        public Builder setProgressCompleteLineStrokeWidth(float strokeWidth) {
            this.playLayout.setProgressCompleteLineStrokeWidth(strokeWidth);
            return this;
        }

        public Builder setProgressCompleteLineStrokeWidthResource(@DimenRes int strokeWidthRes) {
            this.playLayout.setProgressCompleteLineStrokeWidthResource(strokeWidthRes);
            return this;
        }

        public Builder setProgressLineStrokeWidth(float strokeWidth) {
            this.playLayout.setProgressLineStrokeWidth(strokeWidth);
            return this;
        }

        public Builder setProgressLineStrokeWidthResource(@DimenRes int strokeWidthRes) {
            this.playLayout.setProgressLineStrokeWidthResource(strokeWidthRes);
            return this;
        }

        public Builder setProgressLineColor(@ColorInt int color2) {
            this.playLayout.setProgressLineColor(color2);
            return this;
        }

        public Builder setProgressLineColorResource(@ColorRes int colorRes) {
            this.playLayout.setProgressLineColorResource(colorRes);
            return this;
        }

        public Builder setProgressCompleteColor(int color2) {
            this.playLayout.setProgressCompleteColor(color2);
            return this;
        }

        public Builder setProgressCompleteColorResource(@ColorRes int colorRes) {
            this.playLayout.setProgressCompleteColorResource(colorRes);
            return this;
        }

        public Builder setProgressBallColor(int color2) {
            this.playLayout.setProgressBallColor(color2);
            return this;
        }

        public Builder setProgressBallColorResource(@ColorRes int colorRes) {
            this.playLayout.setProgressBallColor(colorRes);
            return this;
        }

        public Builder setProgressChangedListener(@Nullable OnProgressChangedListener progressChangedListener) {
            this.playLayout.setOnProgressChangedListener(progressChangedListener);
            return this;
        }

        public Builder setOnButtonsClickListener(@Nullable OnButtonsClickListener listener) {
            this.playLayout.setOnButtonsClickListener(listener);
            return this;
        }

        public Builder setOnButtonsLongClickListener(@Nullable OnButtonsLongClickListener listener) {
            this.playLayout.setOnButtonsLongClickListener(listener);
            return this;
        }

        public Builder setShadowProvider(@NonNull ShadowPercentageProvider provider) {
            this.playLayout.setShadowProvider(provider);
            return this;
        }

        public PlayLayout build() {
            return this.playLayout;
        }
    }

    public static abstract class OnButtonsLongClickListenerAdapter
    implements OnButtonsLongClickListener {
        @Override
        public void onShuffleLongClicked() {
        }

        @Override
        public void onSkipPreviousLongClicked() {
        }

        @Override
        public void onSkipNextLongClicked() {
        }

        @Override
        public void onRepeatLongClicked() {
        }

        @Override
        public void onPlayButtonLongClicked() {
        }
    }

    public static abstract class OnButtonsClickListenerAdapter
    implements OnButtonsClickListener {
        @Override
        public void onShuffleClicked() {
        }

        @Override
        public void onSkipPreviousClicked() {
        }

        @Override
        public void onSkipNextClicked() {
        }

        @Override
        public void onRepeatClicked() {
        }

        @Override
        public void onPlayButtonClicked() {
        }
    }

    public static interface OnButtonsLongClickListener {
        public void onShuffleLongClicked();

        public void onSkipPreviousLongClicked();

        public void onSkipNextLongClicked();

        public void onRepeatLongClicked();

        public void onPlayButtonLongClicked();
    }

    public static interface OnButtonsClickListener {
        public void onShuffleClicked();

        public void onSkipPreviousClicked();

        public void onSkipNextClicked();

        public void onRepeatClicked();

        public void onPlayButtonClicked();
    }

    public static interface OnProgressChangedListener {
        public void onPreSetProgress();

        public void onProgressChanged(float var1);
    }

    public static abstract class ShadowPercentageProvider {
        private boolean allowChangeShadow = false;
        private OnShadowChangeListener shadowChangedListener;

        private void setShadowChangerListener(OnShadowChangeListener listener) {
            this.shadowChangedListener = listener;
        }

        protected void changeShadow(float bigDiffuserShadowPercentage, float mediumDiffuserShadowPercentage, float smallDiffuserShadowPercentage) {
            if (this.shadowChangedListener != null && this.isAllowChangeShadow()) {
                this.shadowChangedListener.shadowChanged(bigDiffuserShadowPercentage, mediumDiffuserShadowPercentage, smallDiffuserShadowPercentage);
            }
        }

        public boolean isAllowChangeShadow() {
            return this.allowChangeShadow;
        }

        public void setAllowChangeShadow(boolean allowChangeShadow) {
            this.allowChangeShadow = allowChangeShadow;
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        private float radiusPercentage;
        private boolean progressLineEnabled;
        private float progress;
        private int bigDiffuserColor;
        private int mediumDiffuserColor;
        private ColorStateList playButtonTint;
        private int bigDiffuserShadowWidth;
        private int mediumDiffuserShadowWidth;
        private int smallDiffuserShadowWidth;
        private int diffuserPadding;
        private float progressViewPadding;
        private int buttonSize;
        private float progressBallRadius;
        private float progressCompleteStrokeWidth;
        private float progressLineStrokeWidth;
        private int progressBallColor;
        private int progressCompleteLineColor;
        private int progressLineColor;
        private boolean isAllowShadowChanging;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.radiusPercentage = in.readFloat();
            this.progressLineEnabled = in.readInt() == 1;
            this.progress = in.readFloat();
            this.bigDiffuserColor = in.readInt();
            this.mediumDiffuserColor = in.readInt();
            this.playButtonTint = (ColorStateList)in.readParcelable(ColorStateList.class.getClassLoader());
            this.bigDiffuserShadowWidth = in.readInt();
            this.mediumDiffuserShadowWidth = in.readInt();
            this.smallDiffuserShadowWidth = in.readInt();
            this.diffuserPadding = in.readInt();
            this.progressViewPadding = in.readInt();
            this.buttonSize = in.readInt();
            this.progressBallRadius = in.readFloat();
            this.progressCompleteLineColor = in.readInt();
            this.progressLineStrokeWidth = in.readInt();
            this.progressBallColor = in.readInt();
            this.progressCompleteLineColor = in.readInt();
            this.progressLineColor = in.readInt();
            this.isAllowShadowChanging = in.readInt() == 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloat(this.radiusPercentage);
            out.writeInt(this.progressLineEnabled ? 1 : 0);
            out.writeFloat(this.progress);
            out.writeInt(this.bigDiffuserColor);
            out.writeInt(this.mediumDiffuserColor);
            out.writeParcelable((Parcelable)this.playButtonTint, 0);
            out.writeInt(this.bigDiffuserShadowWidth);
            out.writeInt(this.mediumDiffuserShadowWidth);
            out.writeInt(this.smallDiffuserShadowWidth);
            out.writeInt(this.diffuserPadding);
            out.writeFloat(this.progressViewPadding);
            out.writeInt(this.buttonSize);
            out.writeFloat(this.progressBallRadius);
            out.writeFloat((float)this.progressCompleteLineColor);
            out.writeFloat(this.progressLineStrokeWidth);
            out.writeInt(this.progressBallColor);
            out.writeInt(this.progressCompleteLineColor);
            out.writeInt(this.progressLineColor);
            out.writeInt(this.isAllowShadowChanging ? 1 : 0);
        }
    }
}

