/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.play_widget;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import com.cleveroad.play_widget.R;
import com.cleveroad.play_widget.internal.Utils;

class ShadowDrawable
extends Drawable {
    private static final int SHADOW_ANIMATION_DURATION = 350;
    private float mShadowSizeMultiplier = 0.5f;
    private final Paint mCornerShadowPaint;
    private final RectF mContentBounds;
    private float mCornerRadius;
    private Path mCornerShadowPath;
    private float mFinalShadowSize;
    private float mShadowSize;
    private float mRawShadowSize;
    private boolean mDirty = true;
    private final int mShadowStartColor;
    private final int mShadowMiddleColor;
    private final int mShadowEndColor;

    public ShadowDrawable(Context context) {
        this(context, false);
    }

    public ShadowDrawable(Context context, boolean hard) {
        if (hard) {
            this.mShadowStartColor = ContextCompat.getColor((Context)context, (int)R.color.pw_shadow_start_color_hard);
            this.mShadowMiddleColor = ContextCompat.getColor((Context)context, (int)R.color.pw_shadow_mid_color_hard);
            this.mShadowEndColor = ContextCompat.getColor((Context)context, (int)R.color.pw_shadow_end_color_hard);
        } else {
            this.mShadowStartColor = ContextCompat.getColor((Context)context, (int)R.color.pw_shadow_start_color);
            this.mShadowMiddleColor = ContextCompat.getColor((Context)context, (int)R.color.pw_shadow_mid_color);
            this.mShadowEndColor = ContextCompat.getColor((Context)context, (int)R.color.pw_shadow_end_color);
        }
        this.mCornerShadowPaint = new Paint(5);
        this.mCornerShadowPaint.setStyle(Paint.Style.FILL);
        this.mContentBounds = new RectF();
    }

    public void setup(float radius, float pShadowSize) {
        this.mCornerRadius = (float)Math.round(radius) - pShadowSize;
        this.mFinalShadowSize = pShadowSize;
        this.setShadowSize(pShadowSize);
    }

    private static int toEven(float value) {
        int i = Math.round(value);
        return i % 2 == 1 ? i - 1 : i;
    }

    public void setAlpha(int alpha) {
        this.mCornerShadowPaint.setAlpha(alpha);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public void setShadowSizeMultiplier(float multiplier) {
        this.mShadowSizeMultiplier = multiplier;
        this.setShadowSize(this.mFinalShadowSize, true);
    }

    protected void onBoundsChange(Rect bounds) {
        this.mDirty = true;
    }

    void setShadowSize(float pShadowSize) {
        this.setShadowSize(pShadowSize, true);
    }

    void setShadowSize(float pShadowSize, boolean hardSet) {
        if (pShadowSize < 0.0f) {
            throw new IllegalArgumentException("invalid shadow size");
        }
        if (this.mRawShadowSize == (pShadowSize = (float)ShadowDrawable.toEven(pShadowSize)) && !hardSet) {
            return;
        }
        this.mRawShadowSize = pShadowSize;
        this.mShadowSize = Math.round(pShadowSize * this.mShadowSizeMultiplier);
        this.mDirty = true;
        this.invalidateSelf();
    }

    public boolean getPadding(@NonNull Rect padding) {
        int vOffset = (int)Math.ceil(this.mRawShadowSize * this.mShadowSizeMultiplier);
        int hOffset = (int)Math.ceil(this.mRawShadowSize);
        padding.set(hOffset, vOffset, hOffset, vOffset);
        return true;
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(Canvas canvas) {
        if (this.mDirty) {
            this.buildComponents(this.getBounds());
            this.mDirty = false;
        }
        this.drawShadow(canvas);
    }

    private void drawShadow(Canvas canvas) {
        int rotateSaved = canvas.save();
        int saved = canvas.save();
        canvas.translate(this.mContentBounds.left + this.mCornerRadius, this.mContentBounds.top + this.mCornerRadius);
        canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        canvas.translate(this.mContentBounds.right - this.mCornerRadius, this.mContentBounds.bottom - this.mCornerRadius);
        canvas.rotate(180.0f);
        canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        canvas.translate(this.mContentBounds.left + this.mCornerRadius, this.mContentBounds.bottom - this.mCornerRadius);
        canvas.rotate(270.0f);
        canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        canvas.translate(this.mContentBounds.right - this.mCornerRadius, this.mContentBounds.top + this.mCornerRadius);
        canvas.rotate(90.0f);
        canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
        canvas.restoreToCount(saved);
        canvas.restoreToCount(rotateSaved);
    }

    private void buildShadowCorners() {
        RectF innerBounds = new RectF(-this.mCornerRadius, -this.mCornerRadius, this.mCornerRadius, this.mCornerRadius);
        RectF outerBounds = new RectF(innerBounds);
        outerBounds.inset(-this.mShadowSize, -this.mShadowSize);
        if (this.mCornerShadowPath == null) {
            this.mCornerShadowPath = new Path();
        } else {
            this.mCornerShadowPath.reset();
        }
        this.mCornerShadowPath.setFillType(Path.FillType.EVEN_ODD);
        this.mCornerShadowPath.moveTo(-this.mCornerRadius, 0.0f);
        this.mCornerShadowPath.rLineTo(-this.mShadowSize, 0.0f);
        this.mCornerShadowPath.arcTo(outerBounds, 180.0f, 90.0f, false);
        this.mCornerShadowPath.arcTo(innerBounds, 270.0f, -90.0f, false);
        this.mCornerShadowPath.close();
        float shadowRadius = -outerBounds.top;
        if (shadowRadius > 0.0f) {
            float startRatio = this.mCornerRadius / shadowRadius;
            float midRatio = startRatio + (1.0f - startRatio) / 2.0f;
            RadialGradient gradient = new RadialGradient(0.0f, 0.0f, shadowRadius, new int[]{0, this.mShadowStartColor, this.mShadowMiddleColor, this.mShadowEndColor}, new float[]{0.0f, startRatio, midRatio, 1.0f}, Shader.TileMode.CLAMP);
            this.mCornerShadowPaint.setShader((Shader)gradient);
        }
    }

    private void buildComponents(Rect bounds) {
        float verticalOffset = this.mRawShadowSize;
        this.mContentBounds.set((float)bounds.left + this.mRawShadowSize, (float)bounds.top + verticalOffset, (float)bounds.right - this.mRawShadowSize, (float)bounds.bottom - verticalOffset);
        this.mCornerRadius = (this.mContentBounds.bottom - this.mContentBounds.top) / 2.0f;
        this.buildShadowCorners();
    }

    public void showShadow(boolean animated) {
        this.showShadow(animated, 1.0f);
    }

    public void showShadow(boolean animated, float percentage) {
        percentage = Utils.betweenZeroOne(percentage);
        if (animated) {
            ObjectAnimator.ofInt((Object)((Object)this), (String)"alpha", (int[])new int[]{0, (int)(255.0f * percentage)}).setDuration(350L).start();
        } else {
            this.setAlpha((int)(255.0f * percentage));
        }
    }

    public void hideShadow(boolean animated) {
        this.hideShadow(animated, 1.0f, null);
    }

    public void hideShadow(boolean animated, float percentage, Animator.AnimatorListener listener) {
        percentage = Utils.betweenZeroOne(percentage);
        if (animated) {
            ObjectAnimator animator = ObjectAnimator.ofInt((Object)((Object)this), (String)"alpha", (int[])new int[]{(int)(255.0f * percentage), 0}).setDuration(350L);
            if (listener != null) {
                animator.addListener(listener);
            }
            animator.start();
        } else {
            this.setAlpha(0);
        }
    }
}

