/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.play_widget;

import android.media.audiofx.Visualizer;
import com.cleveroad.play_widget.PlayLayout;

public class VisualizerShadowChanger
extends PlayLayout.ShadowPercentageProvider
implements Visualizer.OnDataCaptureListener {
    private boolean mVisualisationEnabled = false;
    private static final float MAX_DB_VALUE = 45.0f;
    private static final int LOW_FREQUENCY = 300;
    private static final int MID_FREQUENCY = 2500;
    private static final int HIGH_FREQUENCY = 3000;
    private static final float[] SOUND_INDEX_COEFFICIENTS = new float[]{0.006802721f, 0.05668934f, 0.06802721f};
    private static final float FILTRATION_ALPHA = 0.55f;
    private static final float FILTRATION_BETA = 0.45f;
    private float[] mDbsPercentagesConcrete = new float[SOUND_INDEX_COEFFICIENTS.length];
    private Visualizer mVisualizer;

    private VisualizerShadowChanger(int audioSessionId) {
        this.mVisualizer = new Visualizer(audioSessionId);
        this.mVisualizer.setCaptureSize(Visualizer.getCaptureSizeRange()[1]);
        this.mVisualizer.setDataCaptureListener((Visualizer.OnDataCaptureListener)this, Visualizer.getMaxCaptureRate(), false, true);
    }

    public static VisualizerShadowChanger newInstance(int audioSessionId) {
        return new VisualizerShadowChanger(audioSessionId);
    }

    public void setEnabledVisualization(boolean enabled) {
        this.mVisualisationEnabled = enabled;
        this.updateVisualisationEnable();
    }

    public void release() {
        if (this.mVisualizer != null) {
            this.mVisualizer.release();
        }
        this.mVisualizer = null;
    }

    private void updateVisualisationEnable() {
        if (this.mVisualizer != null) {
            this.mVisualizer.setEnabled(this.mVisualisationEnabled && this.isAllowChangeShadow());
        }
    }

    @Override
    public void setAllowChangeShadow(boolean allowChangeShadow) {
        super.setAllowChangeShadow(allowChangeShadow);
        this.updateVisualisationEnable();
    }

    public void onWaveFormDataCapture(Visualizer visualizer, byte[] waveform, int samplingRate) {
    }

    public void onFftDataCapture(Visualizer visualizer, byte[] fft, int samplingRate) {
        int dataSize = fft.length / 2 - 1;
        for (int i = 0; i < SOUND_INDEX_COEFFICIENTS.length; ++i) {
            int index = (int)(SOUND_INDEX_COEFFICIENTS[i] * (float)dataSize);
            byte real = fft[2 * index];
            byte imag = fft[2 * index + 1];
            long magnitudeSquare = real * real + imag * imag;
            float dbs = this.magnitudeToDb(magnitudeSquare = (long)Math.sqrt(magnitudeSquare));
            float dbPercentage = dbs / 45.0f;
            if (dbPercentage > 1.0f) {
                dbPercentage = 1.0f;
            }
            this.mDbsPercentagesConcrete[i] = this.mDbsPercentagesConcrete[i] * 0.55f + dbPercentage * 0.45f;
        }
        this.changeShadow(this.mDbsPercentagesConcrete[0], this.mDbsPercentagesConcrete[1], this.mDbsPercentagesConcrete[2]);
    }

    private float magnitudeToDb(float squareMag) {
        if (squareMag == 0.0f) {
            return 0.0f;
        }
        return (float)(20.0 * Math.log10(squareMag));
    }
}

