/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.play_widget.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.widget.ImageView;

public class DiffuserView
extends ImageView {
    private float mRadiusPercentage = 0.0f;
    private boolean mDismissAnimation = false;
    private final Paint mPaint = new Paint(1);
    private final RectF mRect = new RectF();
    private boolean mMustDrawRevealAnimation = false;
    private int mShadowSize = 0;

    public DiffuserView(Context context) {
        this(context, null);
    }

    public DiffuserView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DiffuserView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public DiffuserView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(Color.argb((int)100, (int)200, (int)50, (int)200));
        this.mPaint.setAntiAlias(true);
    }

    public void setShadowSize(int shadowSize) {
        this.mShadowSize = shadowSize;
    }

    public void setColor(int color2) {
        this.mPaint.setColor(color2);
    }

    @ColorInt
    public int getColor() {
        return this.mPaint.getColor();
    }

    protected void onDraw(Canvas canvas) {
        if (!this.mMustDrawRevealAnimation) {
            super.onDraw(canvas);
            return;
        }
        this.mRect.set((float)this.mShadowSize, (float)this.mShadowSize, (float)(this.getWidth() - this.mShadowSize), (float)(this.getWidth() - this.mShadowSize));
        if (canvas.getHeight() < 1) {
            return;
        }
        float halfSize = (this.mRect.right - this.mRect.left) / 2.0f;
        if (!this.mDismissAnimation) {
            canvas.drawCircle(this.mRect.left + halfSize, this.mRect.top + halfSize, halfSize, this.mPaint);
            return;
        }
        if (this.mDismissAnimation) {
            canvas.drawRoundRect(this.mRect, halfSize * this.mRadiusPercentage, halfSize * this.mRadiusPercentage, this.mPaint);
        } else {
            canvas.drawCircle(this.mRect.left + halfSize, this.mRect.top + halfSize, halfSize, this.mPaint);
        }
    }

    public void setRadiusPercentage(float radiusPercentage) {
        this.mRadiusPercentage = radiusPercentage;
        this.invalidate();
    }

    public void setDismissAnimation(boolean dismissAnimation) {
        this.mDismissAnimation = dismissAnimation;
    }

    public void setMustDrawRevealAnimation(boolean mustDrawRevealAnimation) {
        this.mMustDrawRevealAnimation = mustDrawRevealAnimation;
    }
}

