/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.play_widget.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ImageView;
import com.cleveroad.play_widget.PlayLayout;
import com.cleveroad.play_widget.R;
import com.cleveroad.play_widget.internal.Utils;

public class ProgressLineView
extends ImageView {
    private static final int ADDITIONAL_PROGRESS_DEGREE = 20;
    private static final float BEGIN_PROGRESS_DEGREE = 160.0f;
    private static final float END_PROGRESS_DEGREE = 380.0f;
    private float mProgressCompleteLineStrokeWidth = 20.0f;
    private float mProgressLineStrokeWidth = 16.0f;
    private float mProgressBallRadius = 20.0f;
    private float mProgressCurveRadius;
    private float mPadding = 0.0f;
    private RectF mProgressBallRectF = new RectF();
    private Paint mLinePaint;
    private Paint mProgressPaint;
    private Paint mProgressBallPaint;
    private RectF mRect;
    private PointF mProgressPointCenter;
    private float mProgress = 0.0f;
    private int mAllowedTouchRadius = 10;
    private boolean mHandledTouch = false;
    private PlayLayout.OnProgressChangedListener mProgressChangedListener;

    public ProgressLineView(Context context) {
        this(context, null);
    }

    public ProgressLineView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressLineView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    @TargetApi(value=21)
    public ProgressLineView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mAllowedTouchRadius = this.getContext().getResources().getDimensionPixelSize(R.dimen.pw_progress_line_view_touch_radius);
        this.mRect = new RectF();
        this.mProgressPointCenter = new PointF();
        this.mLinePaint = new Paint();
        this.mLinePaint.setAntiAlias(true);
        this.mLinePaint.setStyle(Paint.Style.STROKE);
        this.mLinePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mLinePaint.setStrokeWidth(this.mProgressLineStrokeWidth);
        this.setProgressLineColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.pw_progress_line_color));
        this.mProgressPaint = new Paint();
        this.mProgressPaint.setAntiAlias(true);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mProgressPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mProgressPaint.setStrokeWidth(this.mProgressCompleteLineStrokeWidth);
        this.setProgressCompleteColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.pw_progress_complete_color));
        this.mProgressBallPaint = new Paint();
        this.mProgressBallPaint.setStyle(Paint.Style.FILL);
        this.mProgressBallPaint.setAntiAlias(true);
        this.mProgressBallPaint.setStrokeWidth(1.0f);
        this.setProgressBallColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.pw_progress_ball_color));
    }

    public void setProgress(float progress) {
        if (!this.mHandledTouch) {
            this.mProgress = Utils.betweenZeroOne(progress);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.recalculateRect();
    }

    private void recalculateRect() {
        this.mRect.set(this.mProgressBallRadius + this.mPadding, this.mProgressBallRadius + this.mPadding, (float)this.getWidth() - this.mProgressBallRadius - this.mPadding, (float)this.getWidth() - this.mProgressBallRadius - this.mPadding);
        this.mProgressCurveRadius = (this.mRect.right - this.mRect.left) / 2.0f;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int halfSize = this.getWidth() / 2;
        float x_center_offset = event.getX() - (float)halfSize;
        float y_center_offset = (float)halfSize - event.getY();
        double touchPointDistanceToCenter = Math.sqrt(y_center_offset * y_center_offset + x_center_offset * x_center_offset);
        double tanAngle = Math.atan2(y_center_offset, x_center_offset) * 180.0 / Math.PI;
        tanAngle = tanAngle < 0.0 ? (tanAngle *= -1.0) : 360.0 - tanAngle;
        if (tanAngle < 90.0) {
            tanAngle += 360.0;
        }
        if (event.getAction() == 0 && this.mProgressChangedListener != null) {
            this.mProgressChangedListener.onPreSetProgress();
        }
        if (event.getAction() == 1) {
            if (this.mHandledTouch && this.mProgressChangedListener != null) {
                this.mProgressChangedListener.onProgressChanged(this.mProgress);
            }
            this.mHandledTouch = false;
            return super.onTouchEvent(event);
        }
        if (!this.mHandledTouch && (tanAngle < 160.0 || tanAngle > 380.0)) {
            return super.onTouchEvent(event);
        }
        float radius = this.mProgressCurveRadius;
        if (this.mHandledTouch || touchPointDistanceToCenter > (double)(radius - (float)this.mAllowedTouchRadius) && touchPointDistanceToCenter < (double)(radius + (float)this.mAllowedTouchRadius)) {
            double progressAngle = tanAngle - 160.0;
            if (tanAngle < 160.0) {
                progressAngle = 0.0;
            } else if (tanAngle > 380.0) {
                progressAngle = 220.0;
            }
            this.mProgress = (float)(progressAngle / 220.0);
            this.mHandledTouch = true;
            this.invalidate();
            return true;
        }
        return super.onTouchEvent(event);
    }

    protected void onDraw(Canvas canvas) {
        float fullProgressDegree = 220.0f * this.mProgress;
        if (fullProgressDegree > 0.05f) {
            canvas.drawArc(this.mRect, 160.0f, fullProgressDegree, false, this.mProgressPaint);
        }
        float ballPositionAngle = 160.0f + fullProgressDegree;
        float progressBalX = this.mProgressCurveRadius + this.mProgressBallRadius + this.mPadding + (float)((double)this.mProgressCurveRadius * Math.cos((double)ballPositionAngle * Math.PI / 180.0));
        float progressBalY = this.mProgressCurveRadius + this.mProgressBallRadius + this.mPadding + (float)((double)this.mProgressCurveRadius * Math.sin((double)ballPositionAngle * Math.PI / 180.0));
        this.mProgressPointCenter.set(progressBalX, progressBalY);
        this.mProgressBallRectF.set(this.mProgressPointCenter.x - this.mProgressBallRadius, this.mProgressPointCenter.y - this.mProgressBallRadius, this.mProgressPointCenter.x + this.mProgressBallRadius, this.mProgressPointCenter.y + this.mProgressBallRadius);
        canvas.drawArc(this.mRect, ballPositionAngle, 380.0f - ballPositionAngle, false, this.mLinePaint);
        canvas.drawCircle(this.mProgressPointCenter.x, this.mProgressPointCenter.y, this.mProgressBallRadius, this.mProgressBallPaint);
    }

    public void setProgressLineColor(int progressLineColor) {
        this.mLinePaint.setColor(progressLineColor);
    }

    public void setProgressCompleteColor(int progressCompleteColor) {
        this.mProgressPaint.setColor(progressCompleteColor);
    }

    public void setProgressBallColor(int progressBallColor) {
        int color2 = Color.rgb((int)Color.red((int)progressBallColor), (int)Color.green((int)progressBallColor), (int)Color.blue((int)progressBallColor));
        this.mProgressBallPaint.setColor(color2);
    }

    public void setProgressCompleteLineStrokeWidth(float progressCompleteLineStrokeWidth) {
        this.mProgressCompleteLineStrokeWidth = progressCompleteLineStrokeWidth;
        this.mProgressPaint.setStrokeWidth(progressCompleteLineStrokeWidth);
    }

    public float getProgressCompleteLineStrokeWidth() {
        return this.mProgressCompleteLineStrokeWidth;
    }

    public void setProgressLineStrokeWidth(float progressLineStrokeWidth) {
        this.mProgressLineStrokeWidth = progressLineStrokeWidth;
        this.mLinePaint.setStrokeWidth(progressLineStrokeWidth);
    }

    public float getProgressLineStrokeWidth() {
        return this.mProgressLineStrokeWidth;
    }

    public void setProgressBallRadius(float progressBallRadius) {
        this.mProgressBallRadius = progressBallRadius;
        int defaultTouchRadius = this.getContext().getResources().getDimensionPixelSize(R.dimen.pw_progress_line_view_touch_radius);
        this.mAllowedTouchRadius = (float)defaultTouchRadius < this.mProgressBallRadius ? (int)this.mProgressBallRadius : defaultTouchRadius;
    }

    public float getProgressBallRadius() {
        return this.mProgressBallRadius;
    }

    @ColorInt
    public int getProgressBallColor() {
        return this.mProgressBallPaint.getColor();
    }

    @ColorInt
    public int getProgressCompleteLineColor() {
        return this.mProgressPaint.getColor();
    }

    @ColorInt
    public int getProgressLineColor() {
        return this.mLinePaint.getColor();
    }

    public float getProgress() {
        return this.mProgress;
    }

    public void setEnabled(boolean enabled) {
        this.setVisibility(enabled ? 0 : 8);
    }

    public boolean isEnabled() {
        return this.getVisibility() == 0;
    }

    public void setPadding(float padding) {
        this.mPadding = padding;
        this.recalculateRect();
    }

    public float getPadding() {
        return this.mPadding;
    }

    public void setOnProgressChangedListener(@Nullable PlayLayout.OnProgressChangedListener progressChangedListener) {
        this.mProgressChangedListener = progressChangedListener;
    }
}

