/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.play_widget.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

public class RoundRectImageView
extends ImageView {
    private Paint mPaint;
    private Paint mMaskPaint;
    private Paint mCirclePaint;
    @ColorInt
    private int mColor;
    private Bitmap mAnimationMaskBitmap;
    private Canvas mAnimationMaskCanvas;
    private float mRadiusPercentage = 0.0f;
    private int mColorAlpha;
    private boolean mRevealAnimation = false;
    private boolean mDismissAnimation = false;
    private RectF mRectF = new RectF();
    private int mSize;

    public RoundRectImageView(Context context) {
        this(context, null);
    }

    public RoundRectImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundRectImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    @TargetApi(value=21)
    public RoundRectImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setLayerType(2, null);
        this.mColor = Color.argb((int)100, (int)200, (int)50, (int)50);
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setColor(this.mColor);
        this.mCirclePaint.setAntiAlias(true);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(-16777216);
        this.mMaskPaint = new Paint();
        this.mMaskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
    }

    public void setColor(@ColorInt int color2) {
        this.mColor = color2;
        this.mCirclePaint.setColor(color2);
        this.mColorAlpha = Color.alpha((int)color2);
    }

    @ColorInt
    public int getColor() {
        return this.mColor;
    }

    public void onDraw(Canvas canvas) {
        this.mRectF.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getWidth() - this.getPaddingBottom()));
        float halfSize = (this.mRectF.right - this.mRectF.left) / 2.0f;
        super.onDraw(canvas);
        if (this.mRevealAnimation) {
            float radius = halfSize * 1.5f * this.mRadiusPercentage;
            canvas.drawCircle(this.mRectF.left + halfSize, this.mRectF.bottom - halfSize * this.mRadiusPercentage, radius, this.mCirclePaint);
        } else if (this.mDismissAnimation) {
            canvas.drawRoundRect(this.mRectF, halfSize * this.mRadiusPercentage, halfSize * this.mRadiusPercentage, this.mCirclePaint);
        } else if (this.mRadiusPercentage > 0.5f) {
            canvas.drawCircle(this.mRectF.left + halfSize, this.mRectF.top + halfSize, halfSize, this.mCirclePaint);
        }
        if (this.mAnimationMaskCanvas != null) {
            this.mAnimationMaskCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
            this.mAnimationMaskCanvas.drawRoundRect(this.mRectF, (float)(canvas.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) * this.mRadiusPercentage / 2.0f, (float)(canvas.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) * this.mRadiusPercentage / 2.0f, this.mPaint);
            canvas.drawBitmap(this.mAnimationMaskBitmap, 0.0f, 0.0f, this.mMaskPaint);
        }
    }

    public void setRevealDrawingAlpha(float alpha) {
        this.mCirclePaint.setAlpha((int)(alpha * (float)this.mColorAlpha));
    }

    public void setRadiusPercentage(float radiusPercentage) {
        this.mRadiusPercentage = radiusPercentage;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int newSize = Math.min(widthSize, heightSize);
        this.setMeasuredDimension(newSize, newSize);
        if (this.mAnimationMaskBitmap == null || this.mSize != newSize) {
            this.mAnimationMaskBitmap = Bitmap.createBitmap((int)newSize, (int)newSize, (Bitmap.Config)Bitmap.Config.ARGB_4444);
            this.mAnimationMaskCanvas = new Canvas(this.mAnimationMaskBitmap);
        }
        this.mSize = newSize;
    }

    protected void onDetachedFromWindow() {
        this.mAnimationMaskCanvas = null;
        if (this.mAnimationMaskBitmap != null) {
            this.mAnimationMaskBitmap.recycle();
            this.mAnimationMaskBitmap = null;
        }
        super.onDetachedFromWindow();
    }

    public void setRevealAnimation(boolean revealAnimation) {
        this.mRevealAnimation = revealAnimation;
    }

    public void setDismissAnimation(boolean dismissAnimation) {
        this.mDismissAnimation = dismissAnimation;
    }
}

