/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface PushConstants {
    public static final String LOG_TAG = "PushProvider";
    public static final String FCM_LOG_TAG = PushType.FCM.toString();
    @NonNull
    public static final String FCM_DELIVERY_TYPE = "fcm";
    @NonNull
    public static final String BAIDU_DELIVERY_TYPE = "bps";
    @NonNull
    public static final String HMS_DELIVERY_TYPE = "hps";
    @NonNull
    public static final String XIAOMI_DELIVERY_TYPE = "xps";
    @NonNull
    public static final String ADM_DELIVERY_TYPE = "adm";
    public static final String CT_FIREBASE_PROVIDER_CLASS = "com.clevertap.android.sdk.pushnotification.fcm.FcmPushProvider";
    public static final String CT_XIAOMI_PROVIDER_CLASS = "com.clevertap.android.xps.XiaomiPushProvider";
    public static final String CT_BAIDU_PROVIDER_CLASS = "com.clevertap.android.bps.BaiduPushProvider";
    public static final String CT_HUAWEI_PROVIDER_CLASS = "com.clevertap.android.hms.HmsPushProvider";
    public static final String CT_ADM_PROVIDER_CLASS = "com.clevertap.android.adm.AmazonPushProvider";
    public static final String FIREBASE_SDK_CLASS = "com.google.firebase.messaging.FirebaseMessagingService";
    public static final String XIAOMI_SDK_CLASS = "com.xiaomi.mipush.sdk.MiPushClient";
    public static final String BAIDU_SDK_CLASS = "com.baidu.android.pushservice.PushMessageReceiver";
    public static final String HUAWEI_SDK_CLASS = "com.huawei.hms.push.HmsMessageService";
    public static final String ADM_SDK_CLASS = "com.amazon.device.messaging.ADM";
    public static final String FCM_PROPERTY_REG_ID = "fcm_token";
    public static final String XPS_PROPERTY_REG_ID = "xps_token";
    public static final String BPS_PROPERTY_REG_ID = "bps_token";
    public static final String HPS_PROPERTY_REG_ID = "hps_token";
    public static final String ADM_PROPERTY_REG_ID = "adm_token";
    public static final int ANDROID_PLATFORM = 1;
    public static final int AMAZON_PLATFORM = 2;
    public static final int ALL_DEVICES = 1;
    public static final int XIAOMI_MIUI_DEVICES = 2;
    public static final int NO_DEVICES = 3;

    public static enum PushType {
        FCM("fcm", "fcm_token", "com.clevertap.android.sdk.pushnotification.fcm.FcmPushProvider", "com.google.firebase.messaging.FirebaseMessagingService", 1),
        XPS("xps", "xps_token", "com.clevertap.android.xps.XiaomiPushProvider", "com.xiaomi.mipush.sdk.MiPushClient", 1),
        HPS("hps", "hps_token", "com.clevertap.android.hms.HmsPushProvider", "com.huawei.hms.push.HmsMessageService", 1),
        BPS("bps", "bps_token", "com.clevertap.android.bps.BaiduPushProvider", "com.baidu.android.pushservice.PushMessageReceiver", 1),
        ADM("adm", "adm_token", "com.clevertap.android.adm.AmazonPushProvider", "com.amazon.device.messaging.ADM", 1);

        private final String ctProviderClassName;
        private final String messagingSDKClassName;
        private final String tokenPrefKey;
        private final String type;
        private int runningDevices;

        private PushType(String type, String prefKey, String className, String messagingSDKClassName, int runningDevices) {
            this.type = type;
            this.tokenPrefKey = prefKey;
            this.ctProviderClassName = className;
            this.messagingSDKClassName = messagingSDKClassName;
            this.runningDevices = runningDevices;
        }

        public String getCtProviderClassName() {
            return this.ctProviderClassName;
        }

        public String getMessagingSDKClassName() {
            return this.messagingSDKClassName;
        }

        public String getTokenPrefKey() {
            return this.tokenPrefKey;
        }

        public String getType() {
            return this.type;
        }

        public void setRunningDevices(int runningDevices) {
            this.runningDevices = runningDevices;
        }

        public int getRunningDevices() {
            return this.runningDevices;
        }

        @NonNull
        public String toString() {
            return " [PushType:" + this.name() + "] ";
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface XiaomiPush {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Platform {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RegKeyType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PushMessagingClass {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CTPushProviderClass {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeliveryType {
    }
}

