/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.network.NetworkManager;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import org.json.JSONObject;

public class MetadataResponse
extends CleverTapResponseDecorator {
    private final CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final DeviceInfo deviceInfo;
    private final Logger logger;
    private final NetworkManager networkManager;

    public MetadataResponse(CleverTapResponse cleverTapResponse, CleverTapInstanceConfig config, DeviceInfo deviceInfo, NetworkManager networkManager) {
        this.cleverTapResponse = cleverTapResponse;
        this.config = config;
        this.logger = this.config.getLogger();
        this.deviceInfo = deviceInfo;
        this.networkManager = networkManager;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        try {
            if (response.has("g")) {
                String deviceID = response.getString("g");
                this.deviceInfo.forceUpdateDeviceId(deviceID);
                this.logger.verbose(this.config.getAccountId(), "Got a new device ID: " + deviceID);
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Failed to update device ID!", t);
        }
        try {
            if (response.has("_i")) {
                long i = response.getLong("_i");
                this.networkManager.setI(context, i);
            }
        }
        catch (Throwable i) {
            // empty catch block
        }
        try {
            if (response.has("_j")) {
                long j = response.getLong("_j");
                this.networkManager.setJ(context, j);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.cleverTapResponse.processResponse(response, stringBody, context);
    }
}

