/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import androidx.core.app.NotificationManagerCompat;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\b*\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\n\u001a\u00020\b\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\t\u001a\u00020\r\u001a\"\u0010\u000e\u001a\u00020\f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0002\u001a \u0010\u0013\u001a\u0004\u0018\u00010\b*\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0002H\u0007\u001a\n\u0010\u0016\u001a\u00020\u0006*\u00020\u0017\u001a\u0014\u0010\u0018\u001a\u00020\u0006*\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0001\u001a\f\u0010\u001b\u001a\u00020\u0006*\u0004\u0018\u00010\r\u001a\u0012\u0010\u001c\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\b\u001a\u0012\u0010\u001e\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0001\u001a\n\u0010 \u001a\u00020\u0006*\u00020!\u001a;\u0010\"\u001a\u00020\f\"\u0006\b\u0000\u0010#\u0018\u0001*\u00020\u00192!\u0010$\u001a\u001d\u0012\u0013\u0012\u0011H#\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\f0%H\u0086\b\u00f8\u0001\u0000\u001a\f\u0010)\u001a\u00020\u0019*\u0004\u0018\u00010\u0019\u001a \u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00190+*\u00020\r2\u0006\u0010,\u001a\u00020\b\u001a\u000e\u0010-\u001a\u0004\u0018\u00010\r*\u0004\u0018\u00010\b\u001a\u001b\u0010.\u001a\b\u0012\u0004\u0012\u0002H#0/\"\u0006\b\u0000\u0010#\u0018\u0001*\u00020\u0019H\u0086\b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00060"}, d2={"targetSdkVersion", "", "Landroid/content/Context;", "getTargetSdkVersion", "(Landroid/content/Context;)I", "areAppNotificationsEnabled", "", "concatIfNotNull", "", "other", "separator", "copyFrom", "", "Lorg/json/JSONObject;", "flushPushImpressionsOnPostAsyncSafely", "Lcom/clevertap/android/sdk/CleverTapAPI;", "logTag", "caller", "context", "getOrCreateChannel", "Landroid/app/NotificationManager;", "msgChannel", "hasData", "Landroid/content/SharedPreferences;", "isInvalidIndex", "Lorg/json/JSONArray;", "index", "isNotNullAndEmpty", "isNotificationChannelEnabled", "channelId", "isPackageAndOsTargetsAbove", "apiLevel", "isValid", "Landroid/location/Location;", "iterator", "T", "foreach", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "element", "orEmptyArray", "safeGetJSONArray", "Lkotlin/Pair;", "key", "toJsonOrNull", "toList", "", "clevertap-core_release"})
@JvmName(name="CTXtensions")
public final class CTXtensions {
    public static final boolean isPackageAndOsTargetsAbove(@NotNull Context $this$isPackageAndOsTargetsAbove, int apiLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$isPackageAndOsTargetsAbove, (String)"<this>");
        return Build.VERSION.SDK_INT > apiLevel && CTXtensions.getTargetSdkVersion($this$isPackageAndOsTargetsAbove) > apiLevel;
    }

    public static final int getTargetSdkVersion(@NotNull Context $this$targetSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$targetSdkVersion, (String)"<this>");
        return $this$targetSdkVersion.getApplicationContext().getApplicationInfo().targetSdkVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotificationChannelEnabled(@NotNull Context $this$isNotificationChannelEnabled, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotificationChannelEnabled, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        if (Build.VERSION.SDK_INT >= 26) {
            if (!CTXtensions.areAppNotificationsEnabled($this$isNotificationChannelEnabled)) return false;
            try {
                Object object = $this$isNotificationChannelEnabled.getSystemService("notification");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                NotificationManager nm = (NotificationManager)object;
                if (nm.getNotificationChannel(channelId).getImportance() == 0) return false;
                return true;
            }
            catch (Exception e) {
                Logger.d("Unable to find notification channel with id = " + channelId);
                return false;
            }
        }
        boolean bl = CTXtensions.areAppNotificationsEnabled($this$isNotificationChannelEnabled);
        return bl;
    }

    public static final boolean areAppNotificationsEnabled(@NotNull Context $this$areAppNotificationsEnabled) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$areAppNotificationsEnabled, (String)"<this>");
        try {
            bl = NotificationManagerCompat.from((Context)$this$areAppNotificationsEnabled).areNotificationsEnabled();
        }
        catch (Exception e) {
            Logger.d("Unable to query notifications enabled flag, returning true!");
            e.printStackTrace();
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=26)
    @WorkerThread
    @Nullable
    public static final String getOrCreateChannel(@NotNull NotificationManager $this$getOrCreateChannel, @Nullable String msgChannel, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getOrCreateChannel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            CharSequence charSequence = msgChannel;
            if (!(charSequence == null || charSequence.length() == 0) && $this$getOrCreateChannel.getNotificationChannel(msgChannel) != null) {
                return msgChannel;
            }
            ManifestInfo manifestMetadata = ManifestInfo.getInstance(context);
            String manifestChannel = manifestMetadata.getDevDefaultPushChannelId();
            CharSequence charSequence2 = manifestChannel;
            if (!(charSequence2 == null || charSequence2.length() == 0) && $this$getOrCreateChannel.getNotificationChannel(manifestChannel) != null) {
                return manifestChannel;
            }
            charSequence2 = manifestChannel;
            if (charSequence2 == null || charSequence2.length() == 0) {
                Logger.d("CleverTap", "Missing Default CleverTap Notification Channel metadata in AndroidManifest.");
            } else {
                Logger.d("CleverTap", "Notification Channel set in AndroidManifest.xml has not been created by the app.");
            }
            if ($this$getOrCreateChannel.getNotificationChannel("fcm_fallback_notification_channel") == null) {
                void it;
                String string2;
                try {
                    string2 = context.getString(R.string.ct_fcm_fallback_notification_channel_label);
                }
                catch (Exception e) {
                    string2 = "Misc";
                }
                String string3 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"try {\n                  \u2026HANNEL_NAME\n            }");
                String defaultChannelName = string3;
                NotificationChannel notificationChannel = new NotificationChannel("fcm_fallback_notification_channel", (CharSequence)defaultChannelName, 3);
                string2 = notificationChannel;
                NotificationManager notificationManager = $this$getOrCreateChannel;
                boolean bl = false;
                Logger.d("CleverTap", "created default channel: " + it);
                notificationManager.createNotificationChannel(notificationChannel);
            }
            return "fcm_fallback_notification_channel";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void flushPushImpressionsOnPostAsyncSafely(@NotNull CleverTapAPI $this$flushPushImpressionsOnPostAsyncSafely, @NotNull String logTag, @NotNull String caller, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$flushPushImpressionsOnPostAsyncSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Task<Void> flushTask = CTExecutorFactory.executors($this$flushPushImpressionsOnPostAsyncSafely.getCoreState().getConfig()).postAsyncSafelyTask();
        Future<?> flushFutureResult = flushTask.submit(logTag, () -> CTXtensions.flushPushImpressionsOnPostAsyncSafely$lambda$1($this$flushPushImpressionsOnPostAsyncSafely, context, caller, logTag));
        try {
            flushFutureResult.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final boolean isInvalidIndex(@Nullable JSONArray $this$isInvalidIndex, int index) {
        return $this$isInvalidIndex == null || index < 0 || index >= $this$isInvalidIndex.length();
    }

    public static final boolean hasData(@NotNull SharedPreferences $this$hasData) {
        Intrinsics.checkNotNullParameter((Object)$this$hasData, (String)"<this>");
        Map map = $this$hasData.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"all");
        return !map.isEmpty();
    }

    @NotNull
    public static final JSONArray orEmptyArray(@Nullable JSONArray $this$orEmptyArray) {
        JSONArray jSONArray = $this$orEmptyArray;
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    public static final /* synthetic */ <T> List<T> toList(JSONArray $this$toList) {
        Intrinsics.checkNotNullParameter((Object)$this$toList, (String)"<this>");
        boolean $i$f$toList = false;
        List list = new ArrayList();
        int n = $this$toList.length();
        for (int index = 0; index < n; ++index) {
            Object element = $this$toList.get(index);
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            list.add(element);
        }
        return list;
    }

    public static final /* synthetic */ <T> void iterator(JSONArray $this$iterator, Function1<? super T, Unit> foreach) {
        Intrinsics.checkNotNullParameter((Object)$this$iterator, (String)"<this>");
        Intrinsics.checkNotNullParameter(foreach, (String)"foreach");
        boolean $i$f$iterator = false;
        int n = $this$iterator.length();
        for (int index = 0; index < n; ++index) {
            Object element = $this$iterator.get(index);
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            foreach.invoke(element);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Boolean, JSONArray> safeGetJSONArray(@NotNull JSONObject $this$safeGetJSONArray, @NotNull String key) {
        void it;
        JSONArray jSONArray;
        Intrinsics.checkNotNullParameter((Object)$this$safeGetJSONArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JSONArray jSONArray2 = $this$safeGetJSONArray.optJSONArray(key);
        if (jSONArray2 == null) {
            return new Pair((Object)false, null);
        }
        JSONArray list = jSONArray2;
        boolean bl = list.length() > 0;
        JSONArray jSONArray3 = jSONArray = list;
        Boolean bl2 = bl;
        boolean bl3 = false;
        boolean bl4 = it.length() > 0;
        JSONArray jSONArray4 = bl4 ? jSONArray : null;
        Boolean bl5 = bl2;
        return new Pair((Object)bl5, (Object)jSONArray4);
    }

    public static final void copyFrom(@NotNull JSONObject $this$copyFrom, @NotNull JSONObject other) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Iterator iterator = other.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"other.keys()");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            $this$copyFrom.put(key, other.opt(key));
        }
    }

    public static final boolean isNotNullAndEmpty(@Nullable JSONObject $this$isNotNullAndEmpty) {
        return $this$isNotNullAndEmpty != null && $this$isNotNullAndEmpty.length() > 0;
    }

    @Nullable
    public static final String concatIfNotNull(@Nullable String $this$concatIfNotNull, @Nullable String other, @NotNull String separator) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if ($this$concatIfNotNull != null && other != null) {
            string2 = $this$concatIfNotNull + separator + other;
        } else {
            string2 = $this$concatIfNotNull;
            if (string2 == null) {
                string2 = other;
            }
        }
        return string2;
    }

    public static /* synthetic */ String concatIfNotNull$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        return CTXtensions.concatIfNotNull(string, string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValid(@NotNull Location $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        double d = $this$isValid.getLatitude();
        if (!(-90.0 <= d)) return false;
        if (!(d <= 90.0)) return false;
        boolean bl = true;
        if (!bl) return false;
        d = $this$isValid.getLongitude();
        if (!(-180.0 <= d)) return false;
        if (!(d <= 180.0)) return false;
        return true;
    }

    @Nullable
    public static final JSONObject toJsonOrNull(@Nullable String $this$toJsonOrNull) {
        JSONObject jSONObject;
        String string2 = $this$toJsonOrNull;
        if (string2 != null) {
            JSONObject jSONObject2;
            String it = string2;
            boolean bl = false;
            try {
                jSONObject2 = new JSONObject(it);
            }
            catch (JSONException e) {
                jSONObject2 = null;
            }
            jSONObject = jSONObject2;
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    private static final Void flushPushImpressionsOnPostAsyncSafely$lambda$1(CleverTapAPI $this_flushPushImpressionsOnPostAsyncSafely, Context $context, String $caller, String $logTag) {
        Intrinsics.checkNotNullParameter((Object)$this_flushPushImpressionsOnPostAsyncSafely, (String)"$this_flushPushImpressionsOnPostAsyncSafely");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$caller, (String)"$caller");
        Intrinsics.checkNotNullParameter((Object)$logTag, (String)"$logTag");
        try {
            $this_flushPushImpressionsOnPostAsyncSafely.getCoreState().getBaseEventQueueManager().flushQueueSync($context, EventGroup.PUSH_NOTIFICATION_VIEWED, $caller);
        }
        catch (Exception e) {
            Logger.d($logTag, "failed to flush push impressions on ct instance = " + $this_flushPushImpressionsOnPostAsyncSafely.getCoreState().getConfig().getAccountId());
        }
        return null;
    }
}

