/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.store.preference;

import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.store.preference.ICTPreference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/clevertap/android/sdk/inapp/store/preference/LegacyInAppStore;", "", "ctPreference", "Lcom/clevertap/android/sdk/store/preference/ICTPreference;", "accountId", "", "(Lcom/clevertap/android/sdk/store/preference/ICTPreference;Ljava/lang/String;)V", "inAppKey", "lastCleanupTs", "", "readInApps", "Lorg/json/JSONArray;", "removeInApps", "", "storeInApps", "inApps", "updateAssetCleanupTs", "ts", "Companion", "clevertap-core_release"})
public final class LegacyInAppStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ICTPreference ctPreference;
    @Nullable
    private final String inAppKey;
    @NotNull
    private static final String ASSETS_CLEANUP_TS_KEY = "last_assets_cleanup";

    public LegacyInAppStore(@NotNull ICTPreference ctPreference, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)ctPreference, (String)"ctPreference");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        this.ctPreference = ctPreference;
        this.inAppKey = CTXtensions.concatIfNotNull("inApp", accountId, ":");
    }

    public final void storeInApps(@NotNull JSONArray inApps) {
        Intrinsics.checkNotNullParameter((Object)inApps, (String)"inApps");
        String string2 = this.inAppKey;
        Intrinsics.checkNotNull((Object)string2);
        String string3 = inApps.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"inApps.toString()");
        this.ctPreference.writeStringImmediate(string2, string3);
    }

    @NotNull
    public final JSONArray readInApps() {
        JSONArray jSONArray;
        String string2 = this.inAppKey;
        Intrinsics.checkNotNull((Object)string2);
        String storedInApps = this.ctPreference.readString(string2, "[]");
        try {
            jSONArray = new JSONArray(storedInApps);
        }
        catch (JSONException e) {
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    public final void removeInApps() {
        String string2 = this.inAppKey;
        Intrinsics.checkNotNull((Object)string2);
        this.ctPreference.remove(string2);
    }

    public final void updateAssetCleanupTs(long ts) {
        this.ctPreference.writeLong(ASSETS_CLEANUP_TS_KEY, ts);
    }

    public final long lastCleanupTs() {
        return this.ctPreference.readLong(ASSETS_CLEANUP_TS_KEY, 0L);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/clevertap/android/sdk/inapp/store/preference/LegacyInAppStore$Companion;", "", "()V", "ASSETS_CLEANUP_TS_KEY", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

