/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.apns;

import com.clevertap.apns.exceptions.CertificateEnvironmentMismatchException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;

public class CertificateUtils {
    public static Map<String, String> splitCertificateSubject(InputStream certificate, String password) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        String subject = CertificateUtils.getCertificate(certificate, password).getSubjectDN().getName();
        return CertificateUtils.splitCertificateSubject(subject);
    }

    public static X509Certificate getCertificate(InputStream certificate, String password) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        password = password == null ? "" : password;
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(certificate, password.toCharArray());
        return (X509Certificate)ks.getCertificate(ks.aliases().nextElement());
    }

    public static Map<String, String> splitCertificateSubject(String subject) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (subject != null) {
            String[] parts;
            for (String part : parts = subject.split(",")) {
                String[] kv = part.split("=");
                if (kv.length != 2) continue;
                map.put(kv[0].trim(), kv[1].trim());
            }
        }
        return map;
    }

    public static void validateCertificate(boolean production, X509Certificate certificate) throws CertificateException {
        if (certificate == null) {
            throw new CertificateException("Null certificate");
        }
        certificate.checkValidity();
        Map<String, String> stringStringMap = CertificateUtils.splitCertificateSubject(certificate.getSubjectDN().getName());
        String cn = stringStringMap.get("CN");
        if (!cn.toLowerCase().contains("push")) {
            throw new CertificateException("Not a push certificate - " + cn);
        }
        if (production && cn.toLowerCase().contains("apple development ios push services")) {
            throw new CertificateEnvironmentMismatchException("Invalid environment for this certificate");
        }
        if (!production && cn.toLowerCase().contains("apple production ios push services")) {
            throw new CertificateEnvironmentMismatchException("Invalid environment for this certificate");
        }
    }
}

