/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.apns.clients;

import com.clevertap.apns.ApnsClient;
import com.clevertap.apns.CertificateUtils;
import com.clevertap.apns.Notification;
import com.clevertap.apns.NotificationRequestError;
import com.clevertap.apns.NotificationResponse;
import com.clevertap.apns.NotificationResponseListener;
import com.clevertap.apns.clients.ApnsClientBuilder;
import com.clevertap.apns.internal.Constants;
import com.clevertap.apns.internal.JWT;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;

public class SyncOkHttpApnsClient
implements ApnsClient {
    private final String defaultTopic;
    private final String apnsAuthKey;
    private final String teamID;
    private final String keyID;
    protected final OkHttpClient client;
    private final String gateway;
    private static final MediaType mediaType = MediaType.parse((String)"application/json");
    private long lastJWTTokenTS = 0L;
    private String cachedJWTToken = null;

    public SyncOkHttpApnsClient(String apnsAuthKey, String teamID, String keyID, boolean production, String defaultTopic, OkHttpClient.Builder clientBuilder) {
        this(apnsAuthKey, teamID, keyID, production, defaultTopic, clientBuilder, 443);
    }

    public SyncOkHttpApnsClient(String apnsAuthKey, String teamID, String keyID, boolean production, String defaultTopic, OkHttpClient.Builder clientBuilder, int connectionPort) {
        this.apnsAuthKey = apnsAuthKey;
        this.teamID = teamID;
        this.keyID = keyID;
        this.client = clientBuilder.build();
        this.defaultTopic = defaultTopic;
        this.gateway = (production ? "https://api.push.apple.com" : "https://api.development.push.apple.com") + ":" + connectionPort;
    }

    public SyncOkHttpApnsClient(String apnsAuthKey, String teamID, String keyID, boolean production, String defaultTopic, ConnectionPool connectionPool) {
        this(apnsAuthKey, teamID, keyID, production, defaultTopic, SyncOkHttpApnsClient.getBuilder(connectionPool));
    }

    public SyncOkHttpApnsClient(InputStream certificate, String password, boolean production, String defaultTopic, OkHttpClient.Builder builder) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        this(certificate, password, production, defaultTopic, builder, 443);
    }

    public SyncOkHttpApnsClient(InputStream certificate, String password, boolean production, String defaultTopic, OkHttpClient.Builder builder, int connectionPort) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        this.apnsAuthKey = null;
        this.keyID = null;
        this.teamID = null;
        password = password == null ? "" : password;
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(certificate, password.toCharArray());
        X509Certificate cert = (X509Certificate)ks.getCertificate(ks.aliases().nextElement());
        CertificateUtils.validateCertificate(production, cert);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, password.toCharArray());
        KeyManager[] keyManagers = kmf.getKeyManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        sslContext.init(keyManagers, tmf.getTrustManagers(), null);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        builder.sslSocketFactory(sslSocketFactory);
        this.client = builder.build();
        this.defaultTopic = defaultTopic;
        this.gateway = (production ? "https://api.push.apple.com" : "https://api.development.push.apple.com") + ":" + connectionPort;
    }

    public SyncOkHttpApnsClient(InputStream certificate, String password, boolean production, String defaultTopic, ConnectionPool connectionPool) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        this(certificate, password, production, defaultTopic, SyncOkHttpApnsClient.getBuilder(connectionPool));
    }

    private static OkHttpClient.Builder getBuilder(ConnectionPool connectionPool) {
        OkHttpClient.Builder builder = ApnsClientBuilder.createDefaultOkHttpClientBuilder();
        if (connectionPool != null) {
            builder.connectionPool(connectionPool);
        }
        return builder;
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    @Override
    public void push(Notification notification, NotificationResponseListener listener) {
        throw new UnsupportedOperationException("Asynchronous requests are not supported by this client");
    }

    protected final Request buildRequest(final Notification notification) {
        String topic = notification.getTopic() != null ? notification.getTopic() : this.defaultTopic;
        String collapseId = notification.getCollapseId();
        UUID uuid = notification.getUuid();
        long expiration = notification.getExpiration();
        Notification.Priority priority = notification.getPriority();
        String pushType = notification.getPushType();
        Request.Builder rb = new Request.Builder().url(this.gateway + "/3/device/" + notification.getToken()).post(new RequestBody(){

            public MediaType contentType() {
                return mediaType;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(notification.getPayload().getBytes(Constants.UTF_8));
            }
        }).header("content-length", notification.getPayload().getBytes(Constants.UTF_8).length + "");
        if (topic != null) {
            rb.header("apns-topic", topic);
        }
        if (collapseId != null) {
            rb.header("apns-collapse-id", collapseId);
        }
        if (uuid != null) {
            rb.header("apns-id", uuid.toString());
        }
        if (expiration > -1L) {
            rb.header("apns-expiration", String.valueOf(expiration));
        }
        if (priority != null) {
            rb.header("apns-priority", String.valueOf(priority.getCode()));
        }
        if (pushType != null) {
            rb.header("apns-push-type", pushType);
        }
        if (this.keyID != null && this.teamID != null && this.apnsAuthKey != null) {
            if (this.cachedJWTToken == null || System.currentTimeMillis() - this.lastJWTTokenTS > 3300000L) {
                try {
                    this.lastJWTTokenTS = System.currentTimeMillis();
                    this.cachedJWTToken = JWT.getToken(this.teamID, this.keyID, this.apnsAuthKey);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
                    return null;
                }
            }
            rb.header("authorization", "bearer " + this.cachedJWTToken);
        }
        return rb.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationResponse push(Notification notification) {
        Request request = this.buildRequest(notification);
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
            NotificationResponse notificationResponse = this.parseResponse(response);
            return notificationResponse;
        }
        catch (Throwable t) {
            NotificationResponse notificationResponse = new NotificationResponse(null, -1, null, t);
            return notificationResponse;
        }
        finally {
            if (response != null) {
                response.body().close();
            }
        }
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.client;
    }

    protected NotificationResponse parseResponse(Response response) throws IOException {
        String contentBody = null;
        int statusCode = response.code();
        NotificationRequestError error = null;
        if (response.code() != 200) {
            error = NotificationRequestError.get(statusCode);
            contentBody = response.body() != null ? response.body().string() : null;
        }
        return new NotificationResponse(error, statusCode, contentBody, null);
    }
}

