/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.data.ClickHouseGeoRingValue;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class ClickHouseGeoPolygonValue
extends ClickHouseObjectValue<double[][][]> {
    static final double[][][] EMPTY_VALUE = new double[0][][];

    public static ClickHouseGeoPolygonValue ofEmpty() {
        return ClickHouseGeoPolygonValue.of(null, EMPTY_VALUE);
    }

    public static ClickHouseGeoPolygonValue of(double[][][] value) {
        return ClickHouseGeoPolygonValue.of(null, value);
    }

    public static ClickHouseGeoPolygonValue of(ClickHouseValue ref, double[][][] value) {
        return ref instanceof ClickHouseGeoPolygonValue ? ((ClickHouseGeoPolygonValue)ref).set(value) : new ClickHouseGeoPolygonValue(value);
    }

    protected static double[][][] check(double[][][] value) {
        int len = ClickHouseChecker.nonNull(value, "Polygon").length;
        for (int i = 0; i < len; ++i) {
            ClickHouseGeoRingValue.check(value[i]);
        }
        return value;
    }

    protected static String convert(double[][][] value, int length) {
        StringBuilder builder = new StringBuilder().append('[');
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            builder.append(ClickHouseGeoRingValue.convert(value[i], 0)).append(',');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        String str = builder.append(']').toString();
        return length > 0 ? ClickHouseChecker.notWithDifferentLength(str, length) : str;
    }

    protected ClickHouseGeoPolygonValue(double[][][] value) {
        super(value);
    }

    protected ClickHouseGeoPolygonValue set(double[][][] value) {
        return (ClickHouseGeoPolygonValue)super.set(ClickHouseGeoPolygonValue.check(value));
    }

    @Override
    public ClickHouseGeoPolygonValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseGeoPolygonValue((double[][][])this.getValue());
        }
        double[][][] value = (double[][][])this.getValue();
        double[][][] newValue = new double[value.length][][];
        int index = 0;
        for (double[][] v : value) {
            double[][] nv = new double[v.length][];
            int i = 0;
            for (double[] d : v) {
                nv[i++] = Arrays.copyOf(d, d.length);
            }
            newValue[index++] = nv;
        }
        return new ClickHouseGeoPolygonValue(newValue);
    }

    @Override
    public Object[] asArray() {
        return (Object[])this.getValue();
    }

    @Override
    public <T> T[] asArray(Class<T> clazz) {
        double[][][] v = (double[][][])this.getValue();
        Object[] array = (Object[])Array.newInstance(ClickHouseChecker.nonNull(clazz, "Class"), v.length);
        int index = 0;
        for (double[][] d : v) {
            array[index++] = clazz.cast(d);
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        int index = 1;
        for (double[][] d : (double[][][])this.getValue()) {
            map.put(keyClass.cast(index++), valueClass.cast(d));
        }
        return map;
    }

    @Override
    public String asString(int length, Charset charset) {
        return ClickHouseGeoPolygonValue.convert((double[][][])this.getValue(), length);
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((double[][][])this.getValue()).length == 0;
    }

    @Override
    public ClickHouseGeoPolygonValue resetToDefault() {
        this.set(EMPTY_VALUE);
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        return ClickHouseGeoPolygonValue.convert((double[][][])this.getValue(), 0);
    }

    @Override
    public ClickHouseGeoPolygonValue update(boolean value) {
        throw this.newUnsupportedException("boolean", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(boolean[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][]{new double[][]{{value[0] ? 1.0 : 0.0, value[1] ? 0.0 : 1.0}}});
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(char value) {
        throw this.newUnsupportedException("char", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(char[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][]{new double[][]{{value[0], value[1]}}});
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(byte value) {
        throw this.newUnsupportedException("byte", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(byte[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][]{new double[][]{{value[0], value[1]}}});
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(short value) {
        throw this.newUnsupportedException("short", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(short[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][]{new double[][]{{value[0], value[1]}}});
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(int value) {
        throw this.newUnsupportedException("int", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(int[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][]{new double[][]{{value[0], value[1]}}});
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(long value) {
        throw this.newUnsupportedException("long", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(long[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][]{new double[][]{{value[0], value[1]}}});
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(float value) {
        throw this.newUnsupportedException("float", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(float[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][]{new double[][]{{value[0], value[1]}}});
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(double value) {
        throw this.newUnsupportedException("double", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(double[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][]{new double[][]{value}});
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(BigInteger value) {
        throw this.newUnsupportedException("BigInteger", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(BigDecimal value) {
        throw this.newUnsupportedException("BigDecimal", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(Enum<?> value) {
        throw this.newUnsupportedException("Enum", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(Inet4Address value) {
        throw this.newUnsupportedException("Inet4Address", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(Inet6Address value) {
        throw this.newUnsupportedException("Inet6Address", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(LocalDate value) {
        throw this.newUnsupportedException("Date", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(LocalTime value) {
        throw this.newUnsupportedException("Time", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(LocalDateTime value) {
        throw this.newUnsupportedException("DateTime", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(Collection<?> value) {
        if (value == null || value.size() != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Iterator<?> i = value.iterator();
        Object v1 = i.next();
        Object v2 = i.next();
        if (v1 instanceof Number) {
            this.set(new double[][][]{new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}}});
        } else {
            this.set(new double[][][]{new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(Enumeration<?> value) {
        if (value == null || !value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v1 = value.nextElement();
        if (!value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v2 = value.nextElement();
        if (value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        if (v1 instanceof Number) {
            this.set(new double[][][]{new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}}});
        } else {
            this.set(new double[][][]{new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(Map<?, ?> value) {
        if (value == null || value.size() != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Iterator<?> i = value.values().iterator();
        Object v1 = i.next();
        Object v2 = i.next();
        if (v1 instanceof Number) {
            this.set(new double[][][]{new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}}});
        } else {
            this.set(new double[][][]{new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(String value) {
        throw this.newUnsupportedException("String", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(UUID value) {
        throw this.newUnsupportedException("UUID", "Polygon");
    }

    @Override
    public ClickHouseGeoPolygonValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (value instanceof ClickHouseGeoPolygonValue) {
            this.set((double[][][])((ClickHouseGeoPolygonValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(Object[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v1 = value[0];
        Object v2 = value[1];
        if (v1 instanceof Number) {
            this.set(new double[][][]{new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}}});
        } else {
            this.set(new double[][][]{new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoPolygonValue update(Object value) {
        if (value instanceof double[][][]) {
            this.update((double[])value);
        } else {
            super.update(value);
        }
        return this;
    }
}

