/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseArrayValue;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ClickHouseNestedValue
extends ClickHouseObjectValue<Object[][]> {
    private final List<ClickHouseColumn> columns;

    public static ClickHouseNestedValue ofEmpty(List<ClickHouseColumn> columns) {
        return ClickHouseNestedValue.of(null, columns, new Object[0][]);
    }

    public static ClickHouseNestedValue of(List<ClickHouseColumn> columns, Object[][] values) {
        return ClickHouseNestedValue.of(null, columns, values);
    }

    public static ClickHouseNestedValue of(ClickHouseValue ref, List<ClickHouseColumn> columns, Object[][] values) {
        return ref instanceof ClickHouseNestedValue ? ((ClickHouseNestedValue)ref).update((Object[])values) : new ClickHouseNestedValue(columns, values);
    }

    protected static Object[][] check(List<ClickHouseColumn> columns, Object[][] value) {
        if (columns == null || value == null) {
            throw new IllegalArgumentException("Non-null columns and value are required");
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("At least one column must be specified for nested type");
        }
        if (value.length != 0 && value.length != columns.size()) {
            throw new IllegalArgumentException("Columns and values should have same length");
        }
        return value;
    }

    protected ClickHouseNestedValue(List<ClickHouseColumn> columns, Object[][] values) {
        super(ClickHouseNestedValue.check(columns, values));
        this.columns = columns;
    }

    protected Object getSingleValue() {
        Object[][] value = (Object[][])this.getValue();
        if (value == null || value.length != 1 || value[0] == null || value[0].length != 1) {
            throw new UnsupportedOperationException("Only nested object containing only one value(one column and one row) supports type conversion");
        }
        return value[0][0];
    }

    protected ClickHouseNestedValue set(Object[][] value) {
        if (this.columns == null && this.getValue() == null) {
            super.set(value);
        } else {
            super.set(ClickHouseNestedValue.check(this.columns, value));
        }
        return this;
    }

    public List<ClickHouseColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public ClickHouseNestedValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseNestedValue(this.columns, (Object[][])this.getValue());
        }
        Object[][] value = (Object[][])this.getValue();
        int len = value.length;
        Object[][] newValue = new Object[len][];
        for (int i = 0; i < len; ++i) {
            Object[] v = value[i];
            newValue[i] = Arrays.copyOf(v, v.length);
        }
        return new ClickHouseNestedValue(this.columns, newValue);
    }

    @Override
    public Object[] asArray() {
        return (Object[])this.getValue();
    }

    @Override
    public <T> T[] asArray(Class<T> clazz) {
        Object[][] v = (Object[][])this.getValue();
        Object[] array = (Object[])Array.newInstance(ClickHouseChecker.nonNull(clazz, "Class"), v.length);
        int index = 0;
        for (Object[] o : v) {
            array[index++] = clazz.cast(o);
        }
        return array;
    }

    @Override
    public Map<Object, Object> asMap() {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int index = 0;
        for (Object[] o : (Object[][])this.getValue()) {
            map.put(this.columns.get(index++).getColumnName(), o);
        }
        return map;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        int index = 0;
        for (Object[] o : (Object[][])this.getValue()) {
            map.put(keyClass.cast(this.columns.get(index++).getColumnName()), valueClass.cast(o));
        }
        return map;
    }

    @Override
    public String asString(int length, Charset charset) {
        String str = Arrays.deepToString((Object[])this.getValue());
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public boolean isNullOrEmpty() {
        Object[][] value = (Object[][])this.getValue();
        return value == null || value.length == 0;
    }

    @Override
    public ClickHouseNestedValue resetToDefault() {
        this.set(ClickHouseValues.EMPTY_OBJECT_ARRAY2);
        return this;
    }

    @Override
    public ClickHouseNestedValue resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        Object[][] value = (Object[][])this.getValue();
        if (value == null || value.length == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        for (Object[] v : value) {
            if (v == null || v.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[');
                for (Object o : v) {
                    builder.append(ClickHouseValues.convertToSqlExpression(o)).append(',');
                }
                builder.setLength(builder.length() - 1);
                builder.append(']');
            }
            builder.append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    @Override
    public ClickHouseNestedValue update(boolean value) {
        this.set(new Object[][]{{value ? (byte)1 : 0}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(boolean[] value) {
        int len = value == null ? 0 : value.length;
        Byte[] v = new Byte[len];
        if (len > 0) {
            int index = 0;
            for (boolean b : value) {
                v[index++] = b ? (byte)1 : 0;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(char value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(char[] value) {
        int len = value == null ? 0 : value.length;
        Integer[] v = new Integer[len];
        if (len > 0) {
            int index = 0;
            for (char c : value) {
                v[index++] = c;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(byte value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(byte[] value) {
        int len = value == null ? 0 : value.length;
        Byte[] v = new Byte[len];
        if (len > 0) {
            int index = 0;
            for (byte b : value) {
                v[index++] = b;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(short value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(short[] value) {
        int len = value == null ? 0 : value.length;
        Short[] v = new Short[len];
        if (len > 0) {
            int index = 0;
            for (short s : value) {
                v[index++] = s;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(int value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(int[] value) {
        int len = value == null ? 0 : value.length;
        Integer[] v = new Integer[len];
        if (len > 0) {
            int index = 0;
            for (int i : value) {
                v[index++] = i;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(long value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(long[] value) {
        int len = value == null ? 0 : value.length;
        Long[] v = new Long[len];
        if (len > 0) {
            int index = 0;
            for (long l : value) {
                v[index++] = l;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(float value) {
        this.set(new Object[][]{{Float.valueOf(value)}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(float[] value) {
        int len = value == null ? 0 : value.length;
        Float[] v = new Float[len];
        if (len > 0) {
            int index = 0;
            for (float f : value) {
                v[index++] = Float.valueOf(f);
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(double value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(double[] value) {
        int len = value == null ? 0 : value.length;
        Double[] v = new Double[len];
        if (len > 0) {
            int index = 0;
            for (double d : value) {
                v[index++] = d;
            }
        }
        return this.set(new Object[][]{v});
    }

    @Override
    public ClickHouseNestedValue update(BigInteger value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(BigDecimal value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(Enum<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(LocalDate value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(LocalTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(LocalDateTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        Object[] v = new Object[size];
        int index = 0;
        for (Object o : value) {
            v[index++] = o;
        }
        return this.set(new Object[][]{v});
    }

    @Override
    public ClickHouseNestedValue update(Enumeration<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        LinkedList v = new LinkedList();
        while (value.hasMoreElements()) {
            v.add(value.nextElement());
        }
        return this.set(new Object[][]{v.toArray(new Object[v.size()])});
    }

    @Override
    public ClickHouseNestedValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        Object[] v = new Object[size];
        int index = 0;
        for (Object o : value.values()) {
            v[index++] = o;
        }
        return this.set(new Object[][]{v});
    }

    @Override
    public ClickHouseNestedValue update(String value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(ClickHouseValue value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof ClickHouseNestedValue) {
            this.set((Object[][])((ClickHouseNestedValue)value).getValue());
        } else {
            this.set(new Object[][]{value.asArray()});
        }
        return this;
    }

    @Override
    public ClickHouseNestedValue update(Object[] value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Object[][]) {
            this.set((Object[][])value);
        } else {
            this.set(new Object[][]{value});
        }
        return this;
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(Object value) {
        if (value instanceof Object[][]) {
            this.set((Object[][])value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getValue(), (Object[])((ClickHouseArrayValue)obj).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.getValue());
    }
}

