/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.ClickHouseDateTimeValue;
import com.clickhouse.data.value.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.TimeZone;

public class ClickHouseInstantValue
extends ClickHouseObjectValue<Instant> {
    public static final Instant DEFAULT = Instant.ofEpochMilli(0L);
    private final int scale;
    private final TimeZone tz;

    public static ClickHouseInstantValue ofNull(int scale, TimeZone tz) {
        return ClickHouseInstantValue.ofNull(null, scale, tz);
    }

    public static ClickHouseInstantValue ofNull(ClickHouseValue ref, int scale, TimeZone tz) {
        return ref instanceof ClickHouseInstantValue ? (ClickHouseInstantValue)((ClickHouseInstantValue)ref).set(null) : new ClickHouseInstantValue(null, scale, tz);
    }

    public static ClickHouseInstantValue of(Instant value, int scale, TimeZone tz) {
        return ClickHouseInstantValue.of(null, value, scale, tz);
    }

    public static ClickHouseInstantValue of(String value, int scale, TimeZone tz) {
        return ClickHouseInstantValue.of(null, value, scale, tz);
    }

    public static ClickHouseInstantValue of(ClickHouseValue ref, Instant value, int scale, TimeZone tz) {
        return ref instanceof ClickHouseInstantValue ? (ClickHouseInstantValue)((ClickHouseInstantValue)ref).set(value) : new ClickHouseInstantValue(value, scale, tz);
    }

    public static ClickHouseInstantValue of(ClickHouseValue ref, String value, int scale, TimeZone tz) {
        Instant dateTime = value == null || value.isEmpty() ? null : LocalDateTime.parse(value, ClickHouseValues.DATETIME_FORMATTER).atZone(tz.toZoneId()).toInstant();
        return ClickHouseInstantValue.of(ref, dateTime, scale, tz);
    }

    protected ClickHouseInstantValue(Instant value, int scale, TimeZone tz) {
        super(value);
        this.scale = ClickHouseChecker.between(scale, "scale", 0, 9);
        this.tz = tz != null ? tz : ClickHouseValues.UTC_TIMEZONE;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public ClickHouseInstantValue copy(boolean deep) {
        return new ClickHouseInstantValue((Instant)this.getValue(), this.scale, this.tz);
    }

    @Override
    public byte asByte() {
        return this.isNullOrEmpty() ? (byte)0 : (byte)((Instant)this.getValue()).getEpochSecond();
    }

    @Override
    public short asShort() {
        return this.isNullOrEmpty() ? (short)0 : (short)((Instant)this.getValue()).getEpochSecond();
    }

    @Override
    public int asInteger() {
        return this.isNullOrEmpty() ? 0 : (int)((Instant)this.getValue()).getEpochSecond();
    }

    @Override
    public long asLong() {
        return this.isNullOrEmpty() ? 0L : ((Instant)this.getValue()).getEpochSecond();
    }

    @Override
    public float asFloat() {
        return this.isNullOrEmpty() ? 0.0f : (float)((Instant)this.getValue()).getEpochSecond() + (float)((Instant)this.getValue()).getNano() / ClickHouseValues.NANOS.floatValue();
    }

    @Override
    public double asDouble() {
        return this.isNullOrEmpty() ? 0.0 : (double)((Instant)this.getValue()).getEpochSecond() + (double)((Instant)this.getValue()).getNano() / ClickHouseValues.NANOS.doubleValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNullOrEmpty() ? null : BigInteger.valueOf(((Instant)this.getValue()).getEpochSecond());
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        Instant value = (Instant)this.getValue();
        BigDecimal v = null;
        if (value != null) {
            int nanoSeconds = value.getNano();
            v = new BigDecimal(BigInteger.valueOf(value.getEpochSecond()), scale);
            if (scale != 0 && nanoSeconds != 0) {
                v = v.add(BigDecimal.valueOf(nanoSeconds).divide(ClickHouseValues.NANOS).setScale(scale, ClickHouseDataConfig.DEFAULT_ROUNDING_MODE));
            }
        }
        return v;
    }

    @Override
    public LocalDate asDate() {
        return this.isNullOrEmpty() ? null : this.asDateTime(0).toLocalDate();
    }

    @Override
    public LocalDateTime asDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return LocalDateTime.ofInstant((Instant)this.getValue(), this.tz.toZoneId());
    }

    @Override
    public Instant asInstant(int scale) {
        return (Instant)this.getValue();
    }

    @Override
    public OffsetDateTime asOffsetDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return OffsetDateTime.ofInstant((Instant)this.getValue(), this.tz.toZoneId());
    }

    @Override
    public ZonedDateTime asZonedDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ((Instant)this.getValue()).atZone(this.tz.toZoneId());
    }

    @Override
    public Object asObject() {
        return this.getValue();
    }

    @Override
    public String asString() {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return this.asDateTime().format(this.scale > 0 ? ClickHouseValues.DATETIME_FORMATTER : ClickHouseDateTimeValue.dateTimeFormatter);
    }

    @Override
    public ClickHouseInstantValue resetToDefault() {
        this.set(DEFAULT);
        return this;
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        return '\'' + this.asDateTime().format(this.scale > 0 ? ClickHouseValues.DATETIME_FORMATTER : ClickHouseDateTimeValue.dateTimeFormatter) + '\'';
    }

    @Override
    public ClickHouseInstantValue update(byte value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseInstantValue update(short value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseInstantValue update(int value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseInstantValue update(long value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseInstantValue update(float value) {
        return this.update(BigDecimal.valueOf(value));
    }

    @Override
    public ClickHouseInstantValue update(double value) {
        return this.update(BigDecimal.valueOf(value));
    }

    @Override
    public ClickHouseInstantValue update(BigInteger value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (this.scale == 0) {
            this.set(ClickHouseValues.convertToInstant(new BigDecimal(value, 0)));
        } else {
            this.set(ClickHouseValues.convertToInstant(new BigDecimal(value, this.scale)));
        }
        return this;
    }

    @Override
    public ClickHouseInstantValue update(BigDecimal value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            if (value.scale() != this.scale) {
                value = value.setScale(this.scale, ClickHouseDataConfig.DEFAULT_ROUNDING_MODE);
            }
            this.set(ClickHouseValues.convertToInstant(value));
        }
        return this;
    }

    @Override
    public ClickHouseInstantValue update(Enum<?> value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.ordinal()));
        }
        return this;
    }

    @Override
    public ClickHouseInstantValue update(LocalDate value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDateTime.of(value, LocalTime.MIN).atZone(this.tz.toZoneId()).toInstant());
        }
        return this;
    }

    @Override
    public ClickHouseInstantValue update(LocalTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDateTime.of(LocalDate.now(), value).atZone(this.tz.toZoneId()).toInstant());
        }
        return this;
    }

    @Override
    public ClickHouseInstantValue update(LocalDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.atZone(this.tz.toZoneId()).toInstant());
        }
        return this;
    }

    @Override
    public ClickHouseInstantValue update(Instant value) {
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseInstantValue update(OffsetDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.toInstant());
        }
        return this;
    }

    @Override
    public ClickHouseInstantValue update(ZonedDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.toInstant());
        }
        return this;
    }

    @Override
    public ClickHouseInstantValue update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDateTime.parse(value, ClickHouseValues.DATETIME_FORMATTER).atZone(this.tz.toZoneId()).toInstant());
        }
        return this;
    }

    @Override
    public ClickHouseInstantValue update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.asInstant(this.scale));
        }
        return this;
    }

    @Override
    public ClickHouseInstantValue update(Object value) {
        if (value instanceof Instant) {
            this.update((Instant)value);
        } else if (value instanceof String) {
            this.update((String)value);
        } else {
            super.update(value);
        }
        return this;
    }
}

