/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value.array;

import com.clickhouse.data.ClickHouseArraySequence;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.ClickHouseObjectValue;
import com.clickhouse.data.value.UnsignedLong;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ClickHouseLongArrayValue
extends ClickHouseObjectValue<long[]>
implements ClickHouseArraySequence {
    private static final String TYPE_NAME = "long[]";

    public static ClickHouseLongArrayValue ofEmpty() {
        return ClickHouseLongArrayValue.of(null, ClickHouseValues.EMPTY_LONG_ARRAY, false);
    }

    public static ClickHouseLongArrayValue ofUnsignedEmpty() {
        return ClickHouseLongArrayValue.of(null, ClickHouseValues.EMPTY_LONG_ARRAY, true);
    }

    public static ClickHouseLongArrayValue of(long[] value) {
        return ClickHouseLongArrayValue.of(null, value, false);
    }

    public static ClickHouseLongArrayValue ofUnsigned(long[] value) {
        return ClickHouseLongArrayValue.of(null, value, true);
    }

    public static ClickHouseLongArrayValue of(ClickHouseValue ref, long[] value, boolean unsigned) {
        if (unsigned) {
            return ref instanceof UnsignedLongArrayValue ? ((UnsignedLongArrayValue)ref).set(value) : new UnsignedLongArrayValue(value);
        }
        return ref instanceof ClickHouseLongArrayValue ? ((ClickHouseLongArrayValue)ref).set(value) : new ClickHouseLongArrayValue(value);
    }

    protected ClickHouseLongArrayValue(long[] value) {
        super(value);
    }

    protected ClickHouseLongArrayValue set(long[] value) {
        super.set(ClickHouseChecker.nonNull(value, "Array"));
        return this;
    }

    @Override
    public Object[] asArray() {
        long[] v = (long[])this.getValue();
        int len = v.length;
        Object[] array = new Long[len];
        for (int i = 0; i < len; ++i) {
            array[i] = v[i];
        }
        return array;
    }

    public <E> E[] asArray(Class<E> clazz) {
        long[] v = (long[])this.getValue();
        int len = v.length;
        if (clazz == BigInteger.class) {
            BigInteger[] array = new BigInteger[len];
            for (int i = 0; i < len; ++i) {
                long value = v[i];
                array[i] = BigInteger.valueOf(value);
                if (value >= 0L) continue;
                array[i] = array[i].and(UnsignedLong.MASK);
            }
            return array;
        }
        E[] array = ClickHouseValues.createObjectArray(clazz, len, 1);
        for (int i = 0; i < len; ++i) {
            array[i] = clazz.cast(v[i]);
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        long[] v = (long[])this.getValue();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (int i = 0; i < v.length; ++i) {
            map.put(keyClass.cast(i + 1), valueClass.cast(v[i]));
        }
        return map;
    }

    @Override
    public String asString() {
        int len;
        long[] value = (long[])this.getValue();
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder().append('[').append(value[0]);
        for (int i = 1; i < len; ++i) {
            builder.append(',').append(value[i]);
        }
        return builder.append(']').toString();
    }

    @Override
    public ClickHouseLongArrayValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseLongArrayValue((long[])this.getValue());
        }
        long[] value = (long[])this.getValue();
        return new ClickHouseLongArrayValue(Arrays.copyOf(value, value.length));
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((long[])this.getValue()).length == 0;
    }

    @Override
    public ClickHouseLongArrayValue resetToDefault() {
        this.set(ClickHouseValues.EMPTY_LONG_ARRAY);
        return this;
    }

    @Override
    public ClickHouseLongArrayValue resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        return this.asString();
    }

    @Override
    public ClickHouseLongArrayValue update(boolean[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        long[] v = new long[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] ? 1L : 0L;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseLongArrayValue update(char[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        long[] v = new long[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseLongArrayValue update(byte value) {
        return this.set(new long[]{value});
    }

    @Override
    public ClickHouseLongArrayValue update(byte[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        long[] v = new long[len];
        for (int i = 0; i < len; ++i) {
            v[i] = 0xFFL & (long)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseLongArrayValue update(short value) {
        return this.set(new long[]{value});
    }

    @Override
    public ClickHouseLongArrayValue update(short[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        long[] v = new long[len];
        for (int i = 0; i < len; ++i) {
            v[i] = 0xFFFFL & (long)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseLongArrayValue update(int value) {
        return this.set(new long[]{value});
    }

    @Override
    public ClickHouseLongArrayValue update(int[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        long[] v = new long[len];
        for (int i = 0; i < len; ++i) {
            v[i] = 0xFFFFFFFFL & (long)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseLongArrayValue update(long value) {
        return this.set(new long[]{value});
    }

    @Override
    public ClickHouseLongArrayValue update(long[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        return this.set(value);
    }

    @Override
    public ClickHouseLongArrayValue update(float value) {
        return this.set(new long[]{(long)value});
    }

    @Override
    public ClickHouseLongArrayValue update(float[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        long[] v = new long[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (long)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseLongArrayValue update(double value) {
        return this.set(new long[]{(long)value});
    }

    @Override
    public ClickHouseLongArrayValue update(double[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        long[] v = new long[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (long)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseLongArrayValue update(BigInteger value) {
        long[] lArray;
        if (value == null) {
            lArray = ClickHouseValues.EMPTY_LONG_ARRAY;
        } else {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = value.longValue();
        }
        return this.set(lArray);
    }

    @Override
    public ClickHouseLongArrayValue update(BigDecimal value) {
        long[] lArray;
        if (value == null) {
            lArray = ClickHouseValues.EMPTY_LONG_ARRAY;
        } else {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = value.longValue();
        }
        return this.set(lArray);
    }

    @Override
    public ClickHouseLongArrayValue update(Enum<?> value) {
        long[] lArray;
        if (value == null) {
            lArray = ClickHouseValues.EMPTY_LONG_ARRAY;
        } else {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = value.ordinal();
        }
        return this.set(lArray);
    }

    @Override
    public ClickHouseLongArrayValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet4Address", TYPE_NAME);
    }

    @Override
    public ClickHouseLongArrayValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet6Address", TYPE_NAME);
    }

    @Override
    public ClickHouseLongArrayValue update(LocalDate value) {
        long[] lArray;
        if (value == null) {
            lArray = ClickHouseValues.EMPTY_LONG_ARRAY;
        } else {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = value.toEpochDay();
        }
        return this.set(lArray);
    }

    @Override
    public ClickHouseLongArrayValue update(LocalTime value) {
        long[] lArray;
        if (value == null) {
            lArray = ClickHouseValues.EMPTY_LONG_ARRAY;
        } else {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = value.toSecondOfDay();
        }
        return this.set(lArray);
    }

    @Override
    public ClickHouseLongArrayValue update(LocalDateTime value) {
        long[] lArray;
        if (value == null) {
            lArray = ClickHouseValues.EMPTY_LONG_ARRAY;
        } else {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = value.toEpochSecond(ZoneOffset.UTC);
        }
        return this.set(lArray);
    }

    @Override
    public ClickHouseLongArrayValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        long[] v = new long[size];
        int index = 0;
        for (Object o : value) {
            v[index++] = o == null ? 0L : ((Number)o).longValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseLongArrayValue update(Enumeration<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        LinkedList<Number> v = new LinkedList<Number>();
        while (value.hasMoreElements()) {
            v.add((Number)value.nextElement());
        }
        long[] values = new long[v.size()];
        int index = 0;
        for (Number n : v) {
            values[index++] = n == null ? 0L : n.longValue();
        }
        return this.set(values);
    }

    @Override
    public ClickHouseLongArrayValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        long[] v = new long[size];
        int index = 0;
        for (Map.Entry<?, ?> e : value.entrySet()) {
            Object o = e.getValue();
            v[index++] = o == null ? 0L : ((Number)e.getValue()).longValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseLongArrayValue update(String value) {
        if (ClickHouseChecker.isNullOrBlank(value)) {
            this.set(ClickHouseValues.EMPTY_LONG_ARRAY);
        } else {
            List<String> list = ClickHouseUtils.readValueArray(value, 0, value.length());
            if (list.isEmpty()) {
                this.set(ClickHouseValues.EMPTY_LONG_ARRAY);
            } else {
                long[] arr = new long[list.size()];
                int index = 0;
                for (String v : list) {
                    arr[index++] = v == null ? 0L : Long.parseLong(v);
                }
                this.set(arr);
            }
        }
        return this;
    }

    @Override
    public ClickHouseLongArrayValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("UUID", TYPE_NAME);
    }

    @Override
    public ClickHouseLongArrayValue update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof ClickHouseLongArrayValue) {
            this.set((long[])((ClickHouseLongArrayValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseLongArrayValue update(Object[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        long[] values = new long[len];
        for (int i = 0; i < len; ++i) {
            Object o = value[i];
            values[i] = o == null ? 0L : ((Number)o).longValue();
        }
        this.set(values);
        return this;
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Number) {
            return this.set(new long[]{((Number)value).longValue()});
        }
        throw this.newUnsupportedException(value.getClass().getName(), TYPE_NAME);
    }

    @Override
    public ClickHouseLongArrayValue update(Object value) {
        if (value instanceof long[]) {
            this.set((long[])value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals((long[])this.getValue(), (long[])((ClickHouseLongArrayValue)obj).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((long[])this.getValue());
    }

    @Override
    public ClickHouseArraySequence allocate(int length, Class<?> clazz, int level) {
        if (length < 1) {
            this.resetToDefault();
        } else if (this.length() != length) {
            this.set(new long[length]);
        }
        return this;
    }

    @Override
    public int length() {
        return this.isNullOrEmpty() ? 0 : ((long[])this.getValue()).length;
    }

    @Override
    public <V extends ClickHouseValue> V getValue(int index, V value) {
        value.update(((long[])this.getValue())[index]);
        return value;
    }

    @Override
    public ClickHouseArraySequence setValue(int index, ClickHouseValue value) {
        ((long[])this.getValue())[index] = value.asLong();
        return this;
    }

    static final class UnsignedLongArrayValue
    extends ClickHouseLongArrayValue {
        @Override
        public Object[] asArray() {
            long[] v = (long[])this.getValue();
            int len = v.length;
            Object[] array = new UnsignedLong[len];
            for (int i = 0; i < len; ++i) {
                array[i] = UnsignedLong.valueOf(v[i]);
            }
            return array;
        }

        @Override
        public String asString() {
            long[] v = (long[])this.getValue();
            int len = v.length;
            if (len == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder().append('[').append(Long.toUnsignedString(v[0]));
            for (int i = 1; i < len; ++i) {
                builder.append(',').append(Long.toUnsignedString(v[i]));
            }
            return builder.append(']').toString();
        }

        @Override
        public UnsignedLongArrayValue copy(boolean deep) {
            if (!deep) {
                return new UnsignedLongArrayValue((long[])this.getValue());
            }
            long[] value = (long[])this.getValue();
            return new UnsignedLongArrayValue(Arrays.copyOf(value, value.length));
        }

        @Override
        public UnsignedLongArrayValue update(String value) {
            if (ClickHouseChecker.isNullOrBlank(value)) {
                this.set(ClickHouseValues.EMPTY_LONG_ARRAY);
            } else {
                List<String> list = ClickHouseUtils.readValueArray(value, 0, value.length());
                if (list.isEmpty()) {
                    this.set(ClickHouseValues.EMPTY_LONG_ARRAY);
                } else {
                    long[] arr = new long[list.size()];
                    int index = 0;
                    for (String v : list) {
                        arr[index++] = v == null ? 0L : (long)Integer.parseUnsignedInt(v);
                    }
                    this.set(arr);
                }
            }
            return this;
        }

        protected UnsignedLongArrayValue(long[] value) {
            super(value);
        }
    }
}

