/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.config.ClickHouseDefaultOption;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.compress.BrotliSupport;
import com.clickhouse.data.compress.Bz2Support;
import com.clickhouse.data.compress.DeflateSupport;
import com.clickhouse.data.compress.GzipSupport;
import com.clickhouse.data.compress.Lz4Support;
import com.clickhouse.data.compress.NoneSupport;
import com.clickhouse.data.compress.SnappySupport;
import com.clickhouse.data.compress.XzSupport;
import com.clickhouse.data.compress.ZstdSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface ClickHouseCompressionAlgorithm {
    public static final String ERROR_FAILED_TO_WRAP_INPUT = "Failed to wrap input stream";
    public static final String ERROR_FAILED_TO_WRAP_OUTPUT = "Failed to wrap output stream";
    public static final String ERROR_UNSUPPORTED_COMPRESS_ALG = "Compression algorithm [%s] is not supported";
    public static final String ERROR_UNSUPPORTED_DECOMPRESS_ALG = "Decompression algorithm [%s] is not supported";
    public static final ClickHouseOption COMPRESSION_LIB_DETECTION = new ClickHouseDefaultOption("compression_lib_detection", true);

    public static ClickHouseCompressionAlgorithm createInstance(String option, Class<? extends ClickHouseCompressionAlgorithm> preferredInstance, Class<? extends ClickHouseCompressionAlgorithm> defaultInstance) {
        ClickHouseCompressionAlgorithm alg = null;
        if (((Boolean)new ClickHouseDefaultOption(option, Boolean.valueOf((Boolean)COMPRESSION_LIB_DETECTION.getEffectiveDefaultValue())).getEffectiveDefaultValue()).booleanValue()) {
            try {
                alg = preferredInstance.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (alg == null) {
            try {
                alg = defaultInstance.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new UnsupportedOperationException("Failed to create default instance of " + defaultInstance, e);
            }
        }
        return alg;
    }

    public static ClickHouseInputStream createInputStream(ClickHousePassThruStream stream, InputStream input, int bufferSize, ClickHouseCompression compression, int level, Runnable postCloseAction) {
        try {
            return ClickHouseCompressionAlgorithm.of(compression).decompress(stream, input, bufferSize, level, postCloseAction);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(ERROR_FAILED_TO_WRAP_INPUT, e);
        }
        catch (NoClassDefFoundError e) {
            throw new UnsupportedOperationException(ClickHouseUtils.format(ERROR_UNSUPPORTED_DECOMPRESS_ALG, new Object[]{compression}), e);
        }
    }

    public static ClickHouseOutputStream createOutputStream(ClickHousePassThruStream stream, OutputStream output, int bufferSize, ClickHouseCompression compression, int level, Runnable postCloseAction) {
        try {
            return ClickHouseCompressionAlgorithm.of(compression).compress(stream, output, bufferSize, level, postCloseAction);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(ERROR_FAILED_TO_WRAP_OUTPUT, e);
        }
        catch (NoClassDefFoundError e) {
            throw new UnsupportedOperationException(ClickHouseUtils.format(ERROR_UNSUPPORTED_COMPRESS_ALG, new Object[]{compression}), e);
        }
    }

    public static ClickHouseCompressionAlgorithm of(ClickHouseCompression compression) {
        ClickHouseCompressionAlgorithm alg;
        if (compression == null || compression == ClickHouseCompression.NONE) {
            return NoneSupport.getInstance();
        }
        switch (compression) {
            case BROTLI: {
                alg = BrotliSupport.getInstance();
                break;
            }
            case BZ2: {
                alg = Bz2Support.getInstance();
                break;
            }
            case DEFLATE: {
                alg = DeflateSupport.getInstance();
                break;
            }
            case GZIP: {
                alg = GzipSupport.getInstance();
                break;
            }
            case LZ4: {
                alg = Lz4Support.getInstance();
                break;
            }
            case SNAPPY: {
                alg = SnappySupport.getInstance();
                break;
            }
            case XZ: {
                alg = XzSupport.getInstance();
                break;
            }
            case ZSTD: {
                alg = ZstdSupport.getInstance();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported decompression algorithm: " + (Object)((Object)compression));
            }
        }
        return alg;
    }

    default public ClickHouseInputStream decompress(ClickHousePassThruStream stream, InputStream input, int bufferSize, int level, Runnable postCloseAction) throws IOException {
        throw new UnsupportedOperationException(ClickHouseUtils.format(ERROR_UNSUPPORTED_DECOMPRESS_ALG, new Object[]{this.getAlgorithm()}));
    }

    default public ClickHouseOutputStream compress(ClickHousePassThruStream stream, OutputStream output, int bufferSize, int level, Runnable postCloseAction) throws IOException {
        throw new UnsupportedOperationException(ClickHouseUtils.format(ERROR_UNSUPPORTED_COMPRESS_ALG, new Object[]{this.getAlgorithm()}));
    }

    public ClickHouseCompression getAlgorithm();
}

