/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseThreadFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class ClickHouseUtils {
    private static final boolean IS_UNIX;
    private static final boolean IS_WINDOWS;
    private static final String HOME_DIR;
    public static final String DEFAULT_CHARSET;
    public static final int MIN_CORE_THREADS = 4;
    public static final CompletableFuture<Void> NULL_FUTURE;
    public static final Supplier<?> NULL_SUPPLIER;
    public static final String VARIABLE_PREFIX = "{{";
    public static final String VARIABLE_SUFFIX = "}}";

    public static String applyVariables(String template, UnaryOperator<String> applyFunc) {
        if (template == null) {
            template = "";
        }
        if (applyFunc == null) {
            return template;
        }
        StringBuilder sb = new StringBuilder();
        int len = template.length();
        for (int i = 0; i < len; ++i) {
            int index = template.indexOf(VARIABLE_PREFIX, i);
            if (index != -1) {
                sb.append(template.substring(i, index));
                i = index;
                index = template.indexOf(VARIABLE_SUFFIX, i);
                if (index != -1) {
                    String variable = template.substring(i + VARIABLE_PREFIX.length(), index).trim();
                    String value = (String)applyFunc.apply(variable);
                    if (value == null) {
                        i += VARIABLE_PREFIX.length() - 1;
                        sb.append(VARIABLE_PREFIX);
                        continue;
                    }
                    i = index + VARIABLE_SUFFIX.length() - 1;
                    sb.append(value);
                    continue;
                }
                sb.append(template.substring(i));
                break;
            }
            sb.append(template.substring(i));
            break;
        }
        return sb.toString();
    }

    public static String applyVariables(String template, Map<String, String> variables) {
        return ClickHouseUtils.applyVariables(template, variables == null || variables.isEmpty() ? null : variables::get);
    }

    public static File createTempFile() throws IOException {
        return ClickHouseUtils.createTempFile(null, null, true);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return ClickHouseUtils.createTempFile(prefix, suffix, true);
    }

    public static File createTempFile(String prefix, String suffix, boolean deleteOnExit) throws IOException {
        File f;
        if (prefix == null || prefix.isEmpty()) {
            prefix = "ch";
        }
        if (suffix == null || suffix.isEmpty()) {
            suffix = ".data";
        }
        if (IS_UNIX) {
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
            f = Files.createTempFile(prefix, suffix, attr).toFile();
        } else {
            f = Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
            f.setReadable(true, true);
            f.setWritable(true, true);
            f.setExecutable(false, false);
        }
        if (deleteOnExit) {
            f.deleteOnExit();
        }
        return f;
    }

    public static String decode(String encodedString) {
        if (ClickHouseChecker.isNullOrEmpty(encodedString)) {
            return "";
        }
        try {
            return URLDecoder.decode(encodedString, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return encodedString;
        }
    }

    public static String encode(String str) {
        if (ClickHouseChecker.isNullOrEmpty(str)) {
            return "";
        }
        try {
            return URLEncoder.encode(str, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    private static <T> T findFirstService(Class<? extends T> serviceInterface) {
        ClickHouseChecker.nonNull(serviceInterface, "serviceInterface");
        T service = null;
        for (T s : ServiceLoader.load(serviceInterface, ClickHouseUtils.class.getClassLoader())) {
            if (s == null) continue;
            service = s;
            break;
        }
        return service;
    }

    public static String toJavaByteArrayExpression(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        int len = bytes.length;
        if (len == 0) {
            return "{}";
        }
        String prefix = "(byte)0x";
        StringBuilder builder = new StringBuilder(10 * len).append('{');
        for (int i = 0; i < len; ++i) {
            builder.append(prefix).append(String.format("%02X", 0xFF & bytes[i])).append(',');
        }
        builder.setCharAt(builder.length() - 1, '}');
        return builder.toString();
    }

    public static int indexOf(byte[] bytes, byte[] search) {
        if (bytes == null || search == null) {
            return -1;
        }
        int slen = search.length;
        if (slen == 0) {
            return 0;
        }
        int blen = bytes.length;
        int len = blen - slen + 1;
        block0: for (int i = 0; i < len; ++i) {
            for (int j = 0; j < slen; ++j) {
                if (bytes[i + j] != search[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static ExecutorService newThreadPool(Object owner, int maxThreads, int maxRequests) {
        return ClickHouseUtils.newThreadPool(owner, maxThreads, 0, maxRequests, 0L, true);
    }

    public static ExecutorService newThreadPool(Object owner, int coreThreads, int maxThreads, int maxRequests, long keepAliveTimeoutMs, boolean allowCoreThreadTimeout) {
        LinkedBlockingQueue<Runnable> queue;
        if (coreThreads < 4) {
            coreThreads = 4;
        }
        if (maxRequests > 0) {
            queue = new ArrayBlockingQueue(maxRequests);
            if (maxThreads <= coreThreads) {
                maxThreads = coreThreads * 2;
            }
        } else {
            queue = new LinkedBlockingQueue();
            if (maxThreads != coreThreads) {
                maxThreads = coreThreads;
            }
        }
        if (keepAliveTimeoutMs <= 0L) {
            keepAliveTimeoutMs = allowCoreThreadTimeout ? 1000L : 0L;
        }
        ThreadPoolExecutor pool = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTimeoutMs, TimeUnit.MILLISECONDS, queue, new ClickHouseThreadFactory(owner), new ThreadPoolExecutor.AbortPolicy());
        if (allowCoreThreadTimeout) {
            pool.allowCoreThreadTimeOut(true);
        }
        return pool;
    }

    public static boolean isCloseBracket(char ch) {
        return ch == ')' || ch == ']' || ch == '}';
    }

    public static boolean isOpenBracket(char ch) {
        return ch == '(' || ch == '[' || ch == '{';
    }

    public static boolean isQuote(char ch) {
        return ch == '\'' || ch == '`' || ch == '\"';
    }

    public static boolean isSeparator(char ch) {
        return ch == ',' || ch == ';';
    }

    public static String escape(String str, char quote) {
        if (str == null) {
            return str;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 10);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == quote || ch == '\\') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String unescape(String str) {
        if (ClickHouseChecker.isNullOrEmpty(str)) {
            return str;
        }
        int len = str.length();
        char quote = str.charAt(0);
        if (!ClickHouseUtils.isQuote(quote) || quote != str.charAt(len - 1)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(--len);
        for (int i = 1; i < len; ++i) {
            char ch = str.charAt(i);
            if (++i >= len) {
                sb.append(ch);
                continue;
            }
            char nextChar = str.charAt(i);
            if (ch == '\\' || ch == quote && nextChar == quote) {
                sb.append(nextChar);
                continue;
            }
            sb.append(ch);
            --i;
        }
        return sb.toString();
    }

    public static String format(String template, Object ... args) {
        return String.format(Locale.ROOT, template, args);
    }

    public static String normalizeDirectory(String dir) {
        if (dir == null || dir.isEmpty()) {
            return "./";
        }
        return dir.charAt(dir.length() - 1) == '/' ? dir : dir.concat("/");
    }

    private static int readJsonArray(String json, List<Object> array, int startIndex, int len) {
        StringBuilder builder = new StringBuilder();
        for (int i = startIndex + 1; i < len; ++i) {
            AbstractList list;
            char ch = json.charAt(i);
            if (Character.isWhitespace(ch) || ch == ',' || ch == ':') continue;
            if (ch == '\"') {
                i = ClickHouseUtils.readUnescapedJsonString(json, builder, i, len) - 1;
                array.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (ch == '-' || ch >= '0' && ch <= '9') {
                list = new ArrayList<Object>(1);
                i = ClickHouseUtils.readJsonNumber(json, list, i, len) - 1;
                array.add(list.get(0));
                builder.setLength(0);
                continue;
            }
            if (ch == '{') {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                i = ClickHouseUtils.readJsonObject(json, map, i, len) - 1;
                array.add(map);
                continue;
            }
            if (ch == '[') {
                list = new LinkedList();
                i = ClickHouseUtils.readJsonArray(json, list, i, len) - 1;
                array.add(list.toArray(new Object[0]));
                continue;
            }
            if (ch == ']') {
                return i + 1;
            }
            list = new ArrayList(1);
            i = ClickHouseUtils.readJsonConstants(json, list, i, len) - 1;
            array.add(list.get(0));
        }
        return len;
    }

    private static int readJsonConstants(String json, List<Object> value, int startIndex, int len) {
        String c = "null";
        if (json.indexOf(c, startIndex) == startIndex) {
            value.add(null);
        } else {
            c = "false";
            if (json.indexOf("false", startIndex) == startIndex) {
                value.add(Boolean.FALSE);
            } else {
                c = "true";
                if (json.indexOf("true", startIndex) == startIndex) {
                    value.add(Boolean.TRUE);
                } else {
                    throw new IllegalArgumentException(ClickHouseUtils.format("Expect one of 'null', 'false', 'true' but we got '%s'", json.substring(startIndex, Math.min(startIndex + 5, len))));
                }
            }
        }
        return startIndex + c.length();
    }

    private static int readJsonNumber(String json, List<Object> value, int startIndex, int len) {
        int endIndex = len;
        StringBuilder builder = new StringBuilder().append(json.charAt(startIndex));
        boolean hasDot = false;
        boolean hasExp = false;
        block0: for (int i = startIndex + 1; i < len; ++i) {
            char n = json.charAt(i);
            if (n >= '0' && n <= '9') {
                builder.append(n);
                continue;
            }
            if (!hasDot && n == '.') {
                hasDot = true;
                builder.append(n);
                continue;
            }
            if (!(hasExp || n != 'e' && n != 'E')) {
                char next;
                hasDot = true;
                hasExp = true;
                builder.append(n);
                if (i + 1 < len && ((next = json.charAt(i + 1)) == '+' || next == '-')) {
                    builder.append(next);
                    ++i;
                }
                boolean hasNum = false;
                for (int j = i + 1; j < len; ++j) {
                    char next2 = json.charAt(j);
                    if (next2 < '0' || next2 > '9') {
                        if (!hasNum) {
                            throw new IllegalArgumentException("Expect number after exponent at " + i);
                        }
                        endIndex = j + 1;
                        break block0;
                    }
                    hasNum = true;
                    builder.append(next2);
                }
                break;
            }
            endIndex = i;
            break;
        }
        if (hasDot) {
            if (hasExp || builder.length() >= 21) {
                value.add(new BigDecimal(builder.toString()));
            } else if (builder.length() >= 11) {
                value.add(Double.parseDouble(builder.toString()));
            } else {
                value.add(Float.valueOf(Float.parseFloat(builder.toString())));
            }
        } else if (hasExp || builder.length() >= 19) {
            value.add(new BigInteger(builder.toString()));
        } else if (builder.length() >= 10) {
            value.add(Long.parseLong(builder.toString()));
        } else {
            value.add(Integer.parseInt(builder.toString()));
        }
        return endIndex;
    }

    private static int readJsonObject(String json, Map<String, Object> object, int startIndex, int len) {
        StringBuilder builder = new StringBuilder();
        String key = null;
        for (int i = startIndex + 1; i < len; ++i) {
            AbstractList list;
            char ch = json.charAt(i);
            if (Character.isWhitespace(ch) || ch == ',' || ch == ':') continue;
            if (ch == '\"') {
                i = ClickHouseUtils.readUnescapedJsonString(json, builder, i, len) - 1;
                if (key != null) {
                    object.put(key, builder.toString());
                    key = null;
                } else {
                    key = builder.toString();
                }
                builder.setLength(0);
                continue;
            }
            if (ch == '-' || ch >= '0' && ch <= '9') {
                if (key == null) {
                    throw new IllegalArgumentException("Key is not available");
                }
                list = new ArrayList<Object>(1);
                i = ClickHouseUtils.readJsonNumber(json, list, i, len) - 1;
                object.put(key, list.get(0));
                key = null;
                builder.setLength(0);
                continue;
            }
            if (ch == '{') {
                if (key == null) {
                    throw new IllegalArgumentException("Key is not available");
                }
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                i = ClickHouseUtils.readJsonObject(json, map, i, len) - 1;
                object.put(key, map);
                key = null;
                builder.setLength(0);
                continue;
            }
            if (ch == '[') {
                if (key == null) {
                    throw new IllegalArgumentException("Key is not available");
                }
                list = new LinkedList();
                i = ClickHouseUtils.readJsonArray(json, list, i, len) - 1;
                key = null;
                object.put(key, list.toArray(new Object[0]));
                continue;
            }
            if (ch == '}') {
                return i + 1;
            }
            if (key == null) {
                throw new IllegalArgumentException("Key is not available");
            }
            list = new ArrayList(1);
            i = ClickHouseUtils.readJsonConstants(json, list, i, len) - 1;
            object.put(key, list.get(0));
            key = null;
        }
        return len;
    }

    private static int readUnescapedJsonString(String json, StringBuilder builder, int startIndex, int len) {
        for (int i = startIndex + 1; i < len; ++i) {
            char c = json.charAt(i);
            if (c == '\\') {
                if (++i >= len) continue;
                builder.append(json.charAt(i));
                continue;
            }
            if (c == '\"') {
                return i + 1;
            }
            builder.append(c);
        }
        return len;
    }

    public static Object parseJson(String json) {
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("Non-empty JSON string is required");
        }
        boolean hasValue = false;
        Object value = null;
        StringBuilder builder = new StringBuilder();
        int len = json.length();
        for (int i = 0; i < len; ++i) {
            AbstractList list;
            char ch = json.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '{') {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                i = ClickHouseUtils.readJsonObject(json, map, i, len) - 1;
                hasValue = true;
                value = map;
            } else if (ch == '[') {
                list = new LinkedList<Object>();
                i = ClickHouseUtils.readJsonArray(json, list, i, len) - 1;
                hasValue = true;
                value = list.toArray(new Object[0]);
            } else if (ch == '\"') {
                i = ClickHouseUtils.readUnescapedJsonString(json, builder, i, len) - 1;
                hasValue = true;
                value = builder.toString();
            } else if (ch == '-' || ch >= '0' && ch <= '9') {
                list = new ArrayList(1);
                i = ClickHouseUtils.readJsonNumber(json, list, i, len) - 1;
                hasValue = true;
                value = list.get(0);
            } else {
                list = new ArrayList(1);
                i = ClickHouseUtils.readJsonConstants(json, list, i, len) - 1;
                hasValue = true;
                value = list.get(0);
            }
            if (hasValue) break;
        }
        if (!hasValue) {
            throw new IllegalArgumentException("No value extracted from given JSON string");
        }
        return value;
    }

    public static char getCloseBracket(char openBracket) {
        int closeBracket;
        if (openBracket == '(') {
            closeBracket = 41;
        } else if (openBracket == '[') {
            closeBracket = 93;
        } else if (openBracket == '{') {
            closeBracket = 125;
        } else {
            throw new IllegalArgumentException("Unsupported bracket: " + openBracket);
        }
        return (char)closeBracket;
    }

    public static <T> T getService(Class<? extends T> serviceInterface) {
        return ClickHouseUtils.getService(serviceInterface, null);
    }

    public static <T> T getService(Class<? extends T> serviceInterface, T defaultService) {
        T service = defaultService;
        Exception error = null;
        try {
            T s = ClickHouseUtils.findFirstService(serviceInterface);
            if (s != null) {
                service = s;
            }
        }
        catch (Exception t) {
            error = t;
        }
        if (service == null) {
            throw new IllegalStateException(String.format("Failed to get service %s", serviceInterface.getName()), error);
        }
        return service;
    }

    public static <T> T getService(Class<? extends T> serviceInterface, Supplier<T> supplier) {
        T service = null;
        Exception error = null;
        try {
            service = ClickHouseUtils.findFirstService(serviceInterface);
        }
        catch (Exception t) {
            error = t;
        }
        if (service == null && supplier != null) {
            try {
                service = supplier.get();
            }
            catch (Exception t) {
                error = t;
            }
        }
        if (service == null) {
            throw new IllegalStateException(String.format("Failed to get service %s", serviceInterface.getName()), error);
        }
        return service;
    }

    public static InputStream getFileInputStream(String file) throws FileNotFoundException {
        Path path = Paths.get(ClickHouseChecker.nonBlank(file, "file"), new String[0]);
        StringBuilder builder = new StringBuilder();
        InputStream in = null;
        if (Files.exists(path, new LinkOption[0])) {
            builder.append(',').append(file);
            in = new FileInputStream(path.toFile());
        } else if (!path.isAbsolute() && Files.exists(path = Paths.get(HOME_DIR, file), new LinkOption[0])) {
            builder.append(',').append(path.toString());
            in = new FileInputStream(path.toFile());
        }
        if (in == null) {
            builder.append(',').append("classpath:").append(file);
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        }
        if (in == null) {
            throw new FileNotFoundException(ClickHouseUtils.format("Could not open file from: %s", builder.deleteCharAt(0).toString()));
        }
        return in;
    }

    public static OutputStream getFileOutputStream(String file) throws IOException {
        Path path = Paths.get(ClickHouseChecker.nonBlank(file, "file"), new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        return new FileOutputStream(file, false);
    }

    public static String getLeadingComment(String sql) {
        if (sql == null || sql.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int len = sql.length();
        while (i + 1 < len) {
            int index;
            char ch = sql.charAt(i);
            char nextCh = sql.charAt(i + 1);
            if (ch == '-' && nextCh == '-') {
                index = ClickHouseUtils.skipSingleLineComment(sql, i, len);
                if (index > i + 2) {
                    builder.append(sql.substring(i + 2, index).trim());
                }
                i = index - 1;
            } else if (ch == '/' && nextCh == '*') {
                index = ClickHouseUtils.skipMultiLineComment(sql, i + 2, len);
                if (index > i + 4) {
                    builder.append(sql.substring(i + 2, index - 2).trim());
                }
                i = index - 1;
            } else if (!Character.isWhitespace(ch)) break;
            if (builder.length() > 0) break;
            ++i;
        }
        return builder.toString();
    }

    public static String getProperty(String key, Properties ... props) {
        return ClickHouseUtils.getProperty(key, null, props);
    }

    public static String getProperty(String key, String defaultValue, Properties ... props) {
        String value = null;
        if (props != null) {
            Properties p;
            Properties[] propertiesArray = props;
            int n = propertiesArray.length;
            for (int i = 0; i < n && (value = (p = propertiesArray[i]).getProperty(key)) == null; ++i) {
            }
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value == null ? defaultValue : value;
    }

    public static int skipBrackets(String args, int startIndex, int len, char bracket) {
        char closeBracket = ClickHouseUtils.getCloseBracket(bracket);
        ArrayDeque<Character> stack = new ArrayDeque<Character>();
        for (int i = startIndex + (startIndex < len && args.charAt(startIndex) == bracket ? 1 : 0); i < len; ++i) {
            char ch = args.charAt(i);
            if (ClickHouseUtils.isQuote(ch)) {
                i = ClickHouseUtils.skipQuotedString(args, i, len, ch) - 1;
                continue;
            }
            if (ClickHouseUtils.isOpenBracket(ch)) {
                stack.push(Character.valueOf(closeBracket));
                closeBracket = ClickHouseUtils.getCloseBracket(ch);
                continue;
            }
            if (ch == closeBracket) {
                if (stack.isEmpty()) {
                    return i + 1;
                }
                closeBracket = ((Character)stack.pop()).charValue();
                continue;
            }
            if (i + 1 >= len) continue;
            char nextChar = args.charAt(i + 1);
            if (ch == '-' && nextChar == '-') {
                i = ClickHouseUtils.skipSingleLineComment(args, i + 2, len) - 1;
                continue;
            }
            if (ch != '/' || nextChar != '*') continue;
            i = ClickHouseUtils.skipMultiLineComment(args, i + 2, len) - 1;
        }
        throw new IllegalArgumentException("Missing closing bracket(s): " + stack);
    }

    public static int skipQuotedString(String args, int startIndex, int len, char quote) {
        for (int i = startIndex; i < len; ++i) {
            char ch = args.charAt(i);
            if (ch == '\\') {
                ++i;
                continue;
            }
            if (ch != quote || i <= startIndex || ++i < len && args.charAt(i) == quote) continue;
            return i;
        }
        throw new IllegalArgumentException("Missing quote: " + quote);
    }

    public static int skipSingleLineComment(String args, int startIndex, int len) {
        int index = args.indexOf(10, startIndex);
        return index > startIndex ? index + 1 : len;
    }

    public static int skipMultiLineComment(String args, int startIndex, int len) {
        int closeIndex;
        int openIndex = args.indexOf("/*", startIndex);
        if (openIndex == startIndex) {
            openIndex = args.indexOf("/*", startIndex + 2);
        }
        if ((closeIndex = args.indexOf("*/", startIndex)) < startIndex) {
            throw new IllegalArgumentException("Unclosed multi-line comment");
        }
        return openIndex < startIndex || openIndex > closeIndex ? closeIndex + 2 : ClickHouseUtils.skipMultiLineComment(args, closeIndex + 2, len);
    }

    public static int skipContentsUntil(String args, int startIndex, int len, char ... endChars) {
        int charLen;
        int n = charLen = endChars != null ? endChars.length : 0;
        if (charLen == 0) {
            endChars = new char[]{'\u0000'};
            charLen = 1;
        }
        for (int i = startIndex; i < len; ++i) {
            char ch = args.charAt(i);
            for (int j = 0; j < charLen; ++j) {
                if (ch != endChars[j]) continue;
                return i + 1;
            }
            if (ClickHouseUtils.isQuote(ch)) {
                i = ClickHouseUtils.skipQuotedString(args, i, len, ch) - 1;
                continue;
            }
            if (ClickHouseUtils.isOpenBracket(ch)) {
                i = ClickHouseUtils.skipBrackets(args, i, len, ch) - 1;
                continue;
            }
            if (i + 1 >= len) continue;
            char nextCh = args.charAt(i + 1);
            if (ch == '-' && nextCh == '-') {
                i = ClickHouseUtils.skipSingleLineComment(args, i + 2, len) - 1;
                continue;
            }
            if (ch != '/' || nextCh != '*') continue;
            i = ClickHouseUtils.skipMultiLineComment(args, i + 2, len) - 1;
        }
        return len;
    }

    public static int skipContentsUntil(String args, int startIndex, int len, String keyword, boolean caseSensitive) {
        if (keyword == null || keyword.isEmpty()) {
            return Math.min(startIndex + 1, len);
        }
        int k = keyword.length();
        if (k == 1) {
            return ClickHouseUtils.skipContentsUntil(args, startIndex, len, keyword.charAt(0));
        }
        for (int i = startIndex; i < len; ++i) {
            char ch = args.charAt(i);
            if (ClickHouseUtils.isQuote(ch)) {
                i = ClickHouseUtils.skipQuotedString(args, i, len, ch) - 1;
                continue;
            }
            if (ClickHouseUtils.isOpenBracket(ch)) {
                i = ClickHouseUtils.skipBrackets(args, i, len, ch) - 1;
                continue;
            }
            if (i + 1 >= len) continue;
            char nextCh = args.charAt(i + 1);
            if (ch == '-' && nextCh == '-') {
                i = ClickHouseUtils.skipSingleLineComment(args, i + 2, len) - 1;
                continue;
            }
            if (ch == '/' && nextCh == '*') {
                i = ClickHouseUtils.skipMultiLineComment(args, i + 2, len) - 1;
                continue;
            }
            if (i + k >= len) continue;
            int endIndex = i + k;
            String s = args.substring(i, endIndex);
            if ((!caseSensitive || !s.equals(keyword)) && (caseSensitive || !s.equalsIgnoreCase(keyword))) continue;
            return endIndex;
        }
        return len;
    }

    public static int skipContentsUntil(String args, int startIndex, int len, String[] keywords, boolean caseSensitive) {
        int k;
        int n = k = keywords != null ? keywords.length : 0;
        if (k == 0) {
            return Math.min(startIndex + 1, len);
        }
        int index = ClickHouseUtils.skipContentsUntil(args, startIndex, len, keywords[0], caseSensitive);
        block0: for (int j = 1; j < k; ++j) {
            String keyword = keywords[j];
            if (keyword == null || keyword.isEmpty()) {
                ++index;
                continue;
            }
            int klen = keyword.length();
            if (index + klen >= len) {
                return len;
            }
            for (int i = index; i < len; ++i) {
                String s = args.substring(i, i + klen);
                if (caseSensitive && s.equals(keyword) || !caseSensitive && s.equalsIgnoreCase(keyword)) {
                    index = i + klen;
                    continue block0;
                }
                char ch = args.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                if (i + 1 < len) {
                    char nextCh = args.charAt(i + 1);
                    if (ch == '-' && nextCh == '-') {
                        i = ClickHouseUtils.skipSingleLineComment(args, i + 2, len) - 1;
                        continue;
                    }
                    if (ch == '/' && nextCh == '*') {
                        i = ClickHouseUtils.skipMultiLineComment(args, i + 2, len) - 1;
                        continue;
                    }
                    return len;
                }
                return len;
            }
        }
        return index;
    }

    public static int readNameOrQuotedString(String args, int startIndex, int len, StringBuilder builder) {
        char quote = '\u0000';
        for (int i = startIndex; i < len; ++i) {
            char ch = args.charAt(i);
            if (ch == '\\') {
                if (++i >= len) continue;
                builder.append(args.charAt(i));
                continue;
            }
            if (ClickHouseUtils.isQuote(ch)) {
                if (ch == quote) {
                    if (i + 1 < len && args.charAt(i + 1) == ch) {
                        builder.append(ch);
                        ++i;
                        continue;
                    }
                    len = i + 1;
                    break;
                }
                if (quote == '\u0000') {
                    quote = ch;
                    continue;
                }
                builder.append(ch);
                continue;
            }
            if (quote == '\u0000' && (Character.isWhitespace(ch) || ClickHouseUtils.isOpenBracket(ch) || ClickHouseUtils.isCloseBracket(ch) || ClickHouseUtils.isSeparator(ch) || i + 1 < len && (ch == '-' && args.charAt(i + 1) == '-' || ch == '/' && args.charAt(i + 1) == '*'))) {
                if (builder.length() <= 0) continue;
                len = i;
                break;
            }
            builder.append(ch);
        }
        return len;
    }

    public static int readEnumValues(String args, int startIndex, int len, Map<String, Integer> values) {
        String name = null;
        StringBuilder builder = new StringBuilder();
        block0: for (int i = startIndex; i < len; ++i) {
            char ch = args.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '\'') {
                i = ClickHouseUtils.readNameOrQuotedString(args, i, len, builder);
                name = builder.toString();
                builder.setLength(0);
                int index = args.indexOf(61, i);
                if (index >= i) {
                    for (i = index + 1; i < len; ++i) {
                        ch = args.charAt(i);
                        if (Character.isWhitespace(ch)) continue;
                        if (ch >= '0' && ch <= '9') {
                            builder.append(ch);
                            continue;
                        }
                        if (ch == ',') {
                            values.put(name, Integer.parseInt(builder.toString()));
                            builder.setLength(0);
                            name = null;
                            continue block0;
                        }
                        if (ch == ')') {
                            values.put(name, Integer.parseInt(builder.toString()));
                            return i + 1;
                        }
                        throw new IllegalArgumentException("Invalid character when reading enum");
                    }
                    continue;
                }
                throw new IllegalArgumentException("Expect = after enum value but not found");
            }
            throw new IllegalArgumentException("Invalid enum declaration");
        }
        return len;
    }

    public static List<String> readValueArray(String args, int startIndex, int len) {
        LinkedList list = new LinkedList();
        ClickHouseUtils.readValueArray(args, startIndex, len, list::add);
        return list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public static int readValueArray(String args, int startIndex, int len, Consumer<String> func) {
        char closeBracket = ']';
        StringBuilder builder = new StringBuilder();
        for (int i = startIndex; i < len; ++i) {
            char ch = args.charAt(i);
            if (ch == '[') {
                startIndex = i + 1;
                break;
            }
            if (Character.isWhitespace(ch)) continue;
            if (i + 1 < len) {
                char nextCh = args.charAt(i + 1);
                if (ch == '-' && nextCh == '-') {
                    i = ClickHouseUtils.skipSingleLineComment(args, i + 2, len) - 1;
                    continue;
                }
                if (ch == '/' && nextCh == '*') {
                    i = ClickHouseUtils.skipMultiLineComment(args, i + 2, len) - 1;
                    continue;
                }
                startIndex = i;
                break;
            }
            startIndex = i;
            break;
        }
        boolean hasNext = false;
        for (int i = startIndex; i < len; ++i) {
            char ch = args.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '\'') {
                hasNext = false;
                int endIndex = ClickHouseUtils.readNameOrQuotedString(args, i, len, builder);
                func.accept(ClickHouseUtils.unescape(args.substring(i, endIndex)));
                builder.setLength(0);
                i = endIndex + 1;
                continue;
            }
            if (ch == '[') {
                hasNext = false;
                int endIndex = ClickHouseUtils.skipContentsUntil(args, i + 1, len, ']');
                func.accept(args.substring(i, endIndex));
                builder.setLength(0);
                i = endIndex;
                continue;
            }
            if (ch == '(') {
                hasNext = false;
                int endIndex = ClickHouseUtils.skipContentsUntil(args, i + 1, len, ')');
                func.accept(args.substring(i, endIndex));
                builder.setLength(0);
                i = endIndex;
                continue;
            }
            if (ch == closeBracket) {
                len = i + 1;
                break;
            }
            if (ch == ',') {
                hasNext = true;
                String str = builder.toString();
                func.accept(str.isEmpty() || "NULL".equalsIgnoreCase(str) ? null : str);
                builder.setLength(0);
                continue;
            }
            if (i + 1 < len) {
                char nextCh = args.charAt(i + 1);
                if (ch == '-' && nextCh == '-') {
                    i = ClickHouseUtils.skipSingleLineComment(args, i + 2, len) - 1;
                    continue;
                }
                if (ch == '/' && nextCh == '*') {
                    i = ClickHouseUtils.skipMultiLineComment(args, i + 2, len) - 1;
                    continue;
                }
                builder.append(ch);
                continue;
            }
            builder.append(ch);
        }
        if (hasNext || builder.length() > 0) {
            String str = builder.toString();
            func.accept(str.isEmpty() || "NULL".equalsIgnoreCase(str) ? null : str);
        }
        return len;
    }

    public static int readParameters(String args, int startIndex, int len, List<String> params) {
        char nextCh;
        char ch;
        int i;
        char closeBracket = ')';
        ArrayDeque<Character> stack = new ArrayDeque<Character>();
        StringBuilder builder = new StringBuilder();
        for (i = startIndex; i < len; ++i) {
            ch = args.charAt(i);
            if (ch == '(') {
                startIndex = i + 1;
                break;
            }
            if (Character.isWhitespace(ch)) continue;
            if (i + 1 < len) {
                nextCh = args.charAt(i + 1);
                if (ch == '-' && nextCh == '-') {
                    i = ClickHouseUtils.skipSingleLineComment(args, i + 2, len) - 1;
                    continue;
                }
                if (ch == '/' && nextCh == '*') {
                    i = ClickHouseUtils.skipMultiLineComment(args, i + 2, len) - 1;
                    continue;
                }
                startIndex = i;
                break;
            }
            startIndex = i;
            break;
        }
        block1: for (i = startIndex; i < len; ++i) {
            ch = args.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ClickHouseUtils.isQuote(ch)) {
                builder.append(ch);
                for (int j = i + 1; j < len; ++j) {
                    char c = args.charAt(j);
                    i = j;
                    builder.append(c);
                    if (c != ch || args.charAt(j - 1) == '\\') continue;
                    if (j + 1 >= len || args.charAt(j + 1) != ch) continue block1;
                    builder.append(ch);
                    i = ++j;
                }
                continue;
            }
            if (ClickHouseUtils.isOpenBracket(ch)) {
                builder.append(ch);
                stack.push(Character.valueOf(closeBracket));
                closeBracket = ClickHouseUtils.getCloseBracket(ch);
                continue;
            }
            if (ch == closeBracket) {
                if (stack.isEmpty()) {
                    len = i + 1;
                    break;
                }
                builder.append(ch);
                closeBracket = ((Character)stack.pop()).charValue();
                continue;
            }
            if (ch == ',') {
                if (!stack.isEmpty()) {
                    builder.append(ch);
                    continue;
                }
                params.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (i + 1 < len) {
                nextCh = args.charAt(i + 1);
                if (ch == '-' && nextCh == '-') {
                    i = ClickHouseUtils.skipSingleLineComment(args, i + 2, len) - 1;
                    continue;
                }
                if (ch == '/' && nextCh == '*') {
                    i = ClickHouseUtils.skipMultiLineComment(args, i + 2, len) - 1;
                    continue;
                }
                builder.append(ch);
                continue;
            }
            builder.append(ch);
        }
        if (builder.length() > 0) {
            params.add(builder.toString());
        }
        return len;
    }

    public static boolean waitFor(AtomicBoolean flag, long timeout, TimeUnit unit) throws InterruptedException {
        long startTime;
        if (flag == null || unit == null) {
            throw new IllegalArgumentException("Non-null flag and time unit required");
        }
        long timeoutMs = timeout > 0L ? unit.toMillis(timeout) : 0L;
        long l = startTime = timeoutMs < 1L ? 0L : System.currentTimeMillis();
        while (!flag.get()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (startTime <= 0L || System.currentTimeMillis() - startTime < timeoutMs) continue;
            return false;
        }
        return true;
    }

    private ClickHouseUtils() {
    }

    static {
        String osName = System.getProperty("os.name", "");
        IS_UNIX = osName.startsWith("AIX") || osName.startsWith("HP-UX") || osName.startsWith("OS/400") || osName.startsWith("Irix") || osName.startsWith("Linux") || osName.startsWith("LINUX") || osName.startsWith("Mac OS X") || osName.startsWith("Solaris") || osName.startsWith("SunOS") || osName.startsWith("FreeBSD") || osName.startsWith("OpenBSD") || osName.startsWith("NetBSD");
        IS_WINDOWS = osName.toLowerCase(Locale.ROOT).contains("windows");
        HOME_DIR = IS_WINDOWS ? Paths.get(System.getenv("APPDATA"), "clickhouse").toFile().getAbsolutePath() : Paths.get(System.getProperty("user.home"), ".clickhouse").toFile().getAbsolutePath();
        DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
        NULL_FUTURE = CompletableFuture.completedFuture(null);
        NULL_SUPPLIER = () -> null;
    }
}

