/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseVersion;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class ClickHouseNode
implements Function<ClickHouseNodeSelector, ClickHouseNode>,
Serializable {
    private static final long serialVersionUID = 8342604784121795372L;
    private final String cluster;
    private final ClickHouseProtocol protocol;
    private final InetSocketAddress address;
    private final ClickHouseCredentials credentials;
    private final String database;
    private final Set<String> tags;
    private final int weight;
    private final TimeZone tz;
    private final ClickHouseVersion version;
    private transient BiConsumer<ClickHouseNode, Status> manager;

    public static Builder builder() {
        return ClickHouseNode.builder(null);
    }

    public static Builder builder(ClickHouseNode base) {
        Builder b = new Builder();
        if (base != null) {
            b.cluster(base.getCluster()).host(base.getHost()).port(base.getProtocol(), base.getPort()).credentials(base.getCredentials().orElse(null)).database(base.getDatabase().orElse(null)).tags(base.getTags()).weight(base.getWeight()).timeZone((TimeZone)base.getTimeZone().orElse(null)).version((ClickHouseVersion)base.getVersion().orElse(null));
        }
        return b;
    }

    public static ClickHouseNode of(String host, ClickHouseProtocol protocol, int port, String database, String ... tags) {
        Builder builder = ClickHouseNode.builder().host(host).port(protocol, port).database(database);
        if (tags != null && tags.length > 0) {
            builder.tags(null, tags);
        }
        return builder.build();
    }

    protected ClickHouseNode(Builder builder) {
        ClickHouseChecker.nonNull(builder, "builder");
        this.cluster = builder.getCluster();
        this.protocol = builder.getProtocol();
        this.address = builder.getAddress();
        this.credentials = builder.getCredentials();
        this.database = builder.getDatabase();
        this.tags = builder.getTags();
        this.weight = builder.getWeight();
        this.tz = builder.getTimeZone();
        this.version = builder.getVersion();
        this.manager = null;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public Optional<ClickHouseCredentials> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }

    public ClickHouseCredentials getCredentials(ClickHouseConfig config) {
        return this.credentials != null ? this.credentials : ClickHouseChecker.nonNull(config, "config").getDefaultCredentials();
    }

    public String getHost() {
        return this.address.getHostString();
    }

    public int getPort() {
        return this.address.getPort();
    }

    public Optional<String> getDatabase() {
        return Optional.ofNullable(this.database);
    }

    public String getDatabase(ClickHouseConfig config) {
        return !ClickHouseChecker.nonNull(config, "config").hasOption(ClickHouseClientOption.DATABASE) && this.hasPreferredDatabase() ? this.database : config.getDatabase();
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public int getWeight() {
        return this.weight;
    }

    public Optional<TimeZone> getTimeZone() {
        return Optional.ofNullable(this.tz);
    }

    public TimeZone getTimeZone(ClickHouseConfig config) {
        return this.tz != null ? this.tz : ClickHouseChecker.nonNull(config, "config").getServerTimeZone();
    }

    public Optional<ClickHouseVersion> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public ClickHouseVersion getVersion(ClickHouseConfig config) {
        return this.version != null ? this.version : ClickHouseChecker.nonNull(config, "config").getServerVersion();
    }

    public String getCluster() {
        return this.cluster;
    }

    public ClickHouseProtocol getProtocol() {
        return this.protocol;
    }

    public boolean hasPreferredDatabase() {
        return this.database != null && !this.database.isEmpty();
    }

    public synchronized void setManager(BiConsumer<ClickHouseNode, Status> manager) {
        if (this.manager != null && !this.manager.equals(manager)) {
            this.manager.accept(this, Status.UNMANAGED);
        }
        if (manager != null && !manager.equals(this.manager)) {
            manager.accept(this, Status.MANAGED);
            this.manager = manager;
        }
    }

    public synchronized void updateStatus(Status status) {
        if (this.manager != null) {
            this.manager.accept(this, status);
        }
    }

    @Override
    public ClickHouseNode apply(ClickHouseNodeSelector t) {
        if (!(t == null || t == ClickHouseNodeSelector.EMPTY || t.matchAnyOfPreferredProtocols(this.protocol) && t.matchAllPreferredTags(this.tags))) {
            throw new IllegalArgumentException("No suitable node found");
        }
        return this;
    }

    public String toString() {
        boolean hasCluster;
        StringBuilder builder = new StringBuilder().append(this.getClass().getSimpleName()).append('(');
        boolean bl = hasCluster = this.cluster != null && !this.cluster.isEmpty();
        if (hasCluster) {
            builder.append("cluster=").append(this.cluster).append(", ");
        }
        builder.append("addr=").append(this.protocol.name().toLowerCase()).append(":").append(this.address).append(", db=").append(this.database);
        if (this.tz != null) {
            builder.append(", tz=").append(this.tz.getID());
        }
        if (this.version != null) {
            builder.append(", ver=").append(this.version);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            builder.append(", tags=").append(this.tags);
        }
        if (hasCluster) {
            builder.append(", weight=").append(this.weight);
        }
        return builder.append(')').append('@').append(this.hashCode()).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.cluster, this.credentials, this.database, this.protocol, this.tags, this.weight, this.tz, this.version});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ClickHouseNode node = (ClickHouseNode)obj;
        return this.address.equals(node.address) && this.cluster.equals(node.cluster) && Objects.equals(this.credentials, node.credentials) && Objects.equals(this.database, node.database) && this.protocol == node.protocol && this.tags.equals(node.tags) && this.weight == node.weight && Objects.equals(this.tz, node.tz) && Objects.equals(this.version, node.version);
    }

    public static class Builder {
        protected String cluster;
        protected String host;
        protected Integer port;
        protected InetSocketAddress address;
        protected ClickHouseProtocol protocol;
        protected ClickHouseCredentials credentials;
        protected String database;
        protected Set<String> tags = new HashSet<String>(3);
        protected Integer weight;
        protected TimeZone tz;
        protected ClickHouseVersion version;

        protected Builder() {
        }

        protected String getCluster() {
            if (this.cluster == null) {
                this.cluster = (String)((Object)ClickHouseDefaults.CLUSTER.getEffectiveDefaultValue());
            }
            return this.cluster;
        }

        protected InetSocketAddress getAddress() {
            if (this.host == null) {
                this.host = (String)((Object)ClickHouseDefaults.HOST.getEffectiveDefaultValue());
            }
            if (this.port == null) {
                this.port = (Integer)ClickHouseDefaults.PORT.getEffectiveDefaultValue();
            }
            if (this.address == null) {
                this.address = InetSocketAddress.createUnresolved(this.host, this.port);
            }
            return this.address;
        }

        protected ClickHouseProtocol getProtocol() {
            if (this.protocol == null) {
                this.protocol = (ClickHouseProtocol)((Object)ClickHouseDefaults.PROTOCOL.getEffectiveDefaultValue());
            }
            return this.protocol;
        }

        protected ClickHouseCredentials getCredentials() {
            return this.credentials;
        }

        protected String getDatabase() {
            return this.database;
        }

        protected Set<String> getTags() {
            int size;
            int n = size = this.tags == null ? 0 : this.tags.size();
            if (size == 0) {
                return Collections.emptySet();
            }
            HashSet<String> s = new HashSet<String>(size);
            s.addAll(this.tags);
            return Collections.unmodifiableSet(s);
        }

        protected int getWeight() {
            if (this.weight == null) {
                this.weight = (Integer)ClickHouseDefaults.WEIGHT.getEffectiveDefaultValue();
            }
            return this.weight;
        }

        protected TimeZone getTimeZone() {
            return this.tz;
        }

        protected ClickHouseVersion getVersion() {
            return this.version;
        }

        public Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder host(String host) {
            if (!Objects.equals(this.host, host)) {
                this.address = null;
            }
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            return this.port(null, port);
        }

        public Builder port(ClickHouseProtocol protocol) {
            return this.port(protocol, ClickHouseChecker.nonNull(protocol, "protocol").getDefaultPort());
        }

        public Builder port(ClickHouseProtocol protocol, Integer port) {
            if (!Objects.equals(this.port, port)) {
                this.address = null;
            }
            this.port = port;
            this.protocol = protocol;
            return this;
        }

        public Builder address(InetSocketAddress address) {
            return this.address(null, address);
        }

        public Builder address(ClickHouseProtocol protocol, InetSocketAddress address) {
            if (!Objects.equals(this.address, address)) {
                this.host = null;
                this.port = null;
            }
            this.address = address;
            this.protocol = protocol;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder credentials(ClickHouseCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder addTag(String tag) {
            if (tag != null) {
                this.tags.add(tag);
            }
            return this;
        }

        public Builder removeTag(String tag) {
            if (tag != null) {
                this.tags.remove(tag);
            }
            return this;
        }

        public Builder tags(String tag, String ... more) {
            this.tags.clear();
            this.addTag(tag);
            if (more != null) {
                for (String t : more) {
                    if (t == null) continue;
                    this.tags.add(t);
                }
            }
            return this;
        }

        public Builder tags(Collection<String> tags) {
            this.tags.clear();
            if (tags != null) {
                for (String t : tags) {
                    if (t == null) continue;
                    this.tags.add(t);
                }
            }
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public Builder timeZone(String tz) {
            this.tz = tz != null ? TimeZone.getTimeZone(tz) : null;
            return this;
        }

        public Builder timeZone(TimeZone tz) {
            this.tz = tz;
            return this;
        }

        public Builder version(String version) {
            this.version = version != null ? ClickHouseVersion.of(version) : null;
            return this;
        }

        public Builder version(ClickHouseVersion version) {
            this.version = version;
            return this;
        }

        public ClickHouseNode build() {
            return new ClickHouseNode(this);
        }
    }

    public static enum Status {
        HEALTHY,
        UNHEALTHY,
        MANAGED,
        UNMANAGED;

    }
}

