/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.AbstractClient;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.grpc.ClickHouseGrpcChannelFactory;
import com.clickhouse.client.grpc.ClickHouseGrpcResponse;
import com.clickhouse.client.grpc.ClickHouseStreamObserver;
import com.clickhouse.client.grpc.config.ClickHouseGrpcOption;
import com.clickhouse.client.grpc.impl.ClickHouseGrpc;
import com.clickhouse.client.grpc.impl.Compression;
import com.clickhouse.client.grpc.impl.CompressionAlgorithm;
import com.clickhouse.client.grpc.impl.CompressionLevel;
import com.clickhouse.client.grpc.impl.ExternalTable;
import com.clickhouse.client.grpc.impl.NameAndType;
import com.clickhouse.client.grpc.impl.QueryInfo;
import com.clickhouse.client.grpc.impl.Result;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;

public class ClickHouseGrpcClient
extends AbstractClient<ManagedChannel> {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseGrpcClient.class);
    private static final Compression COMPRESSION_DISABLED = Compression.newBuilder().setAlgorithm(CompressionAlgorithm.NO_COMPRESSION).setLevel(CompressionLevel.COMPRESSION_NONE).build();

    protected static String getRequestEncoding(ClickHouseConfig config) {
        if (config.isDecompressClientRequet()) {
            return ClickHouseCompression.NONE.encoding();
        }
        String encoding = ClickHouseCompression.GZIP.encoding();
        switch (config.getDecompressAlgorithmForClientRequest()) {
            case GZIP: {
                break;
            }
            default: {
                log.warn((Object)"Unsupported algorithm [%s], change to [%s]", new Object[]{config.getDecompressAlgorithmForClientRequest(), encoding});
            }
        }
        return encoding;
    }

    protected static Compression getResultCompression(ClickHouseConfig config) {
        if (!config.isCompressServerResponse()) {
            return COMPRESSION_DISABLED;
        }
        Compression.Builder builder = Compression.newBuilder();
        CompressionAlgorithm algorithm = CompressionAlgorithm.GZIP;
        CompressionLevel level = CompressionLevel.COMPRESSION_MEDIUM;
        switch (config.getDecompressAlgorithmForClientRequest()) {
            case NONE: {
                algorithm = CompressionAlgorithm.NO_COMPRESSION;
                break;
            }
            case DEFLATE: {
                algorithm = CompressionAlgorithm.DEFLATE;
                break;
            }
            case GZIP: {
                break;
            }
            default: {
                log.warn((Object)"Unsupported algorithm [%s], change to [%s]", new Object[]{config.getDecompressAlgorithmForClientRequest(), algorithm});
            }
        }
        int l = config.getDecompressLevelForClientRequest();
        level = l <= 0 ? CompressionLevel.COMPRESSION_NONE : (l < 3 ? CompressionLevel.COMPRESSION_LOW : (l < 7 ? CompressionLevel.COMPRESSION_MEDIUM : CompressionLevel.COMPRESSION_HIGH));
        return builder.setAlgorithm(algorithm).setLevel(level).build();
    }

    protected static QueryInfo convert(ClickHouseNode server, ClickHouseRequest<?> request) {
        String sql;
        List stmts;
        int size;
        List externalTables;
        ClickHouseConfig config = request.getConfig();
        ClickHouseCredentials credentials = server.getCredentials(config);
        QueryInfo.Builder builder = QueryInfo.newBuilder();
        builder.setDatabase(server.getDatabase(config)).setUserName(credentials.getUserName()).setPassword(credentials.getPassword()).setOutputFormat(request.getFormat().name());
        Optional optionalValue = request.getSessionId();
        if (optionalValue.isPresent()) {
            builder.setSessionId((String)optionalValue.get());
        }
        if (config.isSessionCheck()) {
            builder.setSessionCheck(true);
        }
        if (config.getSessionTimeout() > 0) {
            builder.setSessionTimeout(config.getSessionTimeout());
        }
        if ((optionalValue = request.getQueryId()).isPresent()) {
            builder.setQueryId((String)optionalValue.get());
        }
        builder.setResultCompression(ClickHouseGrpcClient.getResultCompression(config));
        for (Map.Entry s : request.getSettings().entrySet()) {
            builder.putSettings((String)s.getKey(), String.valueOf(s.getValue()));
        }
        Optional input = request.getInputStream();
        if (input.isPresent()) {
            try {
                builder.setInputData(ByteString.readFrom((InputStream)((InputStream)input.get())));
            }
            catch (IOException e) {
                throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
            }
        }
        if (!(externalTables = request.getExternalTables()).isEmpty()) {
            for (ClickHouseExternalTable external : externalTables) {
                ExternalTable.Builder b = ExternalTable.newBuilder().setName(external.getName());
                for (ClickHouseColumn c : ClickHouseColumn.parse((String)external.getStructure())) {
                    b.addColumns(NameAndType.newBuilder().setName(c.getColumnName()).setType(c.getOriginalTypeName()).build());
                }
                if (external.getFormat() != null) {
                    b.setFormat(external.getFormat().name());
                }
                try {
                    builder.addExternalTables(b.setData(ByteString.readFrom((InputStream)external.getContent())).build());
                }
                catch (IOException e) {
                    throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
                }
            }
        }
        if ((size = (stmts = request.getStatements(false)).size()) == 0) {
            throw new IllegalArgumentException("At least one SQL statement is required for execution");
        }
        if (size == 1) {
            sql = (String)stmts.get(0);
        } else {
            if (!builder.getSessionCheck()) {
                builder.setSessionCheck(true);
            }
            if (ClickHouseChecker.isNullOrEmpty((CharSequence)builder.getSessionId())) {
                builder.setSessionId(UUID.randomUUID().toString());
            }
            StringBuilder sb = new StringBuilder();
            for (String s : stmts) {
                sb.append(s).append(';').append('\n');
            }
            sql = sb.toString();
        }
        log.debug((Object)"Query: %s", new Object[]{sql});
        return builder.setQuery(sql).build();
    }

    protected void closeConnection(ManagedChannel connection, boolean force) {
        if (!force) {
            connection.shutdown();
        } else {
            connection.shutdownNow();
        }
    }

    protected ManagedChannel newConnection(ManagedChannel connection, ClickHouseNode server, ClickHouseRequest<?> request) {
        if (connection != null) {
            this.closeConnection(connection, false);
        }
        return ClickHouseGrpcChannelFactory.getFactory(request.getConfig(), server).create();
    }

    protected void fill(ClickHouseRequest<?> request, StreamObserver<QueryInfo> observer) {
        try {
            observer.onNext((Object)ClickHouseGrpcClient.convert(this.getServer(), request));
        }
        finally {
            observer.onCompleted();
        }
    }

    public boolean accept(ClickHouseProtocol protocol) {
        return ClickHouseProtocol.GRPC == protocol || super.accept(protocol);
    }

    protected CompletableFuture<ClickHouseResponse> executeAsync(ClickHouseRequest<?> sealedRequest, ManagedChannel channel, ClickHouseNode server) {
        ClickHouseGrpc.ClickHouseStub stub = ClickHouseGrpc.newStub((Channel)channel);
        stub.withCompression(ClickHouseGrpcClient.getRequestEncoding(sealedRequest.getConfig()));
        ClickHouseStreamObserver responseObserver = new ClickHouseStreamObserver(sealedRequest.getConfig(), server);
        StreamObserver<QueryInfo> requestObserver = stub.executeQueryWithStreamIO(responseObserver);
        if (sealedRequest.hasInputStream()) {
            this.getExecutor().execute(() -> this.fill(sealedRequest, requestObserver));
        } else {
            this.fill(sealedRequest, requestObserver);
        }
        return CompletableFuture.supplyAsync(() -> {
            ClickHouseConfig config = sealedRequest.getConfig();
            int timeout = config.getConnectionTimeout() / 1000 + Math.max(config.getSocketTimeout() / 1000, config.getMaxExecutionTime());
            try {
                if (!responseObserver.await(timeout, TimeUnit.SECONDS)) {
                    if (!Context.current().withCancellation().cancel((Throwable)new StatusException(Status.CANCELLED))) {
                        requestObserver.onError((Throwable)new StatusException(Status.CANCELLED));
                    }
                    throw new CompletionException(ClickHouseUtils.format((String)"Timed out after waiting for %d %s", (Object[])new Object[]{timeout, TimeUnit.SECONDS}), null);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
            }
            try {
                ClickHouseGrpcResponse response = new ClickHouseGrpcResponse(sealedRequest.getConfig(), (Map<String, Object>)sealedRequest.getSettings(), responseObserver);
                Throwable cause = responseObserver.getError();
                if (cause != null) {
                    throw new CompletionException((Throwable)ClickHouseException.of((Throwable)cause, (ClickHouseNode)server));
                }
                return response;
            }
            catch (IOException e) {
                throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
            }
        }, this.getExecutor());
    }

    protected CompletableFuture<ClickHouseResponse> executeSync(ClickHouseRequest<?> sealedRequest, ManagedChannel channel, ClickHouseNode server) {
        ClickHouseGrpc.ClickHouseBlockingStub stub = ClickHouseGrpc.newBlockingStub((Channel)channel);
        stub.withCompression(ClickHouseGrpcClient.getRequestEncoding(sealedRequest.getConfig()));
        try {
            Result result = stub.executeQuery(ClickHouseGrpcClient.convert(server, sealedRequest));
            ClickHouseGrpcResponse response = new ClickHouseGrpcResponse(sealedRequest.getConfig(), (Map<String, Object>)sealedRequest.getSettings(), result);
            return result.hasException() ? this.failedResponse((Throwable)new ClickHouseException(result.getException().getCode(), result.getException().getDisplayText(), server)) : CompletableFuture.completedFuture(response);
        }
        catch (IOException e) {
            throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
        }
    }

    public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> request) {
        ClickHouseRequest sealedRequest = request.seal();
        ManagedChannel c = (ManagedChannel)this.getConnection(sealedRequest);
        ClickHouseNode s = this.getServer();
        return sealedRequest.getConfig().isAsync() ? this.executeAsync(sealedRequest, c, s) : this.executeSync(sealedRequest, c, s);
    }

    public Class<? extends ClickHouseOption> getOptionClass() {
        return ClickHouseGrpcOption.class;
    }
}

