/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.data.ClickHouseStreamResponse;
import com.clickhouse.client.grpc.ClickHouseStreamObserver;
import com.clickhouse.client.grpc.impl.Progress;
import com.clickhouse.client.grpc.impl.Result;
import com.clickhouse.client.grpc.impl.Stats;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ClickHouseGrpcResponse
extends ClickHouseStreamResponse {
    private final ClickHouseStreamObserver observer;
    private final Result result;

    protected ClickHouseGrpcResponse(ClickHouseConfig config, Map<String, Object> settings, ClickHouseStreamObserver observer) throws IOException {
        super(config, ClickHouseInputStream.of((InputStream)observer.getInputStream()), settings, null, observer.getSummary());
        this.observer = observer;
        this.result = null;
    }

    protected ClickHouseGrpcResponse(ClickHouseConfig config, Map<String, Object> settings, Result result) throws IOException {
        super(config, ClickHouseInputStream.of((InputStream)result.getOutput().newInput()), settings, null, new ClickHouseResponseSummary(null, null));
        this.observer = null;
        this.result = result;
        if (result.hasProgress()) {
            Progress p = result.getProgress();
            this.summary.update(new ClickHouseResponseSummary.Progress(p.getReadRows(), p.getReadBytes(), p.getTotalRowsToRead(), p.getWrittenRows(), p.getWrittenBytes()));
        }
        if (result.hasStats()) {
            Stats s = result.getStats();
            this.summary.update(new ClickHouseResponseSummary.Statistics(s.getRows(), s.getBlocks(), s.getAllocatedBytes(), s.getAppliedLimit(), s.getRowsBeforeLimit()));
        }
    }

    public ClickHouseResponseSummary getSummary() {
        return this.summary;
    }
}

