/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataStreamFactory;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.data.ClickHousePipedStream;
import com.clickhouse.client.grpc.ClickHouseGrpcResponse;
import com.clickhouse.client.grpc.impl.Exception;
import com.clickhouse.client.grpc.impl.LogEntry;
import com.clickhouse.client.grpc.impl.Progress;
import com.clickhouse.client.grpc.impl.Result;
import com.clickhouse.client.grpc.impl.Stats;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ClickHouseStreamObserver
implements StreamObserver<Result> {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseStreamObserver.class);
    private final ClickHouseNode server;
    private final CountDownLatch startLatch;
    private final CountDownLatch finishLatch;
    private final ClickHousePipedStream stream;
    private final ClickHouseInputStream input;
    private final ClickHouseResponseSummary summary;
    private Throwable error;

    protected ClickHouseStreamObserver(ClickHouseConfig config, ClickHouseNode server) {
        this.server = server;
        this.startLatch = new CountDownLatch(1);
        this.finishLatch = new CountDownLatch(1);
        this.stream = ClickHouseDataStreamFactory.getInstance().createPipedStream(config);
        this.input = ClickHouseGrpcResponse.getInput(config, (InputStream)this.stream.getInput());
        this.summary = new ClickHouseResponseSummary(null, null);
        this.error = null;
    }

    protected void checkClosed() {
        if (this.finishLatch.getCount() == 0L) {
            throw new IllegalStateException("closed observer");
        }
    }

    protected void setError(Throwable error) {
        if (this.error == null) {
            this.error = error;
        }
    }

    protected boolean updateStatus(Result result) {
        this.summary.update();
        log.debug(() -> {
            for (LogEntry e : result.getLogsList()) {
                String logLevel = e.getLevel().name();
                int index = logLevel.indexOf(95);
                if (index > 0) {
                    logLevel = logLevel.substring(index + 1);
                }
                log.info((Object)"%s.%s [ %s ] {%s} <%s> %s: %s", new Object[]{e.getTime(), e.getTimeMicroseconds(), e.getThreadId(), e.getQueryId(), logLevel, e.getSource(), e.getText()});
            }
            return ClickHouseUtils.format((String)"Logged %d entries from server", (Object[])new Object[]{result.getLogsList().size()});
        });
        boolean proceed = true;
        if (result.hasStats()) {
            Stats s = result.getStats();
            this.summary.update(new ClickHouseResponseSummary.Statistics(s.getRows(), s.getBlocks(), s.getAllocatedBytes(), s.getAppliedLimit(), s.getRowsBeforeLimit()));
        }
        if (result.hasProgress()) {
            Progress p = result.getProgress();
            this.summary.update(new ClickHouseResponseSummary.Progress(p.getReadRows(), p.getReadBytes(), p.getTotalRowsToRead(), p.getWrittenRows(), p.getWrittenBytes()));
        }
        if (result.getCancelled()) {
            proceed = false;
            this.onError((Throwable)new StatusException(Status.CANCELLED));
        } else if (result.hasException()) {
            proceed = false;
            Exception e = result.getException();
            log.error((Object)"Server error: Code=%s, %s", new Object[]{e.getCode(), e.getDisplayText()});
            log.error((Object)e.getStackTrace(), new Object[0]);
            if (this.error == null) {
                this.error = new ClickHouseException(result.getException().getCode(), result.getException().getDisplayText(), this.server);
            }
        }
        return proceed;
    }

    public boolean isCompleted() {
        return this.finishLatch.getCount() == 0L;
    }

    public boolean isCancelled() {
        return this.isCompleted() && this.error != null;
    }

    public ClickHouseResponseSummary getSummary() {
        return this.summary;
    }

    public Throwable getError() {
        return this.error;
    }

    public void onNext(Result value) {
        try {
            this.checkClosed();
            log.trace((Object)"Got result: %s", new Object[]{value});
            if (this.updateStatus(value)) {
                try {
                    value.getOutput().writeTo((OutputStream)this.stream);
                }
                catch (IOException e) {
                    this.onError(e);
                }
            }
        }
        finally {
            this.startLatch.countDown();
        }
    }

    public void onError(Throwable t) {
        try {
            log.error((Object)"Query failed", t);
            this.setError(t);
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.checkClosed();
        }
        finally {
            this.startLatch.countDown();
            this.finishLatch.countDown();
        }
    }

    public void onCompleted() {
        log.trace((Object)"Query finished", new Object[0]);
        try {
            this.stream.flush();
        }
        catch (IOException e) {
            if (this.error == null) {
                this.error = e;
            }
            log.error((Object)"Failed to flush output", (Throwable)e);
        }
        finally {
            this.startLatch.countDown();
            this.finishLatch.countDown();
            try {
                this.stream.close();
            }
            catch (IOException e) {
                log.warn((Object)"Failed to close output stream", (Throwable)e);
            }
        }
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.startLatch.await(timeout, unit);
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return this.finishLatch.await(timeout, unit);
    }

    public ClickHouseInputStream getInputStream() {
        return this.input;
    }
}

