/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataProcessor;
import com.clickhouse.client.ClickHouseDataStreamFactory;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ClickHouseStreamResponse
implements ClickHouseResponse {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseStreamResponse.class);
    private static final long serialVersionUID = 2271296998310082447L;
    protected static final List<ClickHouseColumn> defaultTypes = Collections.singletonList(ClickHouseColumn.of("results", "Nullable(String)"));
    protected final ClickHouseConfig config;
    protected final transient ClickHouseInputStream input;
    protected final transient ClickHouseDataProcessor processor;
    protected final List<ClickHouseColumn> columns;
    protected final ClickHouseResponseSummary summary;
    private boolean closed;

    public static ClickHouseResponse of(ClickHouseConfig config, ClickHouseInputStream input) throws IOException {
        return ClickHouseStreamResponse.of(config, input, null, null, null);
    }

    public static ClickHouseResponse of(ClickHouseConfig config, ClickHouseInputStream input, Map<String, Object> settings) throws IOException {
        return ClickHouseStreamResponse.of(config, input, settings, null, null);
    }

    public static ClickHouseResponse of(ClickHouseConfig config, ClickHouseInputStream input, List<ClickHouseColumn> columns) throws IOException {
        return ClickHouseStreamResponse.of(config, input, null, columns, null);
    }

    public static ClickHouseResponse of(ClickHouseConfig config, ClickHouseInputStream input, Map<String, Object> settings, List<ClickHouseColumn> columns) throws IOException {
        return ClickHouseStreamResponse.of(config, input, settings, columns, null);
    }

    public static ClickHouseResponse of(ClickHouseConfig config, ClickHouseInputStream input, Map<String, Object> settings, List<ClickHouseColumn> columns, ClickHouseResponseSummary summary) throws IOException {
        return new ClickHouseStreamResponse(config, input, settings, columns, summary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClickHouseStreamResponse(ClickHouseConfig config, ClickHouseInputStream input, Map<String, Object> settings, List<ClickHouseColumn> columns, ClickHouseResponseSummary summary) throws IOException {
        if (config == null || input == null) {
            throw new IllegalArgumentException("Non-null configuration and input stream are required");
        }
        this.config = config;
        this.input = input;
        boolean hasError = true;
        try {
            this.processor = ClickHouseDataStreamFactory.getInstance().getProcessor(config, input, null, settings, columns);
            this.columns = columns != null ? columns : (this.processor != null ? this.processor.getColumns() : Collections.emptyList());
            hasError = false;
        }
        finally {
            if (hasError) {
                log.error((Object)"Failed to create stream response, closing input stream", new Object[0]);
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
        this.summary = summary != null ? summary : ClickHouseResponseSummary.EMPTY;
        this.closed = hasError;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.closed || this.input.isClosed()) {
            return;
        }
        try {
            log.debug((Object)"%d bytes skipped before closing input stream", this.input.skip(Long.MAX_VALUE));
        }
        catch (Exception e) {
            log.debug((Object)"Failed to skip reading input stream due to: %s", e.getMessage());
        }
        finally {
            try {
                this.input.close();
            }
            catch (Exception e) {
                log.warn((Object)"Failed to close input stream", e);
            }
            this.closed = true;
        }
    }

    @Override
    public List<ClickHouseColumn> getColumns() {
        return this.columns;
    }

    public ClickHouseFormat getFormat() {
        return this.config.getFormat();
    }

    @Override
    public ClickHouseResponseSummary getSummary() {
        return this.summary;
    }

    @Override
    public ClickHouseInputStream getInputStream() {
        return this.input;
    }

    @Override
    public Iterable<ClickHouseRecord> records() {
        if (this.processor == null) {
            throw new UnsupportedOperationException("No data processor available for deserialization, please consider to use getInputStream instead");
        }
        return this.processor.records();
    }
}

