/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.grpc.NettyChannelFactoryImpl;
import com.clickhouse.client.grpc.OkHttpChannelFactoryImpl;
import com.clickhouse.client.grpc.config.ClickHouseGrpcOption;
import com.clickhouse.client.grpc.impl.ClickHouseGrpc;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ProxiedSocketAddress;
import io.grpc.ProxyDetector;
import io.grpc.Status;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ClickHouseGrpcChannelFactory {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseGrpcChannelFactory.class);
    private static final String PROP_NAME = "name";
    private static final String PROP_SERVICE = "service";
    private static final String PROP_METHOD = "method";
    private static final String PROP_METHOD_CONFIG = "methodConfig";
    private static final String PROP_RETRY_POLICY = "retryPolicy";
    private static final String PROP_MAX_ATTEMPTS = "maxAttempts";
    private static final String serviceName = "clickhouse.grpc.ClickHouse";
    private static final String methodName = ClickHouseGrpc.getExecuteQueryWithStreamIOMethod().getBareMethodName();
    private static final Map<String, ?> defaultServiceConfig;
    protected final ClickHouseConfig config;
    protected final ClickHouseNode server;

    public static ClickHouseGrpcChannelFactory getFactory(ClickHouseConfig config, ClickHouseNode server) {
        if (!config.hasOption((ClickHouseOption)ClickHouseGrpcOption.USE_OKHTTP)) {
            ClickHouseGrpcChannelFactory factory = null;
            try {
                factory = new NettyChannelFactoryImpl(config, server);
            }
            catch (NoClassDefFoundError e) {
                factory = new OkHttpChannelFactoryImpl(config, server);
            }
            return factory;
        }
        return config.getBoolOption((ClickHouseOption)ClickHouseGrpcOption.USE_OKHTTP) ? new OkHttpChannelFactoryImpl(config, server) : new NettyChannelFactoryImpl(config, server);
    }

    protected ClickHouseGrpcChannelFactory(ClickHouseConfig config, ClickHouseNode server) {
        this.config = (ClickHouseConfig)ClickHouseChecker.nonNull((Object)config, (String)"Config");
        this.server = (ClickHouseNode)ClickHouseChecker.nonNull((Object)server, (String)"server");
    }

    protected Map<String, ?> getDefaultServiceConfig() {
        Map config = defaultServiceConfig;
        try {
            config = (Map)new Gson().fromJson(new JsonReader((Reader)new InputStreamReader(ClickHouseUtils.getFileInputStream((String)"grpc-config.json"), StandardCharsets.UTF_8)), Map.class);
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"Use default service config due to: %s", new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            log.debug((Object)"Failed to load service config", (Throwable)e);
        }
        return config;
    }

    protected abstract ManagedChannelBuilder<?> getChannelBuilder();

    protected abstract String getDefaultUserAgent();

    protected void setupRetry() {
        ManagedChannelBuilder<?> builder = this.getChannelBuilder();
        if (this.config.getRetry() > 0) {
            Map<String, ?> serviceConfig = this.getDefaultServiceConfig();
            int maxAttempts = -1;
            Object value = serviceConfig.get(PROP_METHOD_CONFIG);
            if (value instanceof List) {
                for (Object o : (List)value) {
                    Map m;
                    if (!(o instanceof Map)) continue;
                    Map methodConfig = (Map)o;
                    value = methodConfig.get(PROP_NAME);
                    boolean matched = value instanceof List;
                    if (matched) {
                        matched = false;
                        for (Object n : (List)value) {
                            Map m2;
                            Object v;
                            if (!(n instanceof Map) || (v = (m2 = (Map)n).get(PROP_SERVICE)) != null && !serviceName.equals(v) || (v = m2.get(PROP_METHOD)) != null && !methodName.equals(v)) continue;
                            matched = true;
                            break;
                        }
                    }
                    if (!matched || !((value = methodConfig.get(PROP_RETRY_POLICY)) instanceof Map) || !((value = (m = (Map)value).get(PROP_MAX_ATTEMPTS)) instanceof Number)) continue;
                    maxAttempts = ((Number)value).intValue();
                }
            }
            builder.defaultServiceConfig(serviceConfig).enableRetry();
            if (maxAttempts > 0) {
                builder.maxRetryAttempts(maxAttempts);
            }
        } else {
            builder.disableRetry();
        }
    }

    protected abstract void setupSsl();

    protected abstract void setupTimeout();

    protected void setupMisc() {
        ManagedChannelBuilder<?> builder = this.getChannelBuilder();
        if (this.config.getBoolOption((ClickHouseOption)ClickHouseGrpcOption.USE_FULL_STREAM_DECOMPRESSION)) {
            builder.enableFullStreamDecompression();
        }
        if (this.config.isUseNoProxy()) {
            builder.proxyDetector((ProxyDetector)NoProxyDetector.INSTANCE);
        }
        builder.maxInboundMessageSize(this.config.getIntOption((ClickHouseOption)ClickHouseGrpcOption.MAX_INBOUND_MESSAGE_SIZE)).maxInboundMetadataSize(this.config.getIntOption((ClickHouseOption)ClickHouseGrpcOption.MAX_INBOUND_METADATA_SIZE));
    }

    public ManagedChannel create() {
        log.debug((Object)"Establishing channel to [%s]", new Object[]{this.server});
        this.setupRetry();
        this.setupSsl();
        this.setupMisc();
        ManagedChannelBuilder<?> builder = this.getChannelBuilder();
        String userAgent = this.config.getClientName();
        if (ClickHouseClientOption.CLIENT_NAME.getDefaultValue().equals(userAgent)) {
            userAgent = this.getDefaultUserAgent();
            String name = this.config.getProductName();
            if (!ClickHouseClientOption.PRODUCT_NAME.getDefaultValue().equals(name)) {
                userAgent = name + userAgent.substring(userAgent.indexOf(47));
            }
        }
        ManagedChannel c = builder.userAgent(userAgent).build();
        log.debug((Object)"Channel established: %s", new Object[]{c});
        return c;
    }

    static {
        HashMap<String, String> name = new HashMap<String, String>();
        name.put(PROP_SERVICE, serviceName);
        name.put(PROP_METHOD, methodName);
        HashMap<String, Object> retryPolicy = new HashMap<String, Object>();
        retryPolicy.put(PROP_MAX_ATTEMPTS, 5.0);
        retryPolicy.put("initialBackoff", "0.5s");
        retryPolicy.put("maxBackoff", "30s");
        retryPolicy.put("backoffMultiplier", 2.0);
        retryPolicy.put("retryableStatusCodes", Collections.singletonList(Status.UNAVAILABLE.getCode().name()));
        HashMap<String, Object> methodConfig = new HashMap<String, Object>();
        methodConfig.put(PROP_NAME, Collections.singletonList(name));
        methodConfig.put(PROP_RETRY_POLICY, retryPolicy);
        HashMap config = new HashMap();
        config.put(PROP_METHOD_CONFIG, Collections.singletonList(methodConfig));
        defaultServiceConfig = Collections.unmodifiableMap(config);
    }

    static class NoProxyDetector
    implements ProxyDetector {
        static final NoProxyDetector INSTANCE = new NoProxyDetector();

        private NoProxyDetector() {
        }

        public ProxiedSocketAddress proxyFor(SocketAddress arg0) throws IOException {
            return null;
        }
    }
}

