/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.client.stream.AbstractByteBufferInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingInputStream
extends AbstractByteBufferInputStream {
    private static final Logger log = LoggerFactory.getLogger(BlockingInputStream.class);
    private final BlockingQueue<ByteBuffer> queue;
    private final int timeout;

    public BlockingInputStream(BlockingQueue<ByteBuffer> queue, int timeout, Runnable postCloseAction) {
        super(postCloseAction);
        this.queue = ClickHouseChecker.nonNull(queue, "Queue");
        this.timeout = timeout > 0 ? timeout : 0;
    }

    @Override
    protected void ensureOpen() throws IOException {
        if (this.closed) {
            log.debug((Object)"Blocking input stream(queue: %d, buffer: %d) has been closed", this.queue.size(), this.buffer != null ? this.buffer.remaining() : 0);
        }
        super.ensureOpen();
    }

    @Override
    protected int updateBuffer() throws IOException {
        try {
            if (this.timeout > 0) {
                this.buffer = this.queue.poll(this.timeout, TimeUnit.MILLISECONDS);
                if (this.buffer == null) {
                    throw new IOException(ClickHouseUtils.format("Read timed out after %d ms", this.timeout));
                }
            } else {
                this.buffer = this.queue.take();
            }
            return this.buffer.remaining();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when getting next buffer from queue", e);
        }
    }
}

