/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.data.BinaryStreamUtils;
import com.clickhouse.client.data.ClickHouseCityHash;
import com.clickhouse.client.internal.jpountz.lz4.LZ4Factory;
import com.clickhouse.client.internal.jpountz.lz4.LZ4FastDecompressor;
import com.clickhouse.client.stream.AbstractByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Lz4InputStream
extends AbstractByteArrayInputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    static final byte MAGIC = -126;
    static final int HEADER_LENGTH = 25;
    private final LZ4FastDecompressor decompressor = factory.fastDecompressor();
    private final InputStream stream;
    private final byte[] header;

    private boolean readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.stream.read(b, off + n, len - n);
            if (count >= 0) continue;
            if (n == 0) {
                return false;
            }
            throw new IOException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", n, len));
        }
        return true;
    }

    @Override
    protected int updateBuffer() throws IOException {
        this.position = 0;
        if (!this.readFully(this.header, 0, 25)) {
            this.buffer = ClickHouseByteBuffer.EMPTY_BYTES;
            this.limit = 0;
            return 0;
        }
        if (this.header[16] != -126) {
            throw new IOException(ClickHouseUtils.format("Magic is not correct - expect [%d] but got [%d]", (byte)-126, this.header[16]));
        }
        int compressedSizeWithHeader = BinaryStreamUtils.toInt32(this.header, 17);
        int uncompressedSize = BinaryStreamUtils.toInt32(this.header, 21);
        int offset = 9;
        byte[] block = new byte[compressedSizeWithHeader];
        block[0] = this.header[16];
        BinaryStreamUtils.setInt32(block, 1, compressedSizeWithHeader);
        BinaryStreamUtils.setInt32(block, 5, uncompressedSize);
        if (!this.readFully(block, offset, compressedSizeWithHeader - offset)) {
            throw new IOException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", 0, compressedSizeWithHeader - offset));
        }
        long[] real = ClickHouseCityHash.cityHash128(block, 0, block.length);
        if (real[0] != BinaryStreamUtils.toInt64(this.header, 0) || real[1] != BinaryStreamUtils.toInt64(this.header, 8)) {
            throw new IOException("Checksum doesn't match: corrupted data.");
        }
        this.buffer = new byte[uncompressedSize];
        this.decompressor.decompress(block, offset, this.buffer, 0, uncompressedSize);
        this.limit = this.buffer.length;
        return this.limit;
    }

    public Lz4InputStream(InputStream stream) {
        this(stream, null);
    }

    public Lz4InputStream(InputStream stream, Runnable postCloseAction) {
        super(postCloseAction);
        this.stream = ClickHouseChecker.nonNull(stream, "InputStream");
        this.header = new byte[25];
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.stream.close();
            }
            finally {
                super.close();
            }
        }
    }
}

