/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseFile;
import com.clickhouse.client.data.BinaryStreamUtils;
import com.clickhouse.client.data.ClickHouseCityHash;
import com.clickhouse.client.stream.AbstractByteArrayOutputStream;
import com.clickhouse.jdbc.internal.jpountz.lz4.LZ4Compressor;
import com.clickhouse.jdbc.internal.jpountz.lz4.LZ4Factory;
import java.io.IOException;
import java.io.OutputStream;

public class Lz4OutputStream
extends AbstractByteArrayOutputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    private final OutputStream output;
    private final LZ4Compressor compressor;
    private final byte[] compressedBlock;

    @Override
    protected void flushBuffer() throws IOException {
        byte[] block = this.compressedBlock;
        block[16] = -126;
        int compressed = this.compressor.compress(this.buffer, 0, this.position, block, 25);
        int compressedSizeWithHeader = compressed + 9;
        BinaryStreamUtils.setInt32(block, 17, compressedSizeWithHeader);
        BinaryStreamUtils.setInt32(block, 21, this.position);
        long[] hash = ClickHouseCityHash.cityHash128(block, 16, compressedSizeWithHeader);
        BinaryStreamUtils.setInt64(block, 0, hash[0]);
        BinaryStreamUtils.setInt64(block, 8, hash[1]);
        this.output.write(block, 0, compressed + 25);
        this.position = 0;
    }

    @Override
    protected void flushBuffer(byte[] bytes, int offset, int length) throws IOException {
        int maxLen = this.compressor.maxCompressedLength(length) + 15;
        byte[] block = maxLen <= this.compressedBlock.length ? this.compressedBlock : new byte[maxLen];
        block[16] = -126;
        int compressed = this.compressor.compress(bytes, offset, length, block, 25);
        int compressedSizeWithHeader = compressed + 9;
        BinaryStreamUtils.setInt32(block, 17, compressedSizeWithHeader);
        BinaryStreamUtils.setInt32(block, 21, length);
        long[] hash = ClickHouseCityHash.cityHash128(block, 16, compressedSizeWithHeader);
        BinaryStreamUtils.setInt64(block, 0, hash[0]);
        BinaryStreamUtils.setInt64(block, 8, hash[1]);
        this.output.write(block, 0, compressed + 25);
    }

    public Lz4OutputStream(OutputStream stream, int maxCompressBlockSize, Runnable postCloseAction) {
        this(null, stream, maxCompressBlockSize, postCloseAction);
    }

    public Lz4OutputStream(ClickHouseFile file, OutputStream stream, int maxCompressBlockSize, Runnable postCloseAction) {
        super(file, maxCompressBlockSize, postCloseAction);
        this.output = ClickHouseChecker.nonNull(stream, "OutputStream");
        this.compressor = factory.fastCompressor();
        this.compressedBlock = new byte[this.compressor.maxCompressedLength(maxCompressBlockSize) + 15];
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.position > 0) {
            this.flushBuffer();
        }
        this.output.flush();
    }
}

