/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal.apache.http.protocol;

import com.clickhouse.jdbc.internal.apache.http.HttpException;
import com.clickhouse.jdbc.internal.apache.http.HttpRequest;
import com.clickhouse.jdbc.internal.apache.http.HttpRequestInterceptor;
import com.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import com.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import com.clickhouse.jdbc.internal.apache.http.protocol.HttpContext;
import com.clickhouse.jdbc.internal.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

