/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal.apache.http.protocol;

import com.clickhouse.jdbc.internal.apache.http.HttpEntityEnclosingRequest;
import com.clickhouse.jdbc.internal.apache.http.HttpException;
import com.clickhouse.jdbc.internal.apache.http.HttpRequest;
import com.clickhouse.jdbc.internal.apache.http.HttpRequestInterceptor;
import com.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import com.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import com.clickhouse.jdbc.internal.apache.http.protocol.HttpContext;
import com.clickhouse.jdbc.internal.apache.http.protocol.HttpDateGenerator;
import com.clickhouse.jdbc.internal.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

