/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class ClickHouseGeoPointValue
extends ClickHouseObjectValue<double[]> {
    public static ClickHouseGeoPointValue ofOrigin() {
        return ClickHouseGeoPointValue.of(null, new double[]{0.0, 0.0});
    }

    public static ClickHouseGeoPointValue of(double[] value) {
        return ClickHouseGeoPointValue.of(null, value);
    }

    public static ClickHouseGeoPointValue of(ClickHouseValue ref, double[] value) {
        return ref instanceof ClickHouseGeoPointValue ? ((ClickHouseGeoPointValue)ref).set(value) : new ClickHouseGeoPointValue(value);
    }

    protected static double[] check(double[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("Non-null X and Y coordinates are required");
        }
        return value;
    }

    protected static String convert(double[] value, int length) {
        String str = "" + '(' + value[0] + ',' + value[1] + ')';
        return length > 0 ? ClickHouseChecker.notWithDifferentLength(str, length) : str;
    }

    protected ClickHouseGeoPointValue(double[] value) {
        super(value);
    }

    protected ClickHouseGeoPointValue set(double[] value) {
        super.set(ClickHouseGeoPointValue.check(value));
        return this;
    }

    @Override
    public ClickHouseGeoPointValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseGeoPointValue((double[])this.getValue());
        }
        double[] value = (double[])this.getValue();
        double[] newValue = new double[value.length];
        System.arraycopy(value, 0, newValue, 0, value.length);
        return new ClickHouseGeoPointValue(newValue);
    }

    @Override
    public String asString(int length, Charset charset) {
        return ClickHouseGeoPointValue.convert((double[])this.getValue(), length);
    }

    @Override
    public boolean isNullOrEmpty() {
        return false;
    }

    @Override
    public ClickHouseGeoPointValue resetToNullOrEmpty() {
        this.set(new double[]{0.0, 0.0});
        return this;
    }

    @Override
    public String toSqlExpression() {
        return ClickHouseGeoPointValue.convert((double[])this.getValue(), 0);
    }

    @Override
    public ClickHouseGeoPointValue update(boolean value) {
        throw this.newUnsupportedException("boolean", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(boolean[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[]{value[0] ? 1.0 : 0.0, value[1] ? 0.0 : 1.0});
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(char value) {
        throw this.newUnsupportedException("char", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(char[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[]{value[0], value[1]});
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(byte value) {
        throw this.newUnsupportedException("byte", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(byte[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[]{value[0], value[1]});
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(short value) {
        throw this.newUnsupportedException("short", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(short[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[]{value[0], value[1]});
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(int value) {
        throw this.newUnsupportedException("int", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(int[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[]{value[0], value[1]});
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(long value) {
        throw this.newUnsupportedException("long", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(long[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[]{value[0], value[1]});
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(float value) {
        throw this.newUnsupportedException("float", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(float[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[]{value[0], value[1]});
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(double value) {
        throw this.newUnsupportedException("double", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(double[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(BigInteger value) {
        throw this.newUnsupportedException("BigInteger", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(BigDecimal value) {
        throw this.newUnsupportedException("BigDecimal", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(Enum<?> value) {
        throw this.newUnsupportedException("Enum", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(Inet4Address value) {
        throw this.newUnsupportedException("Inet4Address", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(Inet6Address value) {
        throw this.newUnsupportedException("Inet6Address", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(LocalDate value) {
        throw this.newUnsupportedException("Date", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(LocalTime value) {
        throw this.newUnsupportedException("Time", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(LocalDateTime value) {
        throw this.newUnsupportedException("DateTime", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(Collection<?> value) {
        if (value == null || value.size() != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Iterator<?> i = value.iterator();
        Object v1 = i.next();
        Object v2 = i.next();
        if (v1 instanceof Number) {
            this.set(new double[]{((Number)v1).doubleValue(), ((Number)v2).doubleValue()});
        } else {
            this.set(new double[]{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())});
        }
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(Enumeration<?> value) {
        if (value == null || !value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v1 = value.nextElement();
        if (!value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v2 = value.nextElement();
        if (value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        if (v1 instanceof Number) {
            this.set(new double[]{((Number)v1).doubleValue(), ((Number)v2).doubleValue()});
        } else {
            this.set(new double[]{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())});
        }
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(Map<?, ?> value) {
        if (value == null || value.size() != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Iterator<?> i = value.values().iterator();
        Object v1 = i.next();
        Object v2 = i.next();
        if (v1 instanceof Number) {
            this.set(new double[]{((Number)v1).doubleValue(), ((Number)v2).doubleValue()});
        } else {
            this.set(new double[]{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())});
        }
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(String value) {
        throw this.newUnsupportedException("String", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(UUID value) {
        throw this.newUnsupportedException("UUID", "Point");
    }

    @Override
    public ClickHouseGeoPointValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (value instanceof ClickHouseGeoPointValue) {
            this.set((double[])((ClickHouseGeoPointValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(Object[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v1 = value[0];
        Object v2 = value[1];
        if (v1 instanceof Number) {
            this.set(new double[]{((Number)v1).doubleValue(), ((Number)v2).doubleValue()});
        } else {
            this.set(new double[]{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())});
        }
        return this;
    }

    @Override
    public ClickHouseGeoPointValue update(Object value) {
        if (value instanceof double[]) {
            this.update((double[])value);
        } else {
            super.update(value);
        }
        return this;
    }
}

