/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.epoll;

import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.Channel;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.ChannelException;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollChannel;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.epoll.AbstractEpollStreamChannel;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoop;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.epoll.EpollSocketChannelConfig;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.epoll.EpollTcpInfo;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.epoll.LinuxSocket;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.epoll.Native;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.epoll.TcpMd5Util;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.socket.InternetProtocolFamily;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.socket.ServerSocketChannel;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.socket.SocketChannel;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;

public final class EpollSocketChannel
extends AbstractEpollStreamChannel
implements SocketChannel {
    private final EpollSocketChannelConfig config;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    public EpollSocketChannel() {
        super(LinuxSocket.newSocketStream(), false);
        this.config = new EpollSocketChannelConfig(this);
    }

    public EpollSocketChannel(InternetProtocolFamily protocol) {
        super(LinuxSocket.newSocketStream(protocol), false);
        this.config = new EpollSocketChannelConfig(this);
    }

    public EpollSocketChannel(int fd) {
        super(fd);
        this.config = new EpollSocketChannelConfig(this);
    }

    EpollSocketChannel(LinuxSocket fd, boolean active) {
        super(fd, active);
        this.config = new EpollSocketChannelConfig(this);
    }

    EpollSocketChannel(Channel parent, LinuxSocket fd, InetSocketAddress remoteAddress) {
        super(parent, fd, remoteAddress);
        this.config = new EpollSocketChannelConfig(this);
        if (parent instanceof EpollServerSocketChannel) {
            this.tcpMd5SigAddresses = ((EpollServerSocketChannel)parent).tcpMd5SigAddresses();
        }
    }

    public EpollTcpInfo tcpInfo() {
        return this.tcpInfo(new EpollTcpInfo());
    }

    public EpollTcpInfo tcpInfo(EpollTcpInfo info) {
        try {
            this.socket.getTcpInfo(info);
            return info;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public EpollSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollSocketChannelUnsafe();
    }

    @Override
    boolean doConnect0(SocketAddress remote) throws Exception {
        if (Native.IS_SUPPORTING_TCP_FASTOPEN_CLIENT && this.config.isTcpFastOpenConnect()) {
            ByteBuf initialData;
            long localFlushedAmount;
            ChannelOutboundBuffer outbound = this.unsafe().outboundBuffer();
            outbound.addFlush();
            Object curr = outbound.current();
            if (curr instanceof ByteBuf && (localFlushedAmount = this.doWriteOrSendBytes(initialData = (ByteBuf)curr, (InetSocketAddress)remote, true)) > 0L) {
                outbound.removeBytes(localFlushedAmount);
                return true;
            }
        }
        return super.doConnect0(remote);
    }

    void setTcpMd5Sig(Map<InetAddress, byte[]> keys) throws IOException {
        this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, keys);
    }

    private final class EpollSocketChannelUnsafe
    extends AbstractEpollStreamChannel.EpollStreamUnsafe {
        private EpollSocketChannelUnsafe() {
        }

        @Override
        protected Executor prepareToClose() {
            try {
                if (EpollSocketChannel.this.isOpen() && EpollSocketChannel.this.config().getSoLinger() > 0) {
                    ((EpollEventLoop)EpollSocketChannel.this.eventLoop()).remove(EpollSocketChannel.this);
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

