/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseRequestManager;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseTransactionException;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.value.UnsignedLong;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ClickHouseTransaction
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseTransaction.class);
    private static final long serialVersionUID = -4618710299106666829L;
    private static final String[] NAMES = new String[]{"New", "Active", "Failed", "Commited", "RolledBack"};
    static final String QUERY_SELECT_TX_ID = "SELECT transactionID()";
    public static final String COMMAND_BEGIN = "BEGIN";
    public static final String COMMAND_COMMIT = "COMMIT";
    public static final String COMMAND_ROLLBACK = "ROLLBACK";
    public static final int NEW = 0;
    public static final int ACTIVE = 1;
    public static final int FAILED = 2;
    public static final int COMMITTED = 3;
    public static final int ROLLED_BACK = 4;
    public static final long CSN_UNKNOWN = 0L;
    public static final long CSN_PREHISTORIC = 1L;
    public static final long CSN_COMMITTING = 2L;
    public static final long CSN_EVERYTHING_VISIBLE = 3L;
    public static final long CSN_MAX_RESERVED = 32L;
    public static final String SETTING_IMPLICIT_TRANSACTION = "implicit_transaction";
    public static final String SETTING_THROW_ON_UNSUPPORTED_QUERY_INSIDE_TRANSACTION = "throw_on_unsupported_query_inside_transaction";
    public static final String SETTING_WAIT_CHANGES_BECOME_VISIBLE_AFTER_COMMIT_MODE = "wait_changes_become_visible_after_commit_mode";
    private final ClickHouseNode server;
    private final String sessionId;
    private final int timeout;
    private final boolean implicit;
    private final AtomicReference<XID> id;
    private final AtomicInteger state;

    static void setImplicitTransaction(ClickHouseRequest<?> request, boolean enable) throws ClickHouseException {
        if (enable) {
            ((ClickHouseRequest)request.set(SETTING_IMPLICIT_TRANSACTION, Integer.valueOf(1))).transaction(null);
        } else {
            request.removeSetting(SETTING_IMPLICIT_TRANSACTION);
        }
    }

    protected ClickHouseTransaction(ClickHouseNode server, int timeout, boolean implicit) throws ClickHouseException {
        this.server = server;
        this.sessionId = ClickHouseRequestManager.getInstance().createSessionId();
        this.timeout = timeout < 1 ? 0 : timeout;
        this.implicit = implicit;
        this.id = new AtomicReference<XID>(XID.EMPTY);
        this.state = new AtomicInteger(0);
        try {
            this.id.updateAndGet(x -> {
                boolean success = false;
                try {
                    this.issue("BEGIN TRANSACTION", false, Collections.emptyMap());
                    XID txId = XID.of(this.issue(QUERY_SELECT_TX_ID).getValue(0).asTuple());
                    if (XID.EMPTY.equals(txId)) {
                        throw new ClickHouseTransactionException(659, ClickHouseUtils.format("Failed to start transaction(implicit=%s)", implicit), this);
                    }
                    success = this.state.compareAndSet(0, 1);
                    XID xID = txId;
                    return xID;
                }
                catch (ClickHouseException e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    if (!success) {
                        this.state.compareAndSet(0, 2);
                    }
                }
            });
            log.debug((Object)"Began transaction(implicit=%s): %s", this.implicit, this);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof ClickHouseException) {
                throw (ClickHouseException)e.getCause();
            }
            throw e;
        }
    }

    protected ClickHouseTransaction(ClickHouseNode server, String sessionId, int timeout, XID id) {
        this.server = server;
        this.sessionId = sessionId;
        this.timeout = timeout < 1 ? 0 : timeout;
        this.implicit = false;
        if (id == null || XID.EMPTY.equals(id)) {
            this.id = new AtomicReference<XID>(XID.EMPTY);
            this.state = new AtomicInteger(0);
        } else {
            this.id = new AtomicReference<XID>(id);
            this.state = new AtomicInteger(1);
        }
    }

    protected void ensureTransactionId() throws ClickHouseException {
        XID serverTxId;
        if (!this.implicit && !(serverTxId = XID.of(this.issue(QUERY_SELECT_TX_ID).getValue(0).asTuple())).equals(this.id.get())) {
            throw new ClickHouseTransactionException(ClickHouseUtils.format("Inconsistent transaction ID - client expected %s but found %s on server.", this.id.get(), serverTxId), this);
        }
    }

    protected final ClickHouseRecord issue(String command) throws ClickHouseException {
        return this.issue(command, true, Collections.emptyMap());
    }

    protected ClickHouseRecord issue(String command, boolean sessionCheck, Map<String, Serializable> settings) throws ClickHouseException {
        ClickHouseRecord result = ClickHouseRecord.EMPTY;
        try (ClickHouseResponse response = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)ClickHouseClient.newInstance(this.server.getProtocol()).read(this.server).format(ClickHouseFormat.RowBinaryWithNamesAndTypes)).settings(settings)).session(this.sessionId, sessionCheck, this.timeout > 0 ? Integer.valueOf(this.timeout) : null)).query(command)).executeAndWait();){
            Iterator<ClickHouseRecord> records = response.records().iterator();
            if (records.hasNext()) {
                result = records.next();
            }
        }
        catch (ClickHouseException e) {
            switch (e.getErrorCode()) {
                case 372: {
                    throw new ClickHouseTransactionException("Invalid transaction due to session not found or timed out", e.getCause(), this);
                }
                case 649: 
                case 659: {
                    throw new ClickHouseTransactionException(e.getErrorCode(), e.getMessage(), e.getCause(), this);
                }
            }
            throw e;
        }
        return result;
    }

    public XID getId() {
        return this.id.get();
    }

    public ClickHouseNode getServer() {
        return this.server;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getState() {
        return this.state.get();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public boolean isNew() {
        return this.state.get() == 0;
    }

    public boolean isActive() {
        return this.state.get() == 1;
    }

    public boolean isCommitted() {
        return this.state.get() == 3;
    }

    public boolean isRolledBack() {
        return this.state.get() == 4;
    }

    public boolean isFailed() {
        return this.state.get() == 2;
    }

    public void abort() {
        log.debug((Object)"Abort %s", this);
        int currentState = this.state.get();
        if (currentState == 0) {
            log.debug((Object)"Skip since it's a new transaction which hasn't started yet", new Object[0]);
            return;
        }
        this.id.updateAndGet(x -> {
            try {
                ClickHouseResponse response = ((ClickHouseRequest)ClickHouseClient.newInstance(this.server.getProtocol()).read(this.server).query("KILL TRANSACTION WHERE tid=" + x.asTupleString())).executeAndWait();
                if (response != null) {
                    response.close();
                }
            }
            catch (ClickHouseException e) {
                log.warn((Object)"Failed to abort transaction %s", x.asTupleString());
            }
            finally {
                this.state.compareAndSet(currentState, 2);
            }
            return x;
        });
        log.debug((Object)"Aborted transaction: %s", this);
    }

    public void begin() throws ClickHouseException {
        this.begin(Collections.emptyMap());
    }

    public void begin(Map<String, Serializable> settings) throws ClickHouseException {
        log.debug((Object)"Begin %s", this);
        int currentState = this.state.get();
        if (currentState == 1) {
            log.debug((Object)"Skip since the transaction has been started already", new Object[0]);
            return;
        }
        if (currentState == 2) {
            throw new ClickHouseTransactionException("Cannot restart a failed transaction - please roll back or create a new transaction", this);
        }
        try {
            this.id.updateAndGet(x -> {
                boolean success = false;
                XID txId = null;
                try {
                    txId = XID.of(this.issue(QUERY_SELECT_TX_ID, false, Collections.emptyMap()).getValue(0).asTuple());
                    if (XID.EMPTY.equals(txId)) {
                        this.issue("BEGIN TRANSACTION", true, settings);
                        txId = XID.of(this.issue(QUERY_SELECT_TX_ID).getValue(0).asTuple());
                    }
                    if (XID.EMPTY.equals(txId)) {
                        throw new ClickHouseTransactionException(659, "Failed to start new transaction", this);
                    }
                    success = this.state.compareAndSet(currentState, 1);
                    XID xID = txId;
                    return xID;
                }
                catch (ClickHouseException e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    if (txId != null && !success) {
                        this.state.compareAndSet(currentState, 2);
                    }
                }
            });
            log.debug((Object)"Began new transaction: %s", this);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof ClickHouseException) {
                throw (ClickHouseException)e.getCause();
            }
            throw e;
        }
    }

    public void commit() throws ClickHouseException {
        this.commit(Collections.emptyMap());
    }

    public void commit(Map<String, Serializable> settings) throws ClickHouseException {
        log.debug((Object)"Commit %s", this);
        int currentState = this.state.get();
        if (currentState == 3) {
            log.debug((Object)"Skip since the transaction has been committed already", new Object[0]);
            return;
        }
        if (currentState != 1) {
            throw new ClickHouseTransactionException(ClickHouseUtils.format("Cannot commit inactive transaction(state=%s)", NAMES[currentState]), this);
        }
        try {
            this.id.updateAndGet(x -> {
                boolean success = false;
                try {
                    this.ensureTransactionId();
                    this.issue(COMMAND_COMMIT, true, settings);
                    success = this.state.compareAndSet(currentState, 3);
                    XID xID = x;
                    return xID;
                }
                catch (ClickHouseException e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    if (!success) {
                        this.state.compareAndSet(currentState, 2);
                    }
                }
            });
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof ClickHouseException) {
                throw (ClickHouseException)e.getCause();
            }
            throw e;
        }
    }

    public void rollback() throws ClickHouseException {
        this.rollback(Collections.emptyMap());
    }

    public void rollback(Map<String, Serializable> settings) throws ClickHouseException {
        log.debug((Object)"Roll back %s", this);
        int currentState = this.state.get();
        if (currentState == 0) {
            log.debug((Object)"Skip since the transaction has not started yet", new Object[0]);
            return;
        }
        if (currentState == 4) {
            log.debug((Object)"Skip since the transaction has been rolled back already", new Object[0]);
            return;
        }
        if (currentState != 1 && currentState != 2) {
            throw new ClickHouseTransactionException(ClickHouseUtils.format("Cannot roll back inactive transaction(state=%s)", NAMES[currentState]), this);
        }
        try {
            this.id.updateAndGet(x -> {
                boolean success = false;
                try {
                    this.ensureTransactionId();
                    this.issue(COMMAND_ROLLBACK, true, settings);
                    success = this.state.compareAndSet(currentState, 4);
                    XID xID = x;
                    return xID;
                }
                catch (ClickHouseException e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    if (!success) {
                        this.state.compareAndSet(currentState, 2);
                    }
                }
            });
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof ClickHouseException) {
                throw (ClickHouseException)e.getCause();
            }
            throw e;
        }
    }

    public void snapshot(long snapshotVersion) throws ClickHouseException {
        this.snapshot(snapshotVersion, Collections.emptyMap());
    }

    public void snapshot(long snapshotVersion, Map<String, Serializable> settings) throws ClickHouseException {
        log.debug((Object)"Set snapshot %d for %s", snapshotVersion, this);
        int currentState = this.state.get();
        if (currentState != 1) {
            throw new ClickHouseTransactionException(ClickHouseUtils.format("Cannot set snapshot version for inactive transaction(state=%s)", NAMES[currentState]), this);
        }
        try {
            this.id.updateAndGet(x -> {
                boolean success = false;
                try {
                    this.ensureTransactionId();
                    this.issue("SET TRANSACTION SNAPSHOT " + snapshotVersion, true, settings);
                    success = true;
                    XID xID = x;
                    return xID;
                }
                catch (ClickHouseException e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    if (!success) {
                        this.state.compareAndSet(currentState, 2);
                    }
                }
            });
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof ClickHouseException) {
                throw (ClickHouseException)e.getCause();
            }
            throw e;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.server.getBaseUri().hashCode();
        result = 31 * result + this.sessionId.hashCode();
        result = 31 * result + this.timeout;
        result = 31 * result + this.id.get().hashCode();
        result = 31 * result + this.state.get();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseTransaction other = (ClickHouseTransaction)obj;
        return this.server.isSameEndpoint(other.server) && this.sessionId.equals(other.sessionId) && this.timeout == other.timeout && this.id.get().equals(other.id.get()) && this.state.get() == other.state.get();
    }

    public String toString() {
        return "ClickHouseTransaction [id=" + this.id.get().asTupleString() + ", session=" + this.sessionId + ", timeout=" + this.timeout + ", state=" + NAMES[this.state.get()] + ", server=" + this.server.getBaseUri() + "]@" + this.hashCode();
    }

    public static class XID
    implements Serializable {
        private static final long serialVersionUID = 4907177669971332404L;
        public static final XID EMPTY = new XID(0L, 0L, new UUID(0L, 0L).toString());
        private final long snapshotVersion;
        private final long localTxCounter;
        private final String hostId;

        public static XID of(List<?> list) {
            if (list == null || list.size() != 3) {
                throw new IllegalArgumentException("Non-null tuple with 3 elements(long, long, String) is required");
            }
            long snapshotVersion = ((UnsignedLong)list.get(0)).longValue();
            long localTxCounter = ((UnsignedLong)list.get(1)).longValue();
            String hostId = String.valueOf(list.get(2));
            if (XID.EMPTY.snapshotVersion == snapshotVersion && XID.EMPTY.localTxCounter == localTxCounter && XID.EMPTY.hostId.equals(hostId)) {
                return EMPTY;
            }
            return new XID(snapshotVersion, localTxCounter, hostId);
        }

        protected XID(long snapshotVersion, long localTxCounter, String hostId) {
            this.snapshotVersion = snapshotVersion;
            this.localTxCounter = localTxCounter;
            this.hostId = hostId;
        }

        public long getSnapshotVersion() {
            return this.snapshotVersion;
        }

        public long getLocalTransactionCounter() {
            return this.localTxCounter;
        }

        public String getHostId() {
            return this.hostId;
        }

        public String asTupleString() {
            return "" + '(' + this.snapshotVersion + ',' + this.localTxCounter + ",'" + this.hostId + "')";
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + (int)(this.snapshotVersion ^ this.snapshotVersion >>> 32);
            result = 31 * result + (int)(this.localTxCounter ^ this.localTxCounter >>> 32);
            result = 31 * result + this.hostId.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            XID other = (XID)obj;
            return this.snapshotVersion == other.snapshotVersion && this.localTxCounter == other.localTxCounter && this.hostId.equals(other.hostId);
        }

        public String toString() {
            return "TransactionId [snapshotVersion=" + this.snapshotVersion + ", localTxCounter=" + this.localTxCounter + ", hostId=" + this.hostId + "]@" + this.hashCode();
        }
    }
}

