/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseHealthCheckMethod;
import com.clickhouse.client.config.ClickHouseProxyType;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataConfig;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class SettingsConverter {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("[,'\\\"=\\t\\n]{1}");
    private static final Map<String, ClickHouseOption> REQUEST_OPTIONS = SettingsConverter.createMapOfRequestOptions();

    public static Map<String, Serializable> toRequestSettings(Map<String, Object> settings, Map<String, Object> queryParams) {
        HashMap<String, Serializable> requestSettings = new HashMap<String, Serializable>();
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            String key = entry.getKey();
            boolean isServerSetting = key.startsWith("clickhouse_setting_");
            if (!isServerSetting && REQUEST_OPTIONS.get(key) != null) continue;
            if (isServerSetting) {
                key = key.substring("clickhouse_setting_".length());
            }
            if (entry.getValue() instanceof Map) {
                Map map = (Map)entry.getValue();
                requestSettings.put(key, (Serializable)((Object)SettingsConverter.convertMapToStringValue(map)));
                continue;
            }
            if (entry.getValue() instanceof Collection) {
                Collection collection = (Collection)entry.getValue();
                requestSettings.put(key, (Serializable)((Object)SettingsConverter.convertCollectionToStringValue(collection)));
                continue;
            }
            requestSettings.put(key, (Serializable)entry.getValue());
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            queryParams.entrySet().forEach(e -> requestSettings.put("param_" + (String)e.getKey(), (Serializable)e.getValue()));
        }
        return requestSettings;
    }

    public static Map<ClickHouseOption, Serializable> toRequestOptions(Map<String, Object> settings) {
        HashMap<ClickHouseOption, Serializable> requestOptions = new HashMap<ClickHouseOption, Serializable>();
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            if (!REQUEST_OPTIONS.containsKey(entry.getKey())) continue;
            ClickHouseOption option = REQUEST_OPTIONS.get(entry.getKey());
            if (entry.getValue() instanceof Map) {
                Map map = (Map)entry.getValue();
                requestOptions.put(option, (Serializable)((Object)SettingsConverter.convertMapToStringValue(map)));
                continue;
            }
            if (entry.getValue() instanceof Collection) {
                Collection collection = (Collection)entry.getValue();
                requestOptions.put(option, (Serializable)((Object)SettingsConverter.convertCollectionToStringValue(collection)));
                continue;
            }
            requestOptions.put(option, (Serializable)entry.getValue());
        }
        return requestOptions;
    }

    private static String convertMapToStringValue(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : map.entrySet()) {
            sb.append(SettingsConverter.escape(e.getKey())).append('=').append(SettingsConverter.escape(e.getValue())).append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static String convertCollectionToStringValue(Collection<?> collection) {
        StringBuilder sb = new StringBuilder();
        for (Object value : collection) {
            sb.append(SettingsConverter.escape(value.toString())).append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String escape(String value) {
        return ESCAPE_PATTERN.matcher(value).replaceAll("\\\\$0");
    }

    public static Map<String, ClickHouseOption> createMapOfRequestOptions() {
        HashMap map = new HashMap();
        Arrays.asList(OldClientOptions.FORMAT, OldClientOptions.MAX_EXECUTION_TIME, OldClientOptions.CUSTOM_PARAMS, OldClientOptions.AUTO_DISCOVERY, OldClientOptions.CUSTOM_SETTINGS, OldClientOptions.CUSTOM_SOCKET_FACTORY, OldClientOptions.CUSTOM_SOCKET_FACTORY_OPTIONS, OldClientOptions.CLIENT_NAME, OldClientOptions.DECOMPRESS, OldClientOptions.DECOMPRESS_ALGORITHM, OldClientOptions.DECOMPRESS_LEVEL, OldClientOptions.COMPRESS, OldClientOptions.COMPRESS_ALGORITHM, OldClientOptions.COMPRESS_LEVEL, OldClientOptions.CONNECTION_TIMEOUT, OldClientOptions.DATABASE, OldClientOptions.MAX_BUFFER_SIZE, OldClientOptions.BUFFER_SIZE, OldClientOptions.BUFFER_QUEUE_VARIATION, OldClientOptions.READ_BUFFER_SIZE, OldClientOptions.WRITE_BUFFER_SIZE, OldClientOptions.REQUEST_CHUNK_SIZE, OldClientOptions.REQUEST_BUFFERING, OldClientOptions.RESPONSE_BUFFERING, OldClientOptions.MAX_MAPPER_CACHE, OldClientOptions.MAX_QUEUED_BUFFERS, OldClientOptions.MAX_QUEUED_REQUESTS, OldClientOptions.MAX_RESULT_ROWS, OldClientOptions.MAX_THREADS_PER_CLIENT, OldClientOptions.PRODUCT_NAME, OldClientOptions.NODE_CHECK_INTERVAL, OldClientOptions.FAILOVER, OldClientOptions.RETRY, OldClientOptions.REPEAT_ON_SESSION_LOCK, OldClientOptions.REUSE_VALUE_WRAPPER, OldClientOptions.SERVER_TIME_ZONE, OldClientOptions.SERVER_VERSION, OldClientOptions.SESSION_TIMEOUT, OldClientOptions.SESSION_CHECK, OldClientOptions.SOCKET_TIMEOUT, OldClientOptions.SSL, OldClientOptions.SSL_MODE, OldClientOptions.SSL_ROOT_CERTIFICATE, OldClientOptions.SSL_CERTIFICATE, OldClientOptions.SSL_KEY, OldClientOptions.KEY_STORE_TYPE, OldClientOptions.TRUST_STORE, OldClientOptions.KEY_STORE_PASSWORD, OldClientOptions.TRANSACTION_TIMEOUT, OldClientOptions.WIDEN_UNSIGNED_TYPES, OldClientOptions.USE_BINARY_STRING, OldClientOptions.USE_BLOCKING_QUEUE, OldClientOptions.USE_COMPILATION, OldClientOptions.USE_OBJECTS_IN_ARRAYS, OldClientOptions.USE_SERVER_TIME_ZONE, OldClientOptions.USE_SERVER_TIME_ZONE_FOR_DATES, OldClientOptions.SERVER_TIME_ZONE, OldClientOptions.USE_TIME_ZONE).forEach(option -> map.put(option.getKey(), option));
        return Collections.unmodifiableMap(map);
    }

    public static final class OldClientOptions
    extends Enum<OldClientOptions>
    implements ClickHouseOption {
        public static final /* enum */ OldClientOptions CUSTOM_PARAMS;
        public static final /* enum */ OldClientOptions ASYNC;
        public static final /* enum */ OldClientOptions AUTO_DISCOVERY;
        public static final /* enum */ OldClientOptions CUSTOM_SETTINGS;
        public static final /* enum */ OldClientOptions CUSTOM_SOCKET_FACTORY;
        public static final /* enum */ OldClientOptions CUSTOM_SOCKET_FACTORY_OPTIONS;
        public static final /* enum */ OldClientOptions LOAD_BALANCING_POLICY;
        public static final /* enum */ OldClientOptions LOAD_BALANCING_TAGS;
        public static final /* enum */ OldClientOptions HEALTH_CHECK_INTERVAL;
        public static final /* enum */ OldClientOptions HEALTH_CHECK_METHOD;
        public static final /* enum */ OldClientOptions NODE_DISCOVERY_INTERVAL;
        public static final /* enum */ OldClientOptions NODE_DISCOVERY_LIMIT;
        public static final /* enum */ OldClientOptions NODE_CHECK_INTERVAL;
        public static final /* enum */ OldClientOptions NODE_GROUP_SIZE;
        public static final /* enum */ OldClientOptions CHECK_ALL_NODES;
        public static final /* enum */ OldClientOptions BUFFER_SIZE;
        public static final /* enum */ OldClientOptions BUFFER_QUEUE_VARIATION;
        public static final /* enum */ OldClientOptions READ_BUFFER_SIZE;
        public static final /* enum */ OldClientOptions WRITE_BUFFER_SIZE;
        public static final /* enum */ OldClientOptions REQUEST_CHUNK_SIZE;
        public static final /* enum */ OldClientOptions REQUEST_BUFFERING;
        public static final /* enum */ OldClientOptions RESPONSE_BUFFERING;
        public static final /* enum */ OldClientOptions CLIENT_NAME;
        public static final /* enum */ OldClientOptions COMPRESS;
        public static final /* enum */ OldClientOptions DECOMPRESS;
        public static final /* enum */ OldClientOptions COMPRESS_ALGORITHM;
        public static final /* enum */ OldClientOptions DECOMPRESS_ALGORITHM;
        public static final /* enum */ OldClientOptions COMPRESS_LEVEL;
        public static final /* enum */ OldClientOptions DECOMPRESS_LEVEL;
        public static final /* enum */ OldClientOptions CONNECTION_TIMEOUT;
        public static final /* enum */ OldClientOptions DATABASE;
        public static final /* enum */ OldClientOptions FAILOVER;
        public static final /* enum */ OldClientOptions FORMAT;
        public static final /* enum */ OldClientOptions LOG_LEADING_COMMENT;
        public static final /* enum */ OldClientOptions MAX_BUFFER_SIZE;
        public static final /* enum */ OldClientOptions MAX_MAPPER_CACHE;
        public static final /* enum */ OldClientOptions MAX_EXECUTION_TIME;
        public static final /* enum */ OldClientOptions MAX_QUEUED_BUFFERS;
        public static final /* enum */ OldClientOptions MAX_QUEUED_REQUESTS;
        public static final /* enum */ OldClientOptions MAX_RESULT_ROWS;
        public static final /* enum */ OldClientOptions MAX_THREADS_PER_CLIENT;
        public static final /* enum */ OldClientOptions PRODUCT_NAME;
        public static final /* enum */ OldClientOptions RENAME_RESPONSE_COLUMN;
        public static final /* enum */ OldClientOptions RETRY;
        public static final /* enum */ OldClientOptions REPEAT_ON_SESSION_LOCK;
        public static final /* enum */ OldClientOptions REUSE_VALUE_WRAPPER;
        public static final /* enum */ OldClientOptions SERVER_REVISION;
        public static final /* enum */ OldClientOptions SERVER_TIME_ZONE;
        public static final /* enum */ OldClientOptions SERVER_VERSION;
        public static final /* enum */ OldClientOptions SESSION_ID;
        public static final /* enum */ OldClientOptions SESSION_CHECK;
        public static final /* enum */ OldClientOptions SESSION_TIMEOUT;
        public static final /* enum */ OldClientOptions SOCKET_TIMEOUT;
        public static final /* enum */ OldClientOptions SOCKET_REUSEADDR;
        public static final /* enum */ OldClientOptions SOCKET_KEEPALIVE;
        public static final /* enum */ OldClientOptions SOCKET_LINGER;
        public static final /* enum */ OldClientOptions SOCKET_IP_TOS;
        public static final /* enum */ OldClientOptions SOCKET_TCP_NODELAY;
        public static final /* enum */ OldClientOptions SOCKET_RCVBUF;
        public static final /* enum */ OldClientOptions SOCKET_SNDBUF;
        public static final /* enum */ OldClientOptions SSL;
        public static final /* enum */ OldClientOptions SSL_MODE;
        public static final /* enum */ OldClientOptions SSL_ROOT_CERTIFICATE;
        public static final /* enum */ OldClientOptions SSL_CERTIFICATE;
        public static final /* enum */ OldClientOptions SSL_KEY;
        public static final /* enum */ OldClientOptions KEY_STORE_TYPE;
        public static final /* enum */ OldClientOptions TRUST_STORE;
        public static final /* enum */ OldClientOptions KEY_STORE_PASSWORD;
        public static final /* enum */ OldClientOptions TRANSACTION_TIMEOUT;
        public static final /* enum */ OldClientOptions WIDEN_UNSIGNED_TYPES;
        public static final /* enum */ OldClientOptions USE_BINARY_STRING;
        public static final /* enum */ OldClientOptions USE_BLOCKING_QUEUE;
        public static final /* enum */ OldClientOptions USE_COMPILATION;
        public static final /* enum */ OldClientOptions USE_OBJECTS_IN_ARRAYS;
        public static final /* enum */ OldClientOptions PROXY_TYPE;
        public static final /* enum */ OldClientOptions PROXY_HOST;
        public static final /* enum */ OldClientOptions PROXY_PORT;
        public static final /* enum */ OldClientOptions PROXY_USERNAME;
        public static final /* enum */ OldClientOptions PROXY_PASSWORD;
        public static final /* enum */ OldClientOptions USE_SERVER_TIME_ZONE;
        public static final /* enum */ OldClientOptions USE_SERVER_TIME_ZONE_FOR_DATES;
        public static final /* enum */ OldClientOptions USE_TIME_ZONE;
        public static final /* enum */ OldClientOptions QUERY_ID;
        public static final /* enum */ OldClientOptions CONNECTION_TTL;
        private final String key;
        private final Serializable defaultValue;
        private final Class<? extends Serializable> clazz;
        private final String description;
        private final boolean sensitive;
        private static final Map<String, OldClientOptions> options;
        static final String UNKNOWN = "unknown";
        public static final String LATEST_KNOWN_VERSION = "0.6.3";
        public static final String PRODUCT_VERSION;
        public static final String PRODUCT_REVISION;
        public static final String CLIENT_OS_INFO;
        public static final String CLIENT_JVM_INFO;
        public static final String CLIENT_USER;
        public static final String CLIENT_HOST;
        private static final /* synthetic */ OldClientOptions[] $VALUES;

        public static OldClientOptions[] values() {
            return (OldClientOptions[])$VALUES.clone();
        }

        public static OldClientOptions valueOf(String name) {
            return Enum.valueOf(OldClientOptions.class, name);
        }

        public static String buildUserAgent(String productName, String additionalProperty) {
            productName = productName == null || productName.isEmpty() ? (String)((Object)PRODUCT_NAME.getEffectiveDefaultValue()) : productName.trim();
            StringBuilder builder = new StringBuilder(productName).append(PRODUCT_VERSION.isEmpty() ? "" : "/" + PRODUCT_VERSION);
            if (!String.valueOf(PRODUCT_NAME.getDefaultValue()).equals(productName)) {
                builder.append(" ").append(PRODUCT_NAME.getDefaultValue()).append(LATEST_KNOWN_VERSION);
            }
            builder.append(" (").append(CLIENT_JVM_INFO);
            if (additionalProperty != null && !additionalProperty.isEmpty()) {
                builder.append("; ").append(additionalProperty.trim());
            }
            return builder.append(")").toString();
        }

        public static String getSystemConfig(String propertyName, String defaultValue) {
            String propertyValue = System.getProperty(propertyName);
            if (defaultValue == null) {
                return propertyValue;
            }
            return propertyValue == null || propertyValue.isEmpty() ? defaultValue : propertyValue;
        }

        public static OldClientOptions fromKey(String key) {
            return options.get(key);
        }

        private <T extends Serializable> OldClientOptions(String key, T defaultValue, String description) {
            this(key, defaultValue, description, false);
        }

        private <T extends Serializable> OldClientOptions(String key, T defaultValue, String description, boolean sensitive) {
            this.key = ClickHouseChecker.nonNull(key, "key");
            this.defaultValue = ClickHouseChecker.nonNull(defaultValue, "defaultValue");
            this.clazz = defaultValue.getClass();
            this.description = ClickHouseChecker.nonNull(description, "description");
            this.sensitive = sensitive;
        }

        @Override
        public Serializable getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Class<? extends Serializable> getValueType() {
            return this.clazz;
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        private static /* synthetic */ OldClientOptions[] $values() {
            return new OldClientOptions[]{CUSTOM_PARAMS, ASYNC, AUTO_DISCOVERY, CUSTOM_SETTINGS, CUSTOM_SOCKET_FACTORY, CUSTOM_SOCKET_FACTORY_OPTIONS, LOAD_BALANCING_POLICY, LOAD_BALANCING_TAGS, HEALTH_CHECK_INTERVAL, HEALTH_CHECK_METHOD, NODE_DISCOVERY_INTERVAL, NODE_DISCOVERY_LIMIT, NODE_CHECK_INTERVAL, NODE_GROUP_SIZE, CHECK_ALL_NODES, BUFFER_SIZE, BUFFER_QUEUE_VARIATION, READ_BUFFER_SIZE, WRITE_BUFFER_SIZE, REQUEST_CHUNK_SIZE, REQUEST_BUFFERING, RESPONSE_BUFFERING, CLIENT_NAME, COMPRESS, DECOMPRESS, COMPRESS_ALGORITHM, DECOMPRESS_ALGORITHM, COMPRESS_LEVEL, DECOMPRESS_LEVEL, CONNECTION_TIMEOUT, DATABASE, FAILOVER, FORMAT, LOG_LEADING_COMMENT, MAX_BUFFER_SIZE, MAX_MAPPER_CACHE, MAX_EXECUTION_TIME, MAX_QUEUED_BUFFERS, MAX_QUEUED_REQUESTS, MAX_RESULT_ROWS, MAX_THREADS_PER_CLIENT, PRODUCT_NAME, RENAME_RESPONSE_COLUMN, RETRY, REPEAT_ON_SESSION_LOCK, REUSE_VALUE_WRAPPER, SERVER_REVISION, SERVER_TIME_ZONE, SERVER_VERSION, SESSION_ID, SESSION_CHECK, SESSION_TIMEOUT, SOCKET_TIMEOUT, SOCKET_REUSEADDR, SOCKET_KEEPALIVE, SOCKET_LINGER, SOCKET_IP_TOS, SOCKET_TCP_NODELAY, SOCKET_RCVBUF, SOCKET_SNDBUF, SSL, SSL_MODE, SSL_ROOT_CERTIFICATE, SSL_CERTIFICATE, SSL_KEY, KEY_STORE_TYPE, TRUST_STORE, KEY_STORE_PASSWORD, TRANSACTION_TIMEOUT, WIDEN_UNSIGNED_TYPES, USE_BINARY_STRING, USE_BLOCKING_QUEUE, USE_COMPILATION, USE_OBJECTS_IN_ARRAYS, PROXY_TYPE, PROXY_HOST, PROXY_PORT, PROXY_USERNAME, PROXY_PASSWORD, USE_SERVER_TIME_ZONE, USE_SERVER_TIME_ZONE_FOR_DATES, USE_TIME_ZONE, QUERY_ID, CONNECTION_TTL};
        }

        static {
            String[] parts;
            CUSTOM_PARAMS = new OldClientOptions("custom_http_params", "", "Custom HTTP query parameters.");
            ASYNC = new OldClientOptions("async", true, "Whether the client should run in async mode.");
            AUTO_DISCOVERY = new OldClientOptions("auto_discovery", false, "Whether the client should discover more nodes from system tables and/or clickhouse-keeper/zookeeper.");
            CUSTOM_SETTINGS = new OldClientOptions("custom_settings", "", "Comma separated custom server settings for all queries.");
            CUSTOM_SOCKET_FACTORY = new OldClientOptions("custom_socket_factory", "", "Full qualified class name of custom socket factory. This is only supported by TCP client and Apache Http Client.");
            CUSTOM_SOCKET_FACTORY_OPTIONS = new OldClientOptions("custom_socket_factory_options", "", "Comma separated options for custom socket factory.");
            LOAD_BALANCING_POLICY = new OldClientOptions("load_balancing_policy", "", "Load balancing policy, can be one of '', 'firstAlive', 'random', 'roundRobin', or full qualified class name implementing ClickHouseLoadBalancingPolicy.");
            LOAD_BALANCING_TAGS = new OldClientOptions("load_balancing_tags", "", "Load balancing tags for filtering out nodes.");
            HEALTH_CHECK_INTERVAL = new OldClientOptions("health_check_interval", 0, "Health check interval in milliseconds, zero or negative value means one-time.");
            HEALTH_CHECK_METHOD = new OldClientOptions("health_check_method", ClickHouseHealthCheckMethod.SELECT_ONE, "Health check method.");
            NODE_DISCOVERY_INTERVAL = new OldClientOptions("node_discovery_interval", 0, "Node discovery interval in milliseconds, zero or negative value means one-time discovery.");
            NODE_DISCOVERY_LIMIT = new OldClientOptions("node_discovery_limit", 100, "Maximum number of nodes can be discovered at a time, zero or negative value means no limit.");
            NODE_CHECK_INTERVAL = new OldClientOptions("node_check_interval", 0, "Node check interval in milliseconds, negative number is treated as zero.");
            NODE_GROUP_SIZE = new OldClientOptions("node_group_size", 50, "Maximum number of nodes can be used for operation at a time, zero or negative value means all.");
            CHECK_ALL_NODES = new OldClientOptions("check_all_nodes", false, "Whether to perform health check against all nodes or just faulty ones.");
            BUFFER_SIZE = new OldClientOptions("buffer_size", 8192, "Default buffer size in byte for both request and response.");
            BUFFER_QUEUE_VARIATION = new OldClientOptions("buffer_queue_variation", 100, "Number of times the buffer queue is filled up before increasing capacity of buffer queue. Zero or negative value means the queue length is fixed.");
            READ_BUFFER_SIZE = new OldClientOptions("read_buffer_size", 0, "Read buffer size in byte, zero or negative value means same as buffer_size");
            WRITE_BUFFER_SIZE = new OldClientOptions("write_buffer_size", 0, "Write buffer size in byte, zero or negative value means same as buffer_size");
            REQUEST_CHUNK_SIZE = new OldClientOptions("request_chunk_size", 0, "Maximum request chunk size in byte, zero or negative value means same as write_buffer_size");
            REQUEST_BUFFERING = new OldClientOptions("request_buffering", ClickHouseDefaults.BUFFERING.getDefaultValue(), "Request buffering mode");
            RESPONSE_BUFFERING = new OldClientOptions("response_buffering", ClickHouseDefaults.BUFFERING.getDefaultValue(), "Response buffering mode.");
            CLIENT_NAME = new OldClientOptions("client_name", "ClickHouse Java Client", "Client name, which is either 'client_name' or 'http_user_agent' shows up in system.query_log table.");
            COMPRESS = new OldClientOptions("compress", true, "Whether the server will compress response it sends to client.");
            DECOMPRESS = new OldClientOptions("decompress", false, "Whether the server will decompress request from client.");
            COMPRESS_ALGORITHM = new OldClientOptions("compress_algorithm", ClickHouseCompression.LZ4, "Algorithm used for server to compress response.");
            DECOMPRESS_ALGORITHM = new OldClientOptions("decompress_algorithm", ClickHouseCompression.LZ4, "Algorithm for server to decompress request.");
            COMPRESS_LEVEL = new OldClientOptions("compress_level", -1, "Compression level for response, -1 standards for default");
            DECOMPRESS_LEVEL = new OldClientOptions("decompress_level", -1, "Compression level for request, -1 standards for default");
            CONNECTION_TIMEOUT = new OldClientOptions("connect_timeout", 5000, "Connection timeout in milliseconds. It's also used for waiting a connection being closed.");
            DATABASE = new OldClientOptions("database", "", "Default database.");
            FAILOVER = new OldClientOptions("failover", 0, "Maximum number of times failover can happen for a request, zero or negative value means no failover.");
            FORMAT = new OldClientOptions("format", ClickHouseDataConfig.DEFAULT_FORMAT, "Default format.");
            LOG_LEADING_COMMENT = new OldClientOptions("log_leading_comment", false, "Whether to log leading comment(as log_comment in system.query_log) of the query.");
            MAX_BUFFER_SIZE = new OldClientOptions("max_buffer_size", 0x100000, "Maximum buffer size in byte can be used for streaming.");
            MAX_MAPPER_CACHE = new OldClientOptions("max_mapper_cache", 100, "Maximum number of mappers can be cached.");
            MAX_EXECUTION_TIME = new OldClientOptions("max_execution_time", 0, "Maximum query execution time in seconds, 0 means no limit.");
            MAX_QUEUED_BUFFERS = new OldClientOptions("max_queued_buffers", 512, "Maximum queued in-memory buffers, 0 or negative number means no limit.");
            MAX_QUEUED_REQUESTS = new OldClientOptions("max_queued_requests", 0, "Maximum queued requests, 0 or negative number means no limit.");
            MAX_RESULT_ROWS = new OldClientOptions("max_result_rows", 0L, "Limit on the number of rows in the result. Also checked for subqueries, and on remote servers when running parts of a distributed query.");
            MAX_THREADS_PER_CLIENT = new OldClientOptions("max_threads_per_client", 0, "Size of thread pool for each client instance, 0 or negative number means the client will use shared thread pool.");
            PRODUCT_NAME = new OldClientOptions("product_name", "ClickHouse-JavaClient", "Product name used in user agent.");
            RENAME_RESPONSE_COLUMN = new OldClientOptions("rename_response_column", ClickHouseDataConfig.DEFAULT_COLUMN_RENAME_METHOD, "Method to rename response columns.");
            RETRY = new OldClientOptions("retry", 0, "Maximum number of times retry can happen for a request, zero or negative value means no retry.");
            REPEAT_ON_SESSION_LOCK = new OldClientOptions("repeat_on_session_lock", true, "Whether to repeat execution when session is locked, until timed out(according to 'session_timeout' or 'connect_timeout').");
            REUSE_VALUE_WRAPPER = new OldClientOptions("reuse_value_wrapper", true, "Whether to reuse wrapper of value(e.g. ClickHouseValue or ClickHouseRecord) for memory efficiency.");
            SERVER_REVISION = new OldClientOptions("server_revision", 54442, "Server revision.");
            SERVER_TIME_ZONE = new OldClientOptions("server_time_zone", "", "Server timezone.");
            SERVER_VERSION = new OldClientOptions("server_version", "", "Server version.");
            SESSION_ID = new OldClientOptions("session_id", "", "Session id");
            SESSION_CHECK = new OldClientOptions("session_check", false, "Whether to check if existence of session id.");
            SESSION_TIMEOUT = new OldClientOptions("session_timeout", 0, "Session timeout in seconds. 0 or negative number means same as server default.");
            SOCKET_TIMEOUT = new OldClientOptions("socket_timeout", 30000, "Socket timeout in milliseconds.");
            SOCKET_REUSEADDR = new OldClientOptions("socket_reuseaddr", false, "Whether allows for the reuse of local addresses and ports. Only works for client using custom Socket(e.g. TCP client or HTTP provider with custom SocketFactory etc.).");
            SOCKET_KEEPALIVE = new OldClientOptions("socket_keepalive", false, "Whether to enable keep-alive packets for a socket connection. Only works for client using custom Socket.");
            SOCKET_LINGER = new OldClientOptions("socket_linger", -1, "Seconds to wait while data is being transmitted before closing the socket. Use negative number to disable the option. Only works for client using custom Socket(e.g. TCP client or HTTP provider with custom SocketFactory etc.).");
            SOCKET_IP_TOS = new OldClientOptions("socket_ip_tos", 0, "Socket IP_TOS option which indicates IP package priority. Only works for client using custom Socket.");
            SOCKET_TCP_NODELAY = new OldClientOptions("socket_tcp_nodelay", false, "");
            SOCKET_RCVBUF = new OldClientOptions("socket_rcvbuf", 0, "Size of the socket receive buffer in bytes. Only works for client using custom Socket.");
            SOCKET_SNDBUF = new OldClientOptions("socket_sndbuf", 0, "Size of the socket send buffer in bytes. Only works for client using custom Socket.");
            SSL = new OldClientOptions("ssl", false, "Whether to enable SSL/TLS for the connection.");
            SSL_MODE = new OldClientOptions("sslmode", ClickHouseSslMode.STRICT, "verify or not certificate: none (don't verify), strict (verify)");
            SSL_ROOT_CERTIFICATE = new OldClientOptions("sslrootcert", "", "SSL/TLS root certificates.");
            SSL_CERTIFICATE = new OldClientOptions("sslcert", "", "SSL/TLS certificate.");
            SSL_KEY = new OldClientOptions("sslkey", "", "RSA key in PKCS#8 format.", true);
            KEY_STORE_TYPE = new OldClientOptions("key_store_type", "", "Specifies the type or format of the keystore/truststore file used for SSL/TLS configuration, such as \"JKS\" (Java KeyStore) or \"PKCS12.\"", true);
            TRUST_STORE = new OldClientOptions("trust_store", "", "Path to the truststore file", true);
            KEY_STORE_PASSWORD = new OldClientOptions("key_store_password", "", "Password needed to access the keystore file specified in the keystore config", true);
            TRANSACTION_TIMEOUT = new OldClientOptions("transaction_timeout", 0, "Transaction timeout in seconds. 0 or negative number means same as session_timeout.");
            WIDEN_UNSIGNED_TYPES = new OldClientOptions("widen_unsigned_types", false, "Whether to convert unsigned types to the next widest type(e.g. use short for UInt8 instead of byte, and UnsignedLong for UInt64).");
            USE_BINARY_STRING = new OldClientOptions("use_binary_string", false, "Whether to support binary string. Enable this option to treat FixedString and String as byte array.");
            USE_BLOCKING_QUEUE = new OldClientOptions("use_blocking_queue", false, "Whether to use blocking queue for buffering.");
            USE_COMPILATION = new OldClientOptions("use_compilation", false, "Whether to use compilation(generated byte code) in object mapping and serialization.");
            USE_OBJECTS_IN_ARRAYS = new OldClientOptions("use_objects_in_arrays", false, "Whether Object[] should be used instead of primitive arrays.");
            PROXY_TYPE = new OldClientOptions("proxy_type", ClickHouseProxyType.IGNORE, "Type of proxy can be used to access ClickHouse server. To use an HTTP/SOCKS proxy, you must specify proxy_host and proxy_port.");
            PROXY_HOST = new OldClientOptions("proxy_host", "", "Set ClickHouse server proxy hostname.");
            PROXY_PORT = new OldClientOptions("proxy_port", -1, "Set ClickHouse server proxy port.");
            PROXY_USERNAME = new OldClientOptions("proxy_username", "", "Set ClickHouse server proxy username.");
            PROXY_PASSWORD = new OldClientOptions("proxy_password", "", "Set ClickHouse server proxy password.");
            USE_SERVER_TIME_ZONE = new OldClientOptions("use_server_time_zone", true, "Whether to use server time zone. On connection init select timezone() will be executed");
            USE_SERVER_TIME_ZONE_FOR_DATES = new OldClientOptions("use_server_time_zone_for_dates", false, "Whether to use timezone from server on Date parsing in getDate(). If false, Date returned is a wrapper of a timestamp at start of the day in client timezone. If true - at start of the day in server or use_time_zone timezone.");
            USE_TIME_ZONE = new OldClientOptions("use_time_zone", "", "Time zone of all DateTime* values. Only used when use_server_time_zone is false. Empty value means client time zone.");
            QUERY_ID = new OldClientOptions("query_id", "", "Query id");
            CONNECTION_TTL = new OldClientOptions("connection_ttl", 0L, "Connection time to live in milliseconds. 0 or negative number means no limit.");
            $VALUES = OldClientOptions.$values();
            HashMap<String, OldClientOptions> map = new HashMap<String, OldClientOptions>();
            for (OldClientOptions o : OldClientOptions.values()) {
                if (map.put(o.getKey(), o) == null) continue;
                throw new IllegalStateException("Duplicated key found: " + o.getKey());
            }
            options = Collections.unmodifiableMap(map);
            String ver = OldClientOptions.class.getPackage().getImplementationVersion();
            String[] stringArray = parts = ver == null || ver.isEmpty() ? null : ver.split("\\s");
            if (parts != null && parts.length == 4 && parts[1].length() > 0 && parts[3].length() > 1 && ver.charAt(ver.length() - 1) == ')') {
                PRODUCT_VERSION = parts[1];
                ver = parts[3];
                PRODUCT_REVISION = ver.substring(0, ver.length() - 1);
            } else {
                PRODUCT_VERSION = LATEST_KNOWN_VERSION;
                PRODUCT_REVISION = UNKNOWN;
            }
            CLIENT_OS_INFO = OldClientOptions.getSystemConfig("os.name", "O/S") + '/' + OldClientOptions.getSystemConfig("os.version", UNKNOWN);
            String javaVersion = System.getProperty("java.vendor.version");
            if (javaVersion == null || javaVersion.isEmpty() || javaVersion.indexOf(32) >= 0) {
                javaVersion = OldClientOptions.getSystemConfig("java.vm.version", OldClientOptions.getSystemConfig("java.version", UNKNOWN));
            }
            CLIENT_JVM_INFO = OldClientOptions.getSystemConfig("java.vm.name", "Java") + '/' + javaVersion;
            CLIENT_USER = OldClientOptions.getSystemConfig("user.name", UNKNOWN);
            try {
                ver = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            CLIENT_HOST = ver == null || ver.isEmpty() ? UNKNOWN : ver;
        }
    }
}

