/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.ClientMisconfigurationException;
import com.clickhouse.client.api.ConnectionInitiationException;
import com.clickhouse.client.api.ServerException;
import java.sql.SQLException;

public final class ExceptionUtils {
    public static final String SQL_STATE_CLIENT_ERROR = "HY000";
    public static final String SQL_STATE_OPERATION_CANCELLED = "HY008";
    public static final String SQL_STATE_CONNECTION_EXCEPTION = "08000";
    public static final String SQL_STATE_SQL_ERROR = "07000";
    public static final String SQL_STATE_NO_DATA = "02000";
    public static final String SQL_STATE_INVALID_SCHEMA = "3F000";
    public static final String SQL_STATE_INVALID_TX_STATE = "25000";
    public static final String SQL_STATE_DATA_EXCEPTION = "22000";
    public static final String SQL_STATE_FEATURE_NOT_SUPPORTED = "0A000";

    private ExceptionUtils() {
    }

    public static SQLException toSqlState(Exception cause) {
        return ExceptionUtils.toSqlState(null, cause);
    }

    public static SQLException toSqlState(String message, Exception cause) {
        String exceptionMessage;
        if (cause == null) {
            return new SQLException(message == null ? "Unknown client error" : message, SQL_STATE_CLIENT_ERROR);
        }
        String string = exceptionMessage = message == null ? cause.getMessage() : message;
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        if (cause instanceof ClientMisconfigurationException) {
            return new SQLException(exceptionMessage, SQL_STATE_CLIENT_ERROR, cause);
        }
        if (cause instanceof ConnectionInitiationException) {
            return new SQLException(exceptionMessage, SQL_STATE_CONNECTION_EXCEPTION, cause);
        }
        if (cause instanceof ServerException) {
            return new SQLException(exceptionMessage, SQL_STATE_DATA_EXCEPTION, cause);
        }
        if (cause instanceof ClientException) {
            return new SQLException(exceptionMessage, SQL_STATE_CLIENT_ERROR, cause);
        }
        return new SQLException(exceptionMessage, SQL_STATE_CLIENT_ERROR, cause);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause = throwable;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

