/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.DataTypeUtils;
import com.clickhouse.client.api.data_formats.ClickHouseBinaryFormatReader;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.data_formats.internal.NumberConverter;
import com.clickhouse.client.api.internal.MapUtils;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.NullValueException;
import com.clickhouse.client.api.query.POJOSetter;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseEnum;
import com.clickhouse.data.value.ClickHouseBitmap;
import com.clickhouse.data.value.ClickHouseGeoMultiPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoPointValue;
import com.clickhouse.data.value.ClickHouseGeoPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoRingValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBinaryFormatReader
implements ClickHouseBinaryFormatReader {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBinaryFormatReader.class);
    protected InputStream input;
    protected Map<String, Object> settings;
    protected BinaryStreamReader binaryStreamReader;
    private TableSchema schema;
    private ClickHouseColumn[] columns;
    private Map[] convertions;
    private volatile boolean hasNext = true;
    private volatile boolean initialState = true;
    protected Map<String, Object> currentRecord = new ConcurrentHashMap<String, Object>();
    protected Map<String, Object> nextRecord = new ConcurrentHashMap<String, Object>();
    protected AtomicBoolean nextRecordEmpty = new AtomicBoolean(true);

    protected AbstractBinaryFormatReader(InputStream inputStream, QuerySettings querySettings, TableSchema schema, BinaryStreamReader.ByteBufferAllocator byteBufferAllocator) {
        TimeZone timeZone;
        this.input = inputStream;
        this.settings = querySettings == null ? Collections.emptyMap() : new HashMap<String, Object>(querySettings.getAllSettings());
        Boolean useServerTimeZone = (Boolean)this.settings.get(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey());
        TimeZone timeZone2 = timeZone = useServerTimeZone == Boolean.TRUE && querySettings != null ? querySettings.getServerTimeZone() : (TimeZone)this.settings.get(ClientConfigProperties.USE_TIMEZONE.getKey());
        if (timeZone == null) {
            throw new ClientException("Time zone is not set. (useServerTimezone:" + useServerTimeZone + ")");
        }
        boolean jsonAsString = MapUtils.getFlag(this.settings, ClientConfigProperties.serverSetting("output_format_binary_write_json_as_string"), false);
        this.binaryStreamReader = new BinaryStreamReader(inputStream, timeZone, LOG, byteBufferAllocator, jsonAsString);
        if (schema != null) {
            this.setSchema(schema);
        }
    }

    public boolean readToPOJO(Map<String, POJOSetter> deserializers, Object obj) throws IOException {
        boolean firstColumn = true;
        for (ClickHouseColumn column : this.columns) {
            try {
                POJOSetter deserializer = deserializers.get(column.getColumnName());
                if (deserializer != null) {
                    deserializer.setValue(obj, this.binaryStreamReader, column);
                } else {
                    this.binaryStreamReader.skipValue(column);
                }
                firstColumn = false;
            }
            catch (EOFException e) {
                if (firstColumn) {
                    this.endReached();
                    return false;
                }
                throw e;
            }
            catch (Exception e) {
                throw new ClientException("Failed to put value of '" + column.getColumnName() + "' into POJO", e);
            }
        }
        return true;
    }

    public boolean readRecord(Map<String, Object> record) throws IOException {
        boolean firstColumn = true;
        for (ClickHouseColumn column : this.columns) {
            try {
                Object val = this.binaryStreamReader.readValue(column);
                if (val != null) {
                    record.put(column.getColumnName(), val);
                } else {
                    record.remove(column.getColumnName());
                }
                firstColumn = false;
            }
            catch (EOFException e) {
                if (firstColumn) {
                    this.endReached();
                    return false;
                }
                throw e;
            }
        }
        return true;
    }

    @Override
    public <T> T readValue(int colIndex) {
        if (colIndex < 1 || colIndex > this.getSchema().getColumns().size()) {
            throw new ClientException("Column index out of bounds: " + colIndex);
        }
        return (T)this.currentRecord.get(this.getSchema().columnIndexToName(colIndex));
    }

    @Override
    public <T> T readValue(String colName) {
        return (T)this.currentRecord.get(colName);
    }

    @Override
    public boolean hasNext() {
        if (this.initialState) {
            this.readNextRecord();
        }
        return this.hasNext;
    }

    protected void readNextRecord() {
        this.initialState = false;
        try {
            this.nextRecordEmpty.set(true);
            if (!this.readRecord(this.nextRecord)) {
                this.endReached();
            } else {
                this.nextRecordEmpty.compareAndSet(true, false);
            }
        }
        catch (IOException e) {
            this.endReached();
            throw new ClientException("Failed to read next row", e);
        }
    }

    @Override
    public Map<String, Object> next() {
        if (!this.hasNext) {
            return null;
        }
        if (!this.nextRecordEmpty.get()) {
            Map<String, Object> tmp = this.currentRecord;
            this.currentRecord = this.nextRecord;
            this.nextRecord = tmp;
            this.readNextRecord();
            return this.currentRecord;
        }
        try {
            if (this.readRecord(this.currentRecord)) {
                this.readNextRecord();
                return this.currentRecord;
            }
            this.currentRecord = null;
            return null;
        }
        catch (IOException e) {
            this.endReached();
            throw new ClientException("Failed to read row", e);
        }
    }

    protected void endReached() {
        this.initialState = false;
        this.hasNext = false;
    }

    protected void setSchema(TableSchema schema) {
        this.schema = schema;
        this.columns = schema.getColumns().toArray(new ClickHouseColumn[0]);
        this.convertions = new Map[this.columns.length];
        block3: for (int i = 0; i < this.columns.length; ++i) {
            ClickHouseColumn column = this.columns[i];
            switch (column.getDataType()) {
                case Int8: 
                case Int16: 
                case UInt8: 
                case Int32: 
                case UInt16: 
                case Int64: 
                case UInt32: 
                case Int128: 
                case UInt64: 
                case Int256: 
                case UInt128: 
                case UInt256: 
                case Float32: 
                case Float64: 
                case Decimal: 
                case Decimal32: 
                case Decimal64: 
                case Decimal128: 
                case Decimal256: 
                case Bool: 
                case String: 
                case Enum8: 
                case Enum16: {
                    this.convertions[i] = NumberConverter.NUMBER_CONVERTERS;
                    continue block3;
                }
                default: {
                    this.convertions[i] = Collections.emptyMap();
                }
            }
        }
    }

    public Map[] getConvertions() {
        return this.convertions;
    }

    @Override
    public TableSchema getSchema() {
        return this.schema;
    }

    @Override
    public String getString(String colName) {
        Object value = this.readValue(colName);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof ZonedDateTime) {
            ClickHouseDataType dataType = this.schema.getColumnByName(colName).getDataType();
            ZonedDateTime zdt = (ZonedDateTime)value;
            if (dataType == ClickHouseDataType.Date) {
                return zdt.format(DataTypeUtils.DATE_FORMATTER).toString();
            }
            return value.toString();
        }
        ClickHouseDataType dataType = this.schema.getColumnByName(colName).getDataType();
        if (dataType == ClickHouseDataType.Enum8 || dataType == ClickHouseDataType.Enum16) {
            ClickHouseEnum clickHouseEnum = this.schema.getColumnByName(colName).getEnumConstants();
            return clickHouseEnum.name(Integer.parseInt(value.toString()));
        }
        return value.toString();
    }

    @Override
    public String getString(int index) {
        return this.getString(this.schema.columnIndexToName(index));
    }

    private <T> T readNumberValue(String colName, NumberConverter.NumberType targetType) {
        int colIndex = this.schema.nameToIndex(colName);
        Function converter = (Function)this.convertions[colIndex].get((Object)targetType);
        if (converter != null) {
            T value = this.readValue(colName);
            if (value == null) {
                throw new NullValueException("Column " + colName + " has null value and it cannot be cast to " + targetType.getTypeName());
            }
            return (T)converter.apply(value);
        }
        throw new ClientException("Column " + colName + " " + this.columns[colIndex].getDataType().name() + " cannot be converted to " + targetType.getTypeName());
    }

    @Override
    public byte getByte(String colName) {
        return (Byte)this.readNumberValue(colName, NumberConverter.NumberType.Byte);
    }

    @Override
    public short getShort(String colName) {
        return (Short)this.readNumberValue(colName, NumberConverter.NumberType.Short);
    }

    @Override
    public int getInteger(String colName) {
        return (Integer)this.readNumberValue(colName, NumberConverter.NumberType.Int);
    }

    @Override
    public long getLong(String colName) {
        return (Long)this.readNumberValue(colName, NumberConverter.NumberType.Long);
    }

    @Override
    public float getFloat(String colName) {
        return ((Float)this.readNumberValue(colName, NumberConverter.NumberType.Float)).floatValue();
    }

    @Override
    public double getDouble(String colName) {
        return (Double)this.readNumberValue(colName, NumberConverter.NumberType.Double);
    }

    @Override
    public boolean getBoolean(String colName) {
        return (Boolean)this.readNumberValue(colName, NumberConverter.NumberType.Boolean);
    }

    @Override
    public BigInteger getBigInteger(String colName) {
        return (BigInteger)this.readNumberValue(colName, NumberConverter.NumberType.BigInteger);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) {
        return (BigDecimal)this.readNumberValue(colName, NumberConverter.NumberType.BigDecimal);
    }

    @Override
    public Instant getInstant(String colName) {
        int colIndex = this.schema.nameToIndex(colName);
        ClickHouseColumn column = this.schema.getColumns().get(colIndex);
        switch (column.getDataType()) {
            case Date: 
            case Date32: {
                LocalDate data = (LocalDate)this.readValue(colName);
                return data.atStartOfDay().toInstant(ZoneOffset.UTC);
            }
            case DateTime: 
            case DateTime64: {
                LocalDateTime dateTime = (LocalDateTime)this.readValue(colName);
                return dateTime.toInstant(column.getTimeZone().toZoneId().getRules().getOffset(dateTime));
            }
        }
        throw new ClientException("Column of type " + (Object)((Object)column.getDataType()) + " cannot be converted to Instant");
    }

    @Override
    public ZonedDateTime getZonedDateTime(String colName) {
        int colIndex = this.schema.nameToIndex(colName);
        ClickHouseColumn column = this.schema.getColumns().get(colIndex);
        switch (column.getDataType()) {
            case Date: 
            case Date32: 
            case DateTime: 
            case DateTime64: {
                return (ZonedDateTime)this.readValue(colName);
            }
        }
        throw new ClientException("Column of type " + (Object)((Object)column.getDataType()) + " cannot be converted to Instant");
    }

    @Override
    public Duration getDuration(String colName) {
        int colIndex = this.schema.nameToIndex(colName);
        ClickHouseColumn column = this.schema.getColumns().get(colIndex);
        BigInteger value = (BigInteger)this.readValue(colName);
        try {
            switch (column.getDataType()) {
                case IntervalYear: {
                    return Duration.of(value.longValue(), ChronoUnit.YEARS);
                }
                case IntervalQuarter: {
                    return Duration.of(value.longValue() * 3L, ChronoUnit.MONTHS);
                }
                case IntervalMonth: {
                    return Duration.of(value.longValue(), ChronoUnit.MONTHS);
                }
                case IntervalWeek: {
                    return Duration.of(value.longValue(), ChronoUnit.WEEKS);
                }
                case IntervalDay: {
                    return Duration.of(value.longValue(), ChronoUnit.DAYS);
                }
                case IntervalHour: {
                    return Duration.of(value.longValue(), ChronoUnit.HOURS);
                }
                case IntervalMinute: {
                    return Duration.of(value.longValue(), ChronoUnit.MINUTES);
                }
                case IntervalSecond: {
                    return Duration.of(value.longValue(), ChronoUnit.SECONDS);
                }
                case IntervalMicrosecond: {
                    return Duration.of(value.longValue(), ChronoUnit.MICROS);
                }
                case IntervalMillisecond: {
                    return Duration.of(value.longValue(), ChronoUnit.MILLIS);
                }
                case IntervalNanosecond: {
                    return Duration.of(value.longValue(), ChronoUnit.NANOS);
                }
            }
        }
        catch (ArithmeticException e) {
            throw new ClientException("Stored value is bigger then Long.MAX_VALUE and it cannot be converted to Duration without information loss", e);
        }
        throw new ClientException("Column of type " + (Object)((Object)column.getDataType()) + " cannot be converted to Duration");
    }

    @Override
    public Inet4Address getInet4Address(String colName) {
        return (Inet4Address)this.readValue(colName);
    }

    @Override
    public Inet6Address getInet6Address(String colName) {
        return (Inet6Address)this.readValue(colName);
    }

    @Override
    public UUID getUUID(String colName) {
        return (UUID)this.readValue(colName);
    }

    @Override
    public ClickHouseGeoPointValue getGeoPoint(String colName) {
        return ClickHouseGeoPointValue.of((double[])this.readValue(colName));
    }

    @Override
    public ClickHouseGeoRingValue getGeoRing(String colName) {
        return ClickHouseGeoRingValue.of((double[][])this.readValue(colName));
    }

    @Override
    public ClickHouseGeoPolygonValue getGeoPolygon(String colName) {
        return ClickHouseGeoPolygonValue.of((double[][][])this.readValue(colName));
    }

    @Override
    public ClickHouseGeoMultiPolygonValue getGeoMultiPolygon(String colName) {
        return ClickHouseGeoMultiPolygonValue.of((double[][][][])this.readValue(colName));
    }

    @Override
    public <T> List<T> getList(String colName) {
        try {
            BinaryStreamReader.ArrayValue array = (BinaryStreamReader.ArrayValue)this.readValue(colName);
            return array.asList();
        }
        catch (ClassCastException e) {
            throw new ClientException("Column is not of array type", e);
        }
    }

    private <T> T getPrimitiveArray(String colName) {
        try {
            BinaryStreamReader.ArrayValue array = (BinaryStreamReader.ArrayValue)this.readValue(colName);
            if (array.itemType.isPrimitive()) {
                return (T)array.array;
            }
            throw new ClientException("Array is not of primitive type");
        }
        catch (ClassCastException e) {
            throw new ClientException("Column is not of array type", e);
        }
    }

    @Override
    public byte[] getByteArray(String colName) {
        return (byte[])this.getPrimitiveArray(colName);
    }

    @Override
    public int[] getIntArray(String colName) {
        return (int[])this.getPrimitiveArray(colName);
    }

    @Override
    public long[] getLongArray(String colName) {
        return (long[])this.getPrimitiveArray(colName);
    }

    @Override
    public float[] getFloatArray(String colName) {
        return (float[])this.getPrimitiveArray(colName);
    }

    @Override
    public double[] getDoubleArray(String colName) {
        return (double[])this.getPrimitiveArray(colName);
    }

    @Override
    public boolean[] getBooleanArray(String colName) {
        return (boolean[])this.getPrimitiveArray(colName);
    }

    @Override
    public boolean hasValue(int colIndex) {
        return this.currentRecord.containsKey(this.getSchema().columnIndexToName(colIndex));
    }

    @Override
    public boolean hasValue(String colName) {
        this.getSchema().getColumnByName(colName);
        return this.currentRecord.containsKey(colName);
    }

    @Override
    public byte getByte(int index) {
        return this.getByte(this.schema.columnIndexToName(index));
    }

    @Override
    public short getShort(int index) {
        return this.getShort(this.schema.columnIndexToName(index));
    }

    @Override
    public int getInteger(int index) {
        return this.getInteger(this.schema.columnIndexToName(index));
    }

    @Override
    public long getLong(int index) {
        return this.getLong(this.schema.columnIndexToName(index));
    }

    @Override
    public float getFloat(int index) {
        return this.getFloat(this.schema.columnIndexToName(index));
    }

    @Override
    public double getDouble(int index) {
        return this.getDouble(this.schema.columnIndexToName(index));
    }

    @Override
    public boolean getBoolean(int index) {
        return this.getBoolean(this.schema.columnIndexToName(index));
    }

    @Override
    public BigInteger getBigInteger(int index) {
        return this.getBigInteger(this.schema.columnIndexToName(index));
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return this.getBigDecimal(this.schema.columnIndexToName(index));
    }

    @Override
    public Instant getInstant(int index) {
        return (Instant)this.readValue(index);
    }

    @Override
    public ZonedDateTime getZonedDateTime(int index) {
        return (ZonedDateTime)this.readValue(index);
    }

    @Override
    public Duration getDuration(int index) {
        return (Duration)this.readValue(index);
    }

    @Override
    public Inet4Address getInet4Address(int index) {
        return (Inet4Address)this.readValue(index);
    }

    @Override
    public Inet6Address getInet6Address(int index) {
        return (Inet6Address)this.readValue(index);
    }

    @Override
    public UUID getUUID(int index) {
        return (UUID)this.readValue(index);
    }

    @Override
    public ClickHouseGeoPointValue getGeoPoint(int index) {
        return (ClickHouseGeoPointValue)this.readValue(index);
    }

    @Override
    public ClickHouseGeoRingValue getGeoRing(int index) {
        return (ClickHouseGeoRingValue)this.readValue(index);
    }

    @Override
    public ClickHouseGeoPolygonValue getGeoPolygon(int index) {
        return (ClickHouseGeoPolygonValue)this.readValue(index);
    }

    @Override
    public ClickHouseGeoMultiPolygonValue getGeoMultiPolygon(int index) {
        return (ClickHouseGeoMultiPolygonValue)this.readValue(index);
    }

    @Override
    public <T> List<T> getList(int index) {
        return this.getList(this.schema.columnIndexToName(index));
    }

    @Override
    public byte[] getByteArray(int index) {
        return (byte[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public int[] getIntArray(int index) {
        return (int[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public long[] getLongArray(int index) {
        return (long[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public float[] getFloatArray(int index) {
        return (float[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public double[] getDoubleArray(int index) {
        return (double[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public boolean[] getBooleanArray(int index) {
        return (boolean[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public Object[] getTuple(int index) {
        return (Object[])this.readValue(index);
    }

    @Override
    public Object[] getTuple(String colName) {
        return (Object[])this.readValue(colName);
    }

    @Override
    public byte getEnum8(String colName) {
        return (Byte)this.readValue(colName);
    }

    @Override
    public byte getEnum8(int index) {
        return (Byte)this.readValue(index);
    }

    @Override
    public short getEnum16(String colName) {
        return (Short)this.readValue(colName);
    }

    @Override
    public short getEnum16(int index) {
        return (Short)this.readValue(index);
    }

    @Override
    public LocalDate getLocalDate(String colName) {
        Object value = this.readValue(colName);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDate();
        }
        return (LocalDate)value;
    }

    @Override
    public LocalDate getLocalDate(int index) {
        Object value = this.readValue(index);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDate();
        }
        return (LocalDate)value;
    }

    @Override
    public LocalDateTime getLocalDateTime(String colName) {
        Object value = this.readValue(colName);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDateTime();
        }
        return (LocalDateTime)value;
    }

    @Override
    public LocalDateTime getLocalDateTime(int index) {
        Object value = this.readValue(index);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDateTime();
        }
        return (LocalDateTime)value;
    }

    @Override
    public ClickHouseBitmap getClickHouseBitmap(String colName) {
        return (ClickHouseBitmap)this.readValue(colName);
    }

    @Override
    public ClickHouseBitmap getClickHouseBitmap(int index) {
        return (ClickHouseBitmap)this.readValue(index);
    }

    @Override
    public void close() throws Exception {
        this.input.close();
    }
}

