/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.api.Client;
import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.ClientFaultCause;
import com.clickhouse.client.api.ClientMisconfigurationException;
import com.clickhouse.client.api.ConnectionInitiationException;
import com.clickhouse.client.api.ConnectionReuseStrategy;
import com.clickhouse.client.api.ServerException;
import com.clickhouse.client.api.data_formats.internal.SerializerUtils;
import com.clickhouse.client.api.enums.ProxyType;
import com.clickhouse.client.api.internal.LZ4Entity;
import com.clickhouse.client.api.internal.MapUtils;
import com.clickhouse.client.internal.apache.hc.client5.http.ConnectTimeoutException;
import com.clickhouse.client.internal.apache.hc.client5.http.classic.methods.HttpPost;
import com.clickhouse.client.internal.apache.hc.client5.http.config.ConnectionConfig;
import com.clickhouse.client.internal.apache.hc.client5.http.config.RequestConfig;
import com.clickhouse.client.internal.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.clickhouse.client.internal.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import com.clickhouse.client.internal.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import com.clickhouse.client.internal.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import com.clickhouse.client.internal.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import com.clickhouse.client.internal.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import com.clickhouse.client.internal.apache.hc.client5.http.io.HttpClientConnectionManager;
import com.clickhouse.client.internal.apache.hc.client5.http.protocol.HttpClientContext;
import com.clickhouse.client.internal.apache.hc.client5.http.socket.ConnectionSocketFactory;
import com.clickhouse.client.internal.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import com.clickhouse.client.internal.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import com.clickhouse.client.internal.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import com.clickhouse.client.internal.apache.hc.core5.http.ClassicHttpResponse;
import com.clickhouse.client.internal.apache.hc.core5.http.ConnectionRequestTimeoutException;
import com.clickhouse.client.internal.apache.hc.core5.http.ContentType;
import com.clickhouse.client.internal.apache.hc.core5.http.Header;
import com.clickhouse.client.internal.apache.hc.core5.http.HttpEntity;
import com.clickhouse.client.internal.apache.hc.core5.http.HttpHost;
import com.clickhouse.client.internal.apache.hc.core5.http.HttpRequest;
import com.clickhouse.client.internal.apache.hc.core5.http.NoHttpResponseException;
import com.clickhouse.client.internal.apache.hc.core5.http.config.CharCodingConfig;
import com.clickhouse.client.internal.apache.hc.core5.http.config.Http1Config;
import com.clickhouse.client.internal.apache.hc.core5.http.config.RegistryBuilder;
import com.clickhouse.client.internal.apache.hc.core5.http.impl.io.DefaultHttpResponseParserFactory;
import com.clickhouse.client.internal.apache.hc.core5.http.io.SocketConfig;
import com.clickhouse.client.internal.apache.hc.core5.http.io.entity.EntityTemplate;
import com.clickhouse.client.internal.apache.hc.core5.http.protocol.HttpContext;
import com.clickhouse.client.internal.apache.hc.core5.io.CloseMode;
import com.clickhouse.client.internal.apache.hc.core5.io.IOCallback;
import com.clickhouse.client.internal.apache.hc.core5.net.URIBuilder;
import com.clickhouse.client.internal.apache.hc.core5.pool.PoolConcurrencyPolicy;
import com.clickhouse.client.internal.apache.hc.core5.pool.PoolReusePolicy;
import com.clickhouse.client.internal.apache.hc.core5.util.TimeValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAPIClientHelper {
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private static int ERROR_BODY_BUFFER_SIZE = 1024;
    private CloseableHttpClient httpClient;
    private Map<String, String> chConfiguration;
    private RequestConfig baseRequestConfig;
    private String proxyAuthHeaderValue;
    private final Set<ClientFaultCause> defaultRetryCauses;
    private String defaultUserAgent;
    private Object metricsRegistry;
    private long CONNECTION_INACTIVITY_CHECK = 5000L;
    private static final String ERROR_CODE_PREFIX_PATTERN = "Code: %d. DB::Exception:";
    private static final ContentType CONTENT_TYPE = ContentType.create(ContentType.TEXT_PLAIN.getMimeType(), "UTF-8");

    public HttpAPIClientHelper(Map<String, String> configuration, Object metricsRegistry, boolean initSslContext) {
        this.chConfiguration = configuration;
        this.metricsRegistry = metricsRegistry;
        this.httpClient = this.createHttpClient(initSslContext);
        RequestConfig.Builder reqConfBuilder = RequestConfig.custom();
        MapUtils.applyLong(this.chConfiguration, "connection_request_timeout", t -> reqConfBuilder.setConnectionRequestTimeout((long)t, TimeUnit.MILLISECONDS));
        this.baseRequestConfig = reqConfBuilder.build();
        boolean usingClientCompression = this.chConfiguration.getOrDefault(ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getKey(), "false").equalsIgnoreCase("true");
        boolean usingServerCompression = this.chConfiguration.getOrDefault(ClientConfigProperties.COMPRESS_SERVER_RESPONSE.getKey(), "false").equalsIgnoreCase("true");
        boolean useHttpCompression = this.chConfiguration.getOrDefault("client.use_http_compression", "false").equalsIgnoreCase("true");
        LOG.info("client compression: {}, server compression: {}, http compression: {}", new Object[]{usingClientCompression, usingServerCompression, useHttpCompression});
        this.defaultRetryCauses = SerializerUtils.parseEnumList(this.chConfiguration.get(ClientConfigProperties.CLIENT_RETRY_ON_FAILURE.getKey()), ClientFaultCause.class);
        if (this.defaultRetryCauses.contains((Object)ClientFaultCause.None)) {
            this.defaultRetryCauses.removeIf(c -> c != ClientFaultCause.None);
        }
        this.defaultUserAgent = this.buildDefaultUserAgent();
    }

    public SSLContext createSSLContext() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("Failed to create default SSL context", e);
        }
        ClickHouseSslContextProvider sslContextProvider = ClickHouseSslContextProvider.getProvider();
        String trustStorePath = this.chConfiguration.get(ClientConfigProperties.SSL_TRUST_STORE.getKey());
        if (trustStorePath != null) {
            try {
                sslContext = sslContextProvider.getSslContextFromKeyStore(trustStorePath, this.chConfiguration.get(ClientConfigProperties.SSL_KEY_STORE_PASSWORD.getKey()), this.chConfiguration.get(ClientConfigProperties.SSL_KEYSTORE_TYPE.getKey()));
            }
            catch (SSLException e) {
                throw new ClientMisconfigurationException("Failed to create SSL context from a keystore", e);
            }
        }
        if (this.chConfiguration.get(ClientConfigProperties.CA_CERTIFICATE.getKey()) != null || this.chConfiguration.get(ClientConfigProperties.SSL_CERTIFICATE.getKey()) != null || this.chConfiguration.get(ClientConfigProperties.SSL_KEY.getKey()) != null) {
            try {
                sslContext = sslContextProvider.getSslContextFromCerts(this.chConfiguration.get(ClientConfigProperties.SSL_CERTIFICATE.getKey()), this.chConfiguration.get(ClientConfigProperties.SSL_KEY.getKey()), this.chConfiguration.get(ClientConfigProperties.CA_CERTIFICATE.getKey()));
            }
            catch (SSLException e) {
                throw new ClientMisconfigurationException("Failed to create SSL context from certificates", e);
            }
        }
        return sslContext;
    }

    private ConnectionConfig createConnectionConfig() {
        ConnectionConfig.Builder connConfig = ConnectionConfig.custom();
        connConfig.setTimeToLive(MapUtils.getLong(this.chConfiguration, ClientConfigProperties.CONNECTION_TTL.getKey()), TimeUnit.MILLISECONDS);
        connConfig.setConnectTimeout(MapUtils.getLong(this.chConfiguration, ClientConfigProperties.CONNECTION_TIMEOUT.getKey()), TimeUnit.MILLISECONDS);
        connConfig.setValidateAfterInactivity(this.CONNECTION_INACTIVITY_CHECK, TimeUnit.MILLISECONDS);
        return connConfig.build();
    }

    private HttpClientConnectionManager basicConnectionManager(LayeredConnectionSocketFactory sslConnectionSocketFactory, SocketConfig socketConfig) {
        RegistryBuilder<ConnectionSocketFactory> registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", PlainConnectionSocketFactory.getSocketFactory());
        registryBuilder.register("https", sslConnectionSocketFactory);
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager(registryBuilder.build());
        connManager.setConnectionConfig(this.createConnectionConfig());
        connManager.setSocketConfig(socketConfig);
        return connManager;
    }

    private HttpClientConnectionManager poolConnectionManager(LayeredConnectionSocketFactory sslConnectionSocketFactory, SocketConfig socketConfig) {
        PoolingHttpClientConnectionManagerBuilder connMgrBuilder = PoolingHttpClientConnectionManagerBuilder.create().setPoolConcurrencyPolicy(PoolConcurrencyPolicy.LAX);
        ConnectionReuseStrategy connectionReuseStrategy = ConnectionReuseStrategy.valueOf(this.chConfiguration.get("connection_reuse_strategy"));
        switch (connectionReuseStrategy) {
            case LIFO: {
                connMgrBuilder.setConnPoolPolicy(PoolReusePolicy.LIFO);
                break;
            }
            case FIFO: {
                connMgrBuilder.setConnPoolPolicy(PoolReusePolicy.FIFO);
                break;
            }
            default: {
                throw new ClientMisconfigurationException("Unknown connection reuse strategy: " + (Object)((Object)connectionReuseStrategy));
            }
        }
        LOG.info("Connection reuse strategy: {}", (Object)connectionReuseStrategy);
        connMgrBuilder.setDefaultConnectionConfig(this.createConnectionConfig());
        connMgrBuilder.setMaxConnTotal(Integer.MAX_VALUE);
        MapUtils.applyInt(this.chConfiguration, ClientConfigProperties.HTTP_MAX_OPEN_CONNECTIONS.getKey(), connMgrBuilder::setMaxConnPerRoute);
        int networkBufferSize = MapUtils.getInt(this.chConfiguration, "client_network_buffer_size");
        ManagedHttpClientConnectionFactory connectionFactory = new ManagedHttpClientConnectionFactory(Http1Config.custom().setBufferSize(networkBufferSize).build(), CharCodingConfig.DEFAULT, DefaultHttpResponseParserFactory.INSTANCE);
        connMgrBuilder.setConnectionFactory(connectionFactory);
        connMgrBuilder.setSSLSocketFactory(sslConnectionSocketFactory);
        connMgrBuilder.setDefaultSocketConfig(socketConfig);
        PoolingHttpClientConnectionManager phccm = connMgrBuilder.build();
        if (this.metricsRegistry != null) {
            try {
                String mGroupName = this.chConfiguration.getOrDefault(ClientConfigProperties.METRICS_GROUP_NAME.getKey(), "ch-http-pool");
                Class<?> micrometerLoader = this.getClass().getClassLoader().loadClass("com.clickhouse.client.api.metrics.MicrometerLoader");
                Method applyMethod = micrometerLoader.getDeclaredMethod("applyPoolingMetricsBinder", Object.class, String.class, PoolingHttpClientConnectionManager.class);
                applyMethod.invoke(micrometerLoader, this.metricsRegistry, mGroupName, phccm);
            }
            catch (Exception e) {
                LOG.error("Failed to register metrics", (Throwable)e);
            }
        }
        return phccm;
    }

    public CloseableHttpClient createHttpClient(boolean initSslContext) {
        String proxyTypeVal;
        ProxyType proxyType;
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        SSLContext sslContext = initSslContext ? this.createSSLContext() : null;
        LayeredConnectionSocketFactory sslConnectionSocketFactory = sslContext == null ? new DummySSLConnectionSocketFactory() : new SSLConnectionSocketFactory(sslContext);
        SocketConfig.Builder soCfgBuilder = SocketConfig.custom();
        MapUtils.applyInt(this.chConfiguration, ClientConfigProperties.SOCKET_OPERATION_TIMEOUT.getKey(), t -> soCfgBuilder.setSoTimeout((int)t, TimeUnit.MILLISECONDS));
        MapUtils.applyInt(this.chConfiguration, ClientConfigProperties.SOCKET_RCVBUF_OPT.getKey(), soCfgBuilder::setRcvBufSize);
        MapUtils.applyInt(this.chConfiguration, ClientConfigProperties.SOCKET_SNDBUF_OPT.getKey(), soCfgBuilder::setSndBufSize);
        MapUtils.applyInt(this.chConfiguration, ClientConfigProperties.SOCKET_LINGER_OPT.getKey(), v -> soCfgBuilder.setSoLinger((int)v, TimeUnit.SECONDS));
        if (MapUtils.getFlag(this.chConfiguration, ClientConfigProperties.SOCKET_TCP_NO_DELAY_OPT.getKey(), false)) {
            soCfgBuilder.setTcpNoDelay(true);
        }
        String proxyHost = this.chConfiguration.get(ClientConfigProperties.PROXY_HOST.getKey());
        String proxyPort = this.chConfiguration.get(ClientConfigProperties.PROXY_PORT.getKey());
        HttpHost proxy = null;
        if (proxyHost != null && proxyPort != null) {
            proxy = new HttpHost(proxyHost, Integer.parseInt(proxyPort));
        }
        ProxyType proxyType2 = proxyType = (proxyTypeVal = this.chConfiguration.get(ClientConfigProperties.PROXY_TYPE.getKey())) == null ? null : ProxyType.valueOf(proxyTypeVal);
        if (proxyType == ProxyType.HTTP) {
            clientBuilder.setProxy(proxy);
            if (this.chConfiguration.containsKey("proxy_password") && this.chConfiguration.containsKey("proxy_user")) {
                this.proxyAuthHeaderValue = "Basic " + Base64.getEncoder().encodeToString((this.chConfiguration.get("proxy_user") + ":" + this.chConfiguration.get("proxy_password")).getBytes());
            }
        } else if (proxyType == ProxyType.SOCKS) {
            soCfgBuilder.setSocksProxyAddress(new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
        }
        if (this.chConfiguration.getOrDefault("client.http.cookies_enabled", "true").equalsIgnoreCase("false")) {
            clientBuilder.disableCookieManagement();
        }
        SocketConfig socketConfig = soCfgBuilder.build();
        boolean isConnectionPooling = MapUtils.getFlag(this.chConfiguration, "connection_pool_enabled");
        if (isConnectionPooling) {
            clientBuilder.setConnectionManager(this.poolConnectionManager(sslConnectionSocketFactory, socketConfig));
        } else {
            clientBuilder.setConnectionManager(this.basicConnectionManager(sslConnectionSocketFactory, socketConfig));
        }
        long keepAliveTimeout = MapUtils.getLong(this.chConfiguration, ClientConfigProperties.HTTP_KEEP_ALIVE_TIMEOUT.getKey());
        if (keepAliveTimeout > 0L) {
            clientBuilder.setKeepAliveStrategy((response, context) -> TimeValue.ofMilliseconds(keepAliveTimeout));
        }
        return clientBuilder.build();
    }

    public Exception readError(ClassicHttpResponse httpResponse) {
        ServerException serverException;
        block13: {
            int serverCode = HttpAPIClientHelper.getHeaderInt(httpResponse.getFirstHeader("X-ClickHouse-Exception-Code"), 0);
            InputStream body = httpResponse.getEntity().getContent();
            try {
                int rBytes;
                byte[] buffer = new byte[ERROR_BODY_BUFFER_SIZE];
                byte[] lookUpStr = String.format(ERROR_CODE_PREFIX_PATTERN, serverCode).getBytes(StandardCharsets.UTF_8);
                StringBuilder msgBuilder = new StringBuilder();
                boolean found = false;
                while ((rBytes = body.read(buffer)) != -1) {
                    for (int i = 0; i < rBytes; ++i) {
                        if (buffer[i] != lookUpStr[0]) continue;
                        found = true;
                        for (int j = 1; j < Math.min(rBytes - i, lookUpStr.length); ++j) {
                            if (buffer[i + j] == lookUpStr[j]) continue;
                            found = false;
                            break;
                        }
                        if (!found) continue;
                        msgBuilder.append(new String(buffer, i, rBytes - i, StandardCharsets.UTF_8));
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                while ((rBytes = body.read(buffer)) != -1) {
                    msgBuilder.append(new String(buffer, 0, rBytes, StandardCharsets.UTF_8));
                }
                String msg = msgBuilder.toString().replaceAll("\\s+", " ").replaceAll("\\\\n", " ").replaceAll("\\\\/", "/");
                if (msg.trim().isEmpty()) {
                    msg = String.format(ERROR_CODE_PREFIX_PATTERN, serverCode) + " <Unreadable error message> (transport error: " + httpResponse.getCode() + ")";
                }
                serverException = new ServerException(serverCode, msg, httpResponse.getCode());
                if (body == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Failed to read error message", (Throwable)e);
                    return new ServerException(serverCode, String.format(ERROR_CODE_PREFIX_PATTERN, serverCode) + " <Unreadable error message> (transport error: " + httpResponse.getCode() + ")", httpResponse.getCode());
                }
            }
            body.close();
        }
        return serverException;
    }

    public ClassicHttpResponse executeRequest(ClickHouseNode server, Map<String, Object> requestConfig, IOCallback<OutputStream> writeCallback) throws IOException {
        URI uri;
        if (requestConfig == null) {
            requestConfig = Collections.emptyMap();
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(server.getBaseUri());
            this.addQueryParams(uriBuilder, this.chConfiguration, requestConfig);
            uri = uriBuilder.normalizeSyntax().build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpPost req = new HttpPost(uri);
        this.addHeaders(req, this.chConfiguration, requestConfig);
        boolean clientCompression = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getKey());
        boolean useHttpCompression = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.USE_HTTP_COMPRESSION.getKey());
        boolean appCompressedData = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.APP_COMPRESSED_DATA.getKey());
        RequestConfig httpReqConfig = RequestConfig.copy(this.baseRequestConfig).build();
        req.setConfig(httpReqConfig);
        req.setEntity(this.wrapRequestEntity(new EntityTemplate(-1L, CONTENT_TYPE, null, writeCallback), clientCompression, useHttpCompression, appCompressedData));
        HttpClientContext context = HttpClientContext.create();
        try {
            ClassicHttpResponse httpResponse = this.httpClient.executeOpen(null, req, context);
            boolean serverCompression = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.COMPRESS_SERVER_RESPONSE.getKey());
            httpResponse.setEntity(this.wrapResponseEntity(httpResponse.getEntity(), httpResponse.getCode(), serverCompression, useHttpCompression));
            if (httpResponse.getCode() == 407) {
                throw new ClientMisconfigurationException("Proxy authentication required. Please check your proxy settings.");
            }
            if (httpResponse.getCode() == 502) {
                httpResponse.close();
                throw new ClientException("Server returned '502 Bad gateway'. Check network and proxy settings.");
            }
            if (httpResponse.getCode() >= 400 || httpResponse.containsHeader("X-ClickHouse-Exception-Code")) {
                try {
                    throw this.readError(httpResponse);
                }
                catch (Throwable throwable) {
                    httpResponse.close();
                    throw throwable;
                }
            }
            return httpResponse;
        }
        catch (UnknownHostException e) {
            LOG.warn("Host '{}' unknown", (Object)server.getHost());
            throw new ClientException("Unknown host", e);
        }
        catch (ConnectException | NoRouteToHostException e) {
            LOG.warn("Failed to connect to '{}': {}", (Object)server.getHost(), (Object)e.getMessage());
            throw new ClientException("Failed to connect", e);
        }
        catch (ClientException | ServerException | ConnectionRequestTimeoutException | NoHttpResponseException | SocketTimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Failed to execute request", e);
        }
    }

    private void addHeaders(HttpPost req, Map<String, String> chConfig, Map<String, Object> requestConfig) {
        req.addHeader("Content-Type", CONTENT_TYPE.getMimeType());
        if (requestConfig.containsKey(ClientConfigProperties.INPUT_OUTPUT_FORMAT.getKey())) {
            req.addHeader("X-ClickHouse-Format", requestConfig.get(ClientConfigProperties.INPUT_OUTPUT_FORMAT.getKey()));
        }
        if (requestConfig.containsKey(ClientConfigProperties.QUERY_ID.getKey())) {
            req.addHeader("X-ClickHouse-Query-Id", requestConfig.get(ClientConfigProperties.QUERY_ID.getKey()).toString());
        }
        if (requestConfig.containsKey(ClientConfigProperties.DATABASE.getKey())) {
            req.addHeader("X-ClickHouse-Database", requestConfig.get(ClientConfigProperties.DATABASE.getKey()));
        } else {
            req.addHeader("X-ClickHouse-Database", chConfig.get(ClientConfigProperties.DATABASE.getKey()));
        }
        if (MapUtils.getFlag(chConfig, "ssl_authentication", false)) {
            req.addHeader("X-ClickHouse-User", chConfig.get(ClientConfigProperties.USER.getKey()));
            req.addHeader("x-clickhouse-ssl-certificate-auth", "on");
        } else if (chConfig.getOrDefault(ClientConfigProperties.HTTP_USE_BASIC_AUTH.getKey(), "true").equalsIgnoreCase("true")) {
            req.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((chConfig.get(ClientConfigProperties.USER.getKey()) + ":" + chConfig.get(ClientConfigProperties.PASSWORD.getKey())).getBytes(StandardCharsets.UTF_8)));
        } else {
            req.addHeader("X-ClickHouse-User", chConfig.get(ClientConfigProperties.USER.getKey()));
            req.addHeader("X-ClickHouse-Key", chConfig.get(ClientConfigProperties.PASSWORD.getKey()));
        }
        if (this.proxyAuthHeaderValue != null) {
            req.addHeader("Proxy-Authorization", this.proxyAuthHeaderValue);
        }
        boolean clientCompression = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getKey());
        boolean serverCompression = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.COMPRESS_SERVER_RESPONSE.getKey());
        boolean useHttpCompression = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.USE_HTTP_COMPRESSION.getKey());
        boolean appCompressedData = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.APP_COMPRESSED_DATA.getKey());
        if (useHttpCompression) {
            if (serverCompression) {
                req.addHeader("Accept-Encoding", "lz4");
            }
            if (clientCompression && !appCompressedData) {
                req.addHeader("Content-Encoding", "lz4");
            }
        }
        for (Map.Entry<String, String> entry : chConfig.entrySet()) {
            if (!entry.getKey().startsWith("http_header_")) continue;
            req.setHeader(entry.getKey().substring("http_header_".length()), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : requestConfig.entrySet()) {
            if (!entry.getKey().startsWith("http_header_")) continue;
            req.setHeader(entry.getKey().substring("http_header_".length()), entry.getValue().toString());
        }
        if (req.containsHeader("Authorization") && (req.containsHeader("X-ClickHouse-User") || req.containsHeader("X-ClickHouse-Key"))) {
            req.removeHeaders("X-ClickHouse-User");
            req.removeHeaders("X-ClickHouse-Key");
        }
        this.correctUserAgentHeader(req, requestConfig);
    }

    private void addQueryParams(URIBuilder req, Map<String, String> chConfig, Map<String, Object> requestConfig) {
        for (Map.Entry<String, String> entry : chConfig.entrySet()) {
            if (!entry.getKey().startsWith("clickhouse_setting_")) continue;
            req.addParameter(entry.getKey().substring("clickhouse_setting_".length()), entry.getValue());
        }
        if (requestConfig.containsKey(ClientConfigProperties.QUERY_ID.getKey())) {
            req.addParameter("query_id", requestConfig.get(ClientConfigProperties.QUERY_ID.getKey()).toString());
        }
        if (requestConfig.containsKey("statement_params")) {
            Map params = (Map)requestConfig.get("statement_params");
            for (Map.Entry entry : params.entrySet()) {
                req.addParameter("param_" + (String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        boolean clientCompression = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getKey());
        boolean serverCompression = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.COMPRESS_SERVER_RESPONSE.getKey());
        boolean bl = MapUtils.getFlag(requestConfig, this.chConfiguration, ClientConfigProperties.USE_HTTP_COMPRESSION.getKey());
        if (bl) {
            req.addParameter("enable_http_compression", "1");
        } else {
            if (serverCompression) {
                req.addParameter("compress", "1");
            }
            if (clientCompression) {
                req.addParameter("decompress", "1");
            }
        }
        Collection sessionRoles = requestConfig.getOrDefault(ClientConfigProperties.SESSION_DB_ROLES.getKey(), ClientConfigProperties.valuesFromCommaSeparated(this.chConfiguration.getOrDefault(ClientConfigProperties.SESSION_DB_ROLES.getKey(), "")));
        if (!sessionRoles.isEmpty()) {
            sessionRoles.forEach(r -> req.addParameter("role", (String)r));
        }
        for (Map.Entry<String, Object> entry : requestConfig.entrySet()) {
            if (!entry.getKey().startsWith("clickhouse_setting_")) continue;
            req.addParameter(entry.getKey().substring("clickhouse_setting_".length()), entry.getValue().toString());
        }
    }

    private HttpEntity wrapRequestEntity(HttpEntity httpEntity, boolean clientCompression, boolean useHttpCompression, boolean appControlledCompression) {
        LOG.debug("client compression: {}, http compression: {}", (Object)clientCompression, (Object)useHttpCompression);
        if (clientCompression && !appControlledCompression) {
            return new LZ4Entity(httpEntity, useHttpCompression, false, true, MapUtils.getInt(this.chConfiguration, "compression.lz4.uncompressed_buffer_size"), false);
        }
        return httpEntity;
    }

    private HttpEntity wrapResponseEntity(HttpEntity httpEntity, int httpStatus, boolean serverCompression, boolean useHttpCompression) {
        LOG.debug("server compression: {}, http compression: {}", (Object)serverCompression, (Object)useHttpCompression);
        if (serverCompression) {
            switch (httpStatus) {
                case 200: 
                case 201: 
                case 202: 
                case 204: 
                case 205: 
                case 206: 
                case 304: 
                case 400: 
                case 404: 
                case 500: {
                    return new LZ4Entity(httpEntity, useHttpCompression, true, false, MapUtils.getInt(this.chConfiguration, "compression.lz4.uncompressed_buffer_size"), true);
                }
            }
        }
        return httpEntity;
    }

    public static int getHeaderInt(Header header, int defaultValue) {
        return HttpAPIClientHelper.getHeaderVal(header, defaultValue, Integer::parseInt);
    }

    public static String getHeaderVal(Header header, String defaultValue) {
        return HttpAPIClientHelper.getHeaderVal(header, defaultValue, Function.identity());
    }

    public static <T> T getHeaderVal(Header header, T defaultValue, Function<String, T> converter) {
        if (header == null) {
            return defaultValue;
        }
        return converter.apply(header.getValue());
    }

    public boolean shouldRetry(Throwable ex, Map<String, Object> requestSettings) {
        Set<ClientFaultCause> retryCauses = requestSettings.getOrDefault(ClientConfigProperties.CLIENT_RETRY_ON_FAILURE.getKey(), this.defaultRetryCauses);
        if (retryCauses.contains((Object)ClientFaultCause.None)) {
            return false;
        }
        if (ex instanceof NoHttpResponseException || ex.getCause() instanceof NoHttpResponseException) {
            return retryCauses.contains((Object)ClientFaultCause.NoHttpResponse);
        }
        if (ex instanceof ConnectException || ex instanceof ConnectTimeoutException || ex.getCause() instanceof ConnectException || ex.getCause() instanceof ConnectTimeoutException) {
            return retryCauses.contains((Object)ClientFaultCause.ConnectTimeout);
        }
        if (ex instanceof ConnectionRequestTimeoutException || ex.getCause() instanceof ConnectionRequestTimeoutException) {
            return retryCauses.contains((Object)ClientFaultCause.ConnectionRequestTimeout);
        }
        if (ex instanceof SocketTimeoutException || ex.getCause() instanceof SocketTimeoutException) {
            return retryCauses.contains((Object)ClientFaultCause.SocketTimeout);
        }
        return false;
    }

    public RuntimeException wrapException(String message, Exception cause) {
        if (cause instanceof ClientException || cause instanceof ServerException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof ConnectionRequestTimeoutException || cause instanceof NoHttpResponseException || cause instanceof ConnectTimeoutException || cause instanceof ConnectException) {
            return new ConnectionInitiationException(message, cause);
        }
        return new ClientException(message, cause);
    }

    public static Map<String, String> parseUrlParameters(URL url) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String path = url.getPath();
            path = path.substring(path.indexOf(47) + 1);
            LOG.debug("path: {}", (Object)path);
            if (!path.trim().isEmpty()) {
                params.put("database", path);
            } else {
                params.put("database", "default");
            }
            String query = url.getQuery();
            if (query != null) {
                for (String pair : query.split("&")) {
                    int idx = pair.indexOf("=");
                    if (idx <= 0) continue;
                    params.put(pair.substring(0, idx), pair.substring(idx + 1));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse URL parameters", (Throwable)e);
        }
        return params;
    }

    private void correctUserAgentHeader(HttpRequest request, Map<String, Object> requestConfig) {
        String reqClientName;
        Header userAgentHeader = request.getLastHeader("User-Agent");
        request.removeHeaders("User-Agent");
        String clientName = this.chConfiguration.getOrDefault(ClientConfigProperties.CLIENT_NAME.getKey(), "");
        if (requestConfig != null && (reqClientName = (String)requestConfig.get(ClientConfigProperties.CLIENT_NAME.getKey())) != null && !reqClientName.isEmpty()) {
            clientName = reqClientName;
        }
        String userAgentValue = this.defaultUserAgent;
        if (userAgentHeader == null && clientName != null && !clientName.isEmpty()) {
            userAgentValue = clientName + " " + this.defaultUserAgent;
        } else if (userAgentHeader != null) {
            userAgentValue = userAgentHeader.getValue() + " " + this.defaultUserAgent;
        }
        request.setHeader("User-Agent", userAgentValue);
    }

    private String buildDefaultUserAgent() {
        StringBuilder userAgent = new StringBuilder();
        userAgent.append("clickhouse-java-v2/");
        String clientVersion = Client.clientVersion;
        userAgent.append(clientVersion);
        userAgent.append(" (");
        userAgent.append(System.getProperty("os.name"));
        userAgent.append("; ");
        userAgent.append("jvm:").append(System.getProperty("java.version"));
        userAgent.append("; ");
        userAgent.setLength(userAgent.length() - 2);
        userAgent.append(')');
        try {
            String httpClientVersion = this.httpClient.getClass().getPackage().getImplementationVersion();
            if (Objects.equals(this.httpClient.getClass().getPackage().getImplementationTitle(), this.getClass().getPackage().getImplementationTitle())) {
                httpClientVersion = "unknown";
                try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("client-v2-version.properties");){
                    Properties p = new Properties();
                    p.load(in);
                    String tmp = p.getProperty("apache.http.client.version");
                    if (tmp != null && !tmp.isEmpty() && !tmp.equals("${apache.httpclient.version}")) {
                        httpClientVersion = tmp;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            userAgent.append(" ").append("Apache-HttpClient").append('/').append(httpClientVersion);
        }
        catch (Exception e) {
            LOG.info("failed to construct http client version string");
        }
        return userAgent.toString();
    }

    public void close() {
        this.httpClient.close(CloseMode.IMMEDIATE);
    }

    private static class DummySSLConnectionSocketFactory
    implements LayeredConnectionSocketFactory {
        private DummySSLConnectionSocketFactory() {
        }

        @Override
        public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
            return null;
        }

        @Override
        public Socket createSocket(HttpContext context) throws IOException {
            return null;
        }

        @Override
        public Socket connectSocket(TimeValue connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            return null;
        }
    }
}

