/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataUpdater;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.stream.AbstractByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class WrappedInputStream
extends AbstractByteArrayInputStream {
    private final InputStream in;

    @Override
    protected int updateBuffer() throws IOException {
        int read;
        this.position = 0;
        if (this.closed) {
            this.limit = 0;
            return 0;
        }
        int off = 0;
        for (int len = this.buffer.length; len > 0 && (read = this.in.read(this.buffer, off, len)) != -1; len -= read) {
            off += read;
        }
        if (this.copyTo != null) {
            this.copyTo.write(this.buffer, 0, off);
        }
        this.limit = off;
        return this.limit - this.position;
    }

    public WrappedInputStream(ClickHousePassThruStream stream, InputStream input, int bufferSize, Runnable postCloseAction) {
        super(stream, null, postCloseAction);
        this.in = ClickHouseChecker.nonNull(input, "InputStream");
        this.buffer = new byte[ClickHouseDataConfig.getBufferSize(bufferSize)];
        this.position = 0;
        this.limit = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.in.close();
        }
        finally {
            super.close();
        }
    }

    @Override
    public ClickHouseByteBuffer readCustom(ClickHouseDataUpdater reader) throws IOException {
        if (reader == null) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int offset = this.position;
        int length = 0;
        boolean more = true;
        while (more) {
            int remain = this.limit - this.position;
            if (remain < 1) {
                this.closeQuietly();
                more = false;
                continue;
            }
            int read = reader.update(this.buffer, this.position, this.limit);
            if (read == -1) {
                byte[] bytes = new byte[this.limit];
                System.arraycopy(this.buffer, this.position, bytes, this.position, remain);
                length += remain;
                this.position = this.limit;
                list.add(bytes);
                if (this.updateBuffer() >= 1) continue;
                this.closeQuietly();
                more = false;
                continue;
            }
            length += read;
            this.position += read;
            list.add(this.buffer);
            more = false;
        }
        return this.byteBuffer.update(list, offset, length);
    }
}

