/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseRequestManager;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseProxyType;
import com.clickhouse.client.http.ClickHouseHttpClient;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseByteUtils;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseExternalTable;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class ClickHouseHttpConnection
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseHttpConnection.class);
    private static final byte[] HEADER_CONTENT_DISPOSITION = "content-disposition: form-data; name=\"".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HEADER_OCTET_STREAM = "content-type: application/octet-stream\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HEADER_BINARY_ENCODING = "content-transfer-encoding: binary\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ERROR_MSG_PREFIX = "ode: ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] DOUBLE_DASH = new byte[]{45, 45};
    private static final byte[] END_OF_NAME = new byte[]{34, 13, 10};
    private static final byte[] LINE_PREFIX = new byte[]{13, 10, 45, 45};
    private static final byte[] LINE_SUFFIX = new byte[]{13, 10};
    private static final byte[] SUFFIX_QUERY = "query\"\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SUFFIX_FORMAT = "_format\"\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SUFFIX_STRUCTURE = "_structure\"\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SUFFIX_FILENAME = "\"; filename=\"".getBytes(StandardCharsets.US_ASCII);
    private static final HashSet<String> processedSettings = new HashSet<String>(Arrays.asList("_set_roles_stmt", ClickHouseClientOption.MAX_RESULT_ROWS.getKey()));
    protected final ClickHouseNode server;
    protected final ClickHouseRequestManager rm;
    protected final ClickHouseConfig config;
    protected final Map<String, String> defaultHeaders;
    protected final String url;

    private static StringBuilder appendQueryParameter(StringBuilder builder, String key, String value) {
        return builder.append(ClickHouseHttpConnection.urlEncode(key, StandardCharsets.UTF_8)).append('=').append(ClickHouseHttpConnection.urlEncode(value, StandardCharsets.UTF_8)).append('&');
    }

    static String urlEncode(String str, Charset charset) {
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try {
            return URLEncoder.encode(str, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static String buildQueryParams(ClickHouseRequest<?> request, Map<String, Serializable> additionalParams) {
        Optional<String> optionalValue;
        String comment;
        Serializable value;
        if (request == null) {
            return "";
        }
        if (additionalParams == null) {
            additionalParams = Collections.emptyMap();
        }
        ClickHouseConfig config = request.getConfig();
        StringBuilder builder = new StringBuilder();
        Map<String, String> customParams = ClickHouseOption.toKeyValuePairs(config.getStrOption(ClickHouseHttpOption.CUSTOM_PARAMS));
        for (Map.Entry<String, String> cp : customParams.entrySet()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, cp.getKey(), cp.getValue());
        }
        ClickHouseInputStream chIn = request.getInputStream().orElse(null);
        if (chIn != null && chIn.getUnderlyingStream().hasInput()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "query", request.getStatements(false).get(0));
        }
        if (config.isRequestCompressed() && config.getRequestCompressAlgorithm() == ClickHouseCompression.LZ4) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "decompress", "1");
        }
        if (config.isResponseCompressed()) {
            if (config.getResponseCompressAlgorithm() == ClickHouseCompression.LZ4) {
                ClickHouseHttpConnection.appendQueryParameter(builder, "compress", "1");
            } else {
                ClickHouseHttpConnection.appendQueryParameter(builder, "enable_http_compression", "1");
            }
        }
        Map<String, Serializable> settings = request.getSettings();
        List<String> stmts = request.getStatements(false);
        String settingKey = ClickHouseClientOption.MAX_EXECUTION_TIME.getKey();
        if (config.getMaxExecutionTime() > 0 && !settings.containsKey(settingKey)) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, String.valueOf(config.getMaxExecutionTime()));
        }
        settingKey = ClickHouseClientOption.MAX_RESULT_ROWS.getKey();
        boolean hasRequestSetting = settings.containsKey(settingKey);
        if (config.getMaxResultRows() > 0L && !hasRequestSetting) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, String.valueOf(config.getMaxResultRows()));
        } else if (hasRequestSetting) {
            value = settings.get(settingKey);
            if (value instanceof Number && ((Number)value).longValue() > 0L) {
                ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, String.valueOf(value));
            } else if (value instanceof String && !((String)((Object)value)).isEmpty() && !"0".equals(value)) {
                ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, (String)((Object)value));
            }
        }
        if (config.hasOption(ClickHouseClientOption.RESULT_OVERFLOW_MODE)) {
            ClickHouseHttpConnection.appendQueryParameter(builder, ClickHouseClientOption.RESULT_OVERFLOW_MODE.getKey(), config.getStrOption(ClickHouseClientOption.RESULT_OVERFLOW_MODE));
        }
        settingKey = "log_comment";
        if (!stmts.isEmpty() && config.getBoolOption(ClickHouseClientOption.LOG_LEADING_COMMENT) && !settings.containsKey(settingKey) && !(comment = ClickHouseUtils.getLeadingComment(stmts.get(0))).isEmpty()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, comment);
        }
        if (!settings.containsKey(settingKey = "extremes")) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, "0");
        }
        if (additionalParams.containsKey("_roles")) {
            value = additionalParams.get("_roles");
            Set roles = !(value instanceof Set) ? Collections.emptySet() : (Set)((Object)value);
            roles.forEach(role -> ClickHouseHttpConnection.appendQueryParameter(builder, "role", role));
        }
        if ((optionalValue = request.getSessionId()).isPresent()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, ClickHouseClientOption.SESSION_ID.getKey(), optionalValue.get());
            if (config.isSessionCheck()) {
                ClickHouseHttpConnection.appendQueryParameter(builder, ClickHouseClientOption.SESSION_CHECK.getKey(), "1");
            }
            if (config.getSessionTimeout() > 0) {
                ClickHouseHttpConnection.appendQueryParameter(builder, ClickHouseClientOption.SESSION_TIMEOUT.getKey(), String.valueOf(config.getSessionTimeout()));
            }
        }
        if ((optionalValue = request.getQueryId()).isPresent()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "query_id", optionalValue.get());
        }
        for (Map.Entry<String, Serializable> entry : settings.entrySet()) {
            if (processedSettings.contains(entry.getKey())) continue;
            ClickHouseHttpConnection.appendQueryParameter(builder, entry.getKey(), String.valueOf(entry.getValue()));
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    static String buildUrl(String baseUrl, ClickHouseRequest<?> request, Map<String, Serializable> additionalParams) {
        String query;
        StringBuilder builder = new StringBuilder().append(baseUrl);
        String context = "/";
        if (!ClickHouseChecker.isNullOrEmpty(context)) {
            char ch;
            char prev = '/';
            int len = context.length();
            for (int i = 0; i < len && (ch = context.charAt(i)) != '?' && ch != '#'; ++i) {
                if (ch != '/' || ch != prev) {
                    builder.append(ch);
                }
                prev = ch;
            }
        }
        if (!(query = ClickHouseHttpConnection.buildQueryParams(request, additionalParams)).isEmpty()) {
            builder.append('?').append(query);
        }
        return builder.toString();
    }

    protected static Map<String, String> createDefaultHeaders(ClickHouseConfig config, ClickHouseNode server, String userAgent, String referer) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        boolean hasAuthorizationHeader = false;
        for (Map.Entry<String, String> header : ClickHouseOption.toKeyValuePairs(config.getStrOption(ClickHouseHttpOption.CUSTOM_HEADERS)).entrySet()) {
            String name = header.getKey().toLowerCase(Locale.ROOT);
            String value = header.getValue();
            if (value == null) continue;
            if ("authorization".equals(name)) {
                hasAuthorizationHeader = true;
            }
            map.put(name, value);
        }
        if (!ClickHouseChecker.isNullOrEmpty(referer)) {
            map.put("referer", referer);
        }
        map.put("accept", "*/*");
        if (!config.getBoolOption(ClickHouseHttpOption.KEEP_ALIVE)) {
            map.put("connection", "Close");
        }
        map.put("user-agent", !ClickHouseChecker.isNullOrEmpty(userAgent) ? userAgent : config.getClientName());
        ClickHouseCredentials credentials = config.getDefaultCredentials();
        if (credentials.useAccessToken()) {
            map.put("authorization", credentials.getAccessToken());
        } else if (!hasAuthorizationHeader) {
            if (config.isSsl() && !ClickHouseChecker.isNullOrEmpty(config.getSslCert())) {
                map.put("X-ClickHouse-User", credentials.getUserName());
                map.put("x-clickhouse-ssl-certificate-auth", "on");
            } else {
                boolean useBasicAuthentication = config.getBoolOption(ClickHouseHttpOption.USE_BASIC_AUTHENTICATION);
                if (useBasicAuthentication) {
                    String password = credentials.getPassword() == null ? "" : credentials.getPassword();
                    map.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((credentials.getUserName() + ":" + password).getBytes(StandardCharsets.UTF_8)));
                } else {
                    map.put("X-ClickHouse-User", credentials.getUserName());
                    map.put("X-ClickHouse-Key", credentials.getPassword());
                }
            }
        }
        String database = server.getDatabase(config);
        if (!ClickHouseChecker.isNullOrEmpty(database)) {
            map.put("x-clickhouse-database", database);
        }
        map.put("x-clickhouse-format", config.getFormat().name());
        if (config.isResponseCompressed()) {
            map.put("accept-encoding", config.getResponseCompressAlgorithm().encoding());
        }
        if (config.isRequestCompressed() && config.getRequestCompressAlgorithm() != ClickHouseCompression.LZ4) {
            map.put("content-encoding", config.getRequestCompressAlgorithm().encoding());
        }
        return map;
    }

    protected static Proxy getProxy(ClickHouseConfig config) {
        Proxy proxy;
        ClickHouseProxyType proxyType = config.getProxyType();
        switch (proxyType) {
            case HTTP: {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxyHost(), config.getProxyPort()));
                break;
            }
            case DIRECT: {
                proxy = Proxy.NO_PROXY;
                break;
            }
            case SOCKS: {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(config.getProxyHost(), config.getProxyPort()));
                break;
            }
            default: {
                proxy = null;
            }
        }
        return proxy;
    }

    protected static String getProxyAuth(ClickHouseConfig config) {
        String userName;
        String authHeader = null;
        if (config.getProxyType() == ClickHouseProxyType.HTTP && !ClickHouseChecker.isNullOrEmpty(userName = config.getProxyUserName())) {
            String auth = userName + ":" + new String(config.getProxyPassword());
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
            authHeader = "Basic " + new String(encodedAuth);
        }
        return authHeader;
    }

    protected static String parseErrorFromException(String errorCode, String serverName, IOException e, byte[] bytes) {
        String errorMsg;
        log.debug((Object)"Failed to read error message[code=%s] from server [%s] due to: %s", errorCode, serverName, e.getMessage());
        int index = ClickHouseByteUtils.indexOf(bytes, ERROR_MSG_PREFIX);
        if (index > 0) {
            bytes[--index] = 67;
            errorMsg = new String(bytes, index, bytes.length - index, StandardCharsets.UTF_8);
        } else {
            errorMsg = !ClickHouseChecker.isNullOrBlank(errorCode) ? "Code: " + errorCode + ", server: " + serverName + ", " + new String(bytes, StandardCharsets.UTF_8) : new String(bytes, StandardCharsets.UTF_8);
        }
        return errorMsg;
    }

    protected static void postData(ClickHouseConfig config, byte[] boundary, String sql, ClickHouseInputStream data, List<ClickHouseExternalTable> tables, OutputStream requestStream) throws IOException {
        boolean hasCustomInput = data != null && data.getUnderlyingStream().hasInput();
        try (OutputStream rawOut = requestStream;
             ClickHouseOutputStream out = hasCustomInput ? ClickHouseOutputStream.of(rawOut, config.getWriteBufferSize()) : (data != null || boundary != null ? ClickHouseClient.getAsyncRequestOutputStream(config, rawOut, null) : ClickHouseClient.getRequestOutputStream(config, rawOut, null));){
            byte[] sqlBytes;
            byte[] byArray = sqlBytes = hasCustomInput ? new byte[]{} : sql.getBytes(StandardCharsets.UTF_8);
            if (boundary != null) {
                rawOut.write(LINE_PREFIX);
                rawOut.write(boundary);
                rawOut.write(LINE_SUFFIX);
                rawOut.write(HEADER_CONTENT_DISPOSITION);
                rawOut.write(SUFFIX_QUERY);
                rawOut.write(sqlBytes);
                int writeBufferSize = config.getWriteBufferSize();
                for (ClickHouseExternalTable t : tables) {
                    byte[] tableName = t.getName().getBytes(StandardCharsets.UTF_8);
                    for (int i = 0; i < 3; ++i) {
                        rawOut.write(LINE_PREFIX);
                        rawOut.write(boundary);
                        rawOut.write(LINE_SUFFIX);
                        rawOut.write(HEADER_CONTENT_DISPOSITION);
                        rawOut.write(tableName);
                        if (i == 0) {
                            rawOut.write(SUFFIX_FORMAT);
                            rawOut.write(t.getFormat().name().getBytes(StandardCharsets.US_ASCII));
                            continue;
                        }
                        if (i == 1) {
                            rawOut.write(SUFFIX_STRUCTURE);
                            rawOut.write(t.getStructure().getBytes(StandardCharsets.UTF_8));
                            continue;
                        }
                        rawOut.write(SUFFIX_FILENAME);
                        rawOut.write(tableName);
                        rawOut.write(END_OF_NAME);
                        break;
                    }
                    rawOut.write(HEADER_OCTET_STREAM);
                    rawOut.write(HEADER_BINARY_ENCODING);
                    ClickHouseInputStream.pipe(t.getContent(), rawOut, writeBufferSize);
                }
                rawOut.write(LINE_PREFIX);
                rawOut.write(boundary);
                rawOut.write(DOUBLE_DASH);
                rawOut.write(LINE_SUFFIX);
            } else {
                out.writeBytes(sqlBytes);
                if (data != null && data.available() > 0) {
                    if (sqlBytes.length > 0 && sqlBytes[sqlBytes.length - 1] != 10) {
                        out.write(10);
                    }
                    ClickHouseInputStream.pipe((InputStream)data, (OutputStream)out, config.getWriteBufferSize());
                }
            }
        }
    }

    protected ClickHouseHttpConnection(ClickHouseNode server, ClickHouseRequest<?> request, Map<String, Serializable> additionalParams) {
        ClickHouseConfig c;
        if (server == null || request == null) {
            throw new IllegalArgumentException("Non-null server and request are required");
        }
        this.server = server;
        this.rm = request.getManager();
        this.config = c = request.getConfig();
        this.defaultHeaders = Collections.unmodifiableMap(ClickHouseHttpConnection.createDefaultHeaders(c, server, this.getUserAgent(), ClickHouseHttpClient.getReferer(this.config)));
        this.url = ClickHouseHttpConnection.buildUrl(server.getBaseUri(), request, additionalParams);
        log.debug((Object)"url [%s]", this.url);
    }

    protected void closeQuietly() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getBaseUrl() {
        String u = this.url;
        int index = u.indexOf(63);
        if (index < 1) {
            index = u.length();
        }
        String baseUrl = u.substring(0, index);
        if (u.charAt(index - 1) != '/') {
            baseUrl = baseUrl.concat("/");
        }
        return baseUrl;
    }

    protected String getDefaultUserAgent() {
        return this.config.getClientName();
    }

    protected final String getUserAgent() {
        ClickHouseConfig c = this.config;
        String name = c.getClientName();
        String userAgent = this.getDefaultUserAgent();
        if (!ClickHouseClientOption.CLIENT_NAME.getDefaultValue().equals(name)) {
            return name + " " + userAgent;
        }
        name = c.getProductName();
        String version = c.getProductVersion();
        if (!ClickHouseClientOption.PRODUCT_VERSION.equals(version)) {
            name = name + "/" + c.getProductVersion();
        }
        return ClickHouseClientOption.PRODUCT_NAME.getDefaultValue().equals(name) ? userAgent : name + " " + userAgent;
    }

    protected Map<String, String> mergeHeaders(Map<String, String> requestHeaders) {
        if (requestHeaders == null || requestHeaders.isEmpty()) {
            return this.defaultHeaders;
        }
        if (this.isReusable()) {
            return requestHeaders;
        }
        LinkedHashMap<String, String> merged = new LinkedHashMap<String, String>();
        merged.putAll(this.defaultHeaders);
        for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
            String name = header.getKey().toLowerCase(Locale.ROOT);
            String value = header.getValue();
            if (value == null) {
                merged.remove(name);
                continue;
            }
            merged.put(name, value);
        }
        return merged;
    }

    protected abstract ClickHouseHttpResponse post(ClickHouseConfig var1, String var2, ClickHouseInputStream var3, List<ClickHouseExternalTable> var4, ClickHouseOutputStream var5, String var6, Map<String, String> var7, Runnable var8) throws IOException;

    protected boolean isReusable() {
        return true;
    }

    public abstract boolean ping(int var1);

    public ClickHouseHttpResponse update(String query) throws IOException {
        return this.post(this.config, query, null, null, null, null, null, null);
    }

    public ClickHouseHttpResponse update(String query, Map<String, String> headers) throws IOException {
        return this.post(this.config, query, null, null, null, null, headers, null);
    }

    public ClickHouseHttpResponse update(String query, ClickHouseInputStream data) throws IOException {
        return this.post(this.config, query, data, null, null, null, null, null);
    }

    public ClickHouseHttpResponse update(String query, ClickHouseInputStream data, Map<String, String> headers) throws IOException {
        return this.post(this.config, query, data, null, null, null, headers, null);
    }

    public ClickHouseHttpResponse query(String query) throws IOException {
        return this.post(this.config, query, null, null, null, null, null, null);
    }

    public ClickHouseHttpResponse query(String query, Map<String, String> headers) throws IOException {
        return this.post(this.config, query, null, null, null, null, headers, null);
    }

    public ClickHouseHttpResponse query(String query, List<ClickHouseExternalTable> tables) throws IOException {
        return this.post(this.config, query, null, tables, null, null, null, null);
    }

    public ClickHouseHttpResponse query(String query, List<ClickHouseExternalTable> tables, Map<String, String> headers) throws IOException {
        return this.post(this.config, query, null, tables, null, null, headers, null);
    }

    @Override
    public void close() throws IOException {
    }
}

