/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.api.Client;
import com.clickhouse.client.api.query.GenericRecord;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.jdbc.Driver;
import com.clickhouse.jdbc.JdbcV2Wrapper;
import com.clickhouse.jdbc.PreparedStatementImpl;
import com.clickhouse.jdbc.StatementImpl;
import com.clickhouse.jdbc.internal.ClientInfoProperties;
import com.clickhouse.jdbc.internal.JdbcConfiguration;
import com.clickhouse.jdbc.internal.JdbcUtils;
import com.clickhouse.jdbc.metadata.DatabaseMetaData;
import com.clickhouse.jdbc.types.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.ShardingKey;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
implements Connection,
JdbcV2Wrapper {
    private static final Logger log = LoggerFactory.getLogger(ConnectionImpl.class);
    protected final String url;
    protected final Client client;
    protected final JdbcConfiguration config;
    private boolean closed = false;
    protected boolean onCluster;
    protected String cluster;
    private String catalog;
    private String schema;
    private QuerySettings defaultQuerySettings;
    private final DatabaseMetaData metadata;
    protected final Calendar defaultCalendar;
    private String appName = "";

    public ConnectionImpl(String url, Properties info) throws SQLException {
        try {
            log.debug("Creating connection to {}", (Object)url);
            this.url = url;
            this.config = new JdbcConfiguration(url, info);
            this.onCluster = false;
            this.cluster = null;
            String clientName = "ClickHouse JDBC Driver V2/" + Driver.driverVersion;
            if (this.config.isDisableFrameworkDetection()) {
                log.debug("Framework detection is disabled.");
            } else {
                String detectedFrameworks = Driver.FrameworksDetection.getFrameworksDetected();
                log.debug("Detected frameworks: {}", (Object)detectedFrameworks);
                clientName = clientName + " (" + detectedFrameworks + ")";
            }
            this.client = this.config.applyClientProperties(new Client.Builder()).setClientName(clientName).build();
            this.client.loadServerInfo();
            this.schema = this.client.getDefaultDatabase();
            this.defaultQuerySettings = new QuerySettings().serverSetting("async_insert", "0").serverSetting("wait_end_of_query", "0");
            this.metadata = new DatabaseMetaData(this, false, url);
            this.defaultCalendar = Calendar.getInstance();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Failed to create connection", "08000", e);
        }
    }

    public QuerySettings getDefaultQuerySettings() {
        return this.defaultQuerySettings;
    }

    public void setDefaultQuerySettings(QuerySettings settings) {
        this.defaultQuerySettings = settings;
    }

    public String getServerVersion() throws SQLException {
        GenericRecord result = (GenericRecord)this.client.queryAll("SELECT version() as server_version").stream().findFirst().orElseThrow(() -> new SQLException("Failed to retrieve server version.", "HY000"));
        return result.getString("server_version");
    }

    public JdbcConfiguration getJdbcConfig() {
        return this.config;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return this.createStatement(1003, 1007, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql, 1003, 1007, 2);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("CallableStatement not supported", "0A000");
        }
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("nativeSQL not supported", "0A000");
        }
        return null;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests() && !autoCommit) {
            throw new SQLFeatureNotSupportedException("setAutoCommit = false not supported", "0A000");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Commit/Rollback not supported", "0A000");
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Commit/Rollback not supported", "0A000");
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.client.close();
        this.closed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests() && readOnly) {
            throw new SQLFeatureNotSupportedException("read-only=true unsupported", "0A000");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests() && 0 != level) {
            throw new SQLFeatureNotSupportedException("setTransactionIsolation not supported", "0A000");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("CallableStatement not supported", "0A000");
        }
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("getTypeMap not supported", "0A000");
        }
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("setTypeMap not supported", "0A000");
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Savepoint not supported", "0A000");
        }
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Savepoint not supported", "0A000");
        }
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Commit/Rollback not supported", "0A000");
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Savepoint not supported", "0A000");
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return new StatementImpl(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return new PreparedStatementImpl(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("CallableStatement not supported", "0A000");
        }
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("prepareStatement(String sql, int autoGeneratedKeys) not supported", "0A000");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("prepareStatement(String sql, int[] columnIndexes) not supported", "0A000");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("prepareStatement(String sql, String[] columnNames) not supported", "0A000");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Clob not supported", "0A000");
        }
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Blob not supported", "0A000");
        }
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("NClob not supported", "0A000");
        }
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("SQLXML not supported", "0A000");
        }
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkOpen();
        if (timeout < 0) {
            throw new SQLException("Timeout must be >= 0", "HY000");
        }
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (ClientInfoProperties.APPLICATION_NAME.getKey().equals(name)) {
            this.config.updateUserClient(value, this.client);
            this.appName = value;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        HashSet<String> toSet = new HashSet<String>();
        HashSet<String> toReset = new HashSet<String>();
        for (ClientInfoProperties p : ClientInfoProperties.values()) {
            String key = p.getKey();
            if (properties.containsKey(key)) {
                toSet.add(key);
                continue;
            }
            toReset.add(key);
        }
        for (String key : toReset) {
            this.setClientInfo(key, null);
        }
        for (String key : toSet) {
            this.setClientInfo(key, properties.getProperty(key));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkOpen();
        if (ClientInfoProperties.APPLICATION_NAME.getKey().equals(name)) {
            return this.appName;
        }
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkOpen();
        Properties clientInfo = new Properties();
        clientInfo.put(ClientInfoProperties.APPLICATION_NAME.getKey(), this.getClientInfo(ClientInfoProperties.APPLICATION_NAME.getKey()));
        return clientInfo;
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            return new Array(List.of(elements), typeName, JdbcUtils.convertToSqlType(ClickHouseDataType.valueOf(typeName)).getVendorTypeNumber());
        }
        catch (Exception e) {
            throw new SQLException("Failed to create array", "HY000", e);
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("createStruct not supported", "0A000");
        }
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        this.schema = schema;
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return this.schema;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("abort not supported", "0A000");
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("setNetworkTimeout not supported", "0A000");
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("getNetworkTimeout not supported", "0A000");
        }
        return -1;
    }

    @Override
    public void beginRequest() throws SQLException {
        Connection.super.beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        Connection.super.endRequest();
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, ShardingKey superShardingKey, int timeout) throws SQLException {
        return Connection.super.setShardingKeyIfValid(shardingKey, superShardingKey, timeout);
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, int timeout) throws SQLException {
        return Connection.super.setShardingKeyIfValid(shardingKey, timeout);
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey, ShardingKey superShardingKey) throws SQLException {
        Connection.super.setShardingKey(shardingKey, superShardingKey);
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey) throws SQLException {
        Connection.super.setShardingKey(shardingKey);
    }

    public Client getClient() {
        return this.client;
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed", "08000");
        }
    }
}

