/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.data.Tuple;
import com.clickhouse.jdbc.ConnectionImpl;
import com.clickhouse.jdbc.JdbcV2Wrapper;
import com.clickhouse.jdbc.StatementImpl;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementImpl
extends StatementImpl
implements PreparedStatement,
JdbcV2Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(PreparedStatementImpl.class);
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private final Calendar defaultCalendar;
    String originalSql;
    String[] sqlSegments;
    Object[] parameters;
    String insertIntoSQL;
    StatementImpl.StatementType statementType;

    public PreparedStatementImpl(ConnectionImpl connection, String sql) throws SQLException {
        super(connection);
        this.originalSql = sql.trim();
        this.sqlSegments = this.originalSql.split("\\?");
        this.statementType = PreparedStatementImpl.parseStatementType(this.originalSql);
        if (this.statementType == StatementImpl.StatementType.INSERT) {
            this.insertIntoSQL = this.originalSql.substring(0, this.originalSql.indexOf("VALUES") + 6);
        }
        if (this.originalSql.contains("?")) {
            int count = this.originalSql.length() - this.originalSql.replace("?", "").length();
            this.parameters = new Object[count];
        } else {
            this.parameters = new Object[0];
        }
        this.defaultCalendar = connection.defaultCalendar;
    }

    private String compileSql() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.sqlSegments.length; ++i) {
            sb.append(this.sqlSegments[i]);
            if (i >= this.parameters.length) continue;
            sb.append(this.parameters[i]);
        }
        LOG.trace("Compiled SQL: {}", (Object)sb);
        return sb.toString();
    }

    private String valuesSql() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.parameters[i]);
        }
        sb.append(")");
        LOG.trace("Compiled Value SQL: {}", (Object)sb);
        return sb.toString();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        return this.executeQuery(this.compileSql());
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkClosed();
        return this.executeUpdate(this.compileSql());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        this.setNull(parameterIndex, sqlType, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        this.parameters = this.originalSql.contains("?") ? new Object[this.sqlSegments.length] : new Object[0];
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkClosed();
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        this.setObject(parameterIndex, x, 1111);
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        return this.execute(this.compileSql());
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.statementType == StatementImpl.StatementType.INSERT) {
            this.addBatch(this.valuesSql());
        } else {
            this.addBatch(this.compileSql());
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        if (this.statementType == StatementImpl.StatementType.INSERT && !this.batch.isEmpty()) {
            ArrayList<Integer> results = new ArrayList<Integer>();
            StringBuilder sb = new StringBuilder();
            sb.append(this.insertIntoSQL).append(" ");
            for (String sql : this.batch) {
                sb.append(sql).append(",");
            }
            sb.setCharAt(sb.length() - 1, ';');
            results.add(this.executeUpdate(sb.toString()));
            this.batch.clear();
            return results.stream().mapToInt(i -> i).toArray();
        }
        return super.executeBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.checkClosed();
        if (!this.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Ref is not supported.", "0A000");
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkClosed();
        LocalDate d = x.toLocalDate();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(d.getYear(), d.getMonthValue() - 1, d.getDayOfMonth(), 0, 0, 0);
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(c.toInstant());
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkClosed();
        LocalTime t = x.toLocalTime();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(1970, 0, 1, t.getHour(), t.getMinute(), t.getSecond());
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(c.toInstant());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkClosed();
        LocalDateTime ldt = x.toLocalDateTime();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(c.toInstant().atZone(ZoneId.of("UTC")).withNano(x.getNanos()));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        this.setObject(parameterIndex, x, JDBCType.valueOf(targetSqlType), scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        this.parameters[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.checkClosed();
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.checkClosed();
        return PreparedStatement.super.executeLargeUpdate();
    }

    private static String encodeObject(Object x) throws SQLException {
        LOG.trace("Encoding object: {}", x);
        try {
            if (x == null) {
                return "NULL";
            }
            if (x instanceof String) {
                return "'" + PreparedStatementImpl.escapeString((String)x) + "'";
            }
            if (x instanceof Boolean) {
                return (Boolean)x != false ? "1" : "0";
            }
            if (x instanceof Date) {
                return "'" + DATE_FORMATTER.format(((Date)x).toLocalDate()) + "'";
            }
            if (x instanceof LocalDate) {
                return "'" + DATE_FORMATTER.format((LocalDate)x) + "'";
            }
            if (x instanceof Time) {
                return "'" + TIME_FORMATTER.format(((Time)x).toLocalTime()) + "'";
            }
            if (x instanceof LocalTime) {
                return "'" + TIME_FORMATTER.format((LocalTime)x) + "'";
            }
            if (x instanceof Timestamp) {
                return "'" + DATETIME_FORMATTER.format(((Timestamp)x).toLocalDateTime()) + "'";
            }
            if (x instanceof LocalDateTime) {
                return "'" + DATETIME_FORMATTER.format((LocalDateTime)x) + "'";
            }
            if (x instanceof OffsetDateTime) {
                return PreparedStatementImpl.encodeObject(((OffsetDateTime)x).toInstant());
            }
            if (x instanceof ZonedDateTime) {
                return PreparedStatementImpl.encodeObject(((ZonedDateTime)x).toInstant());
            }
            if (x instanceof Instant) {
                return "fromUnixTimestamp64Nano(" + (((Instant)x).getEpochSecond() * 1000000000L + (long)((Instant)x).getNano()) + ")";
            }
            if (x instanceof Array) {
                StringBuilder listString = new StringBuilder();
                listString.append("[");
                int i = 0;
                for (Object item : (Object[])((Array)x).getArray()) {
                    if (i > 0) {
                        listString.append(", ");
                    }
                    listString.append(PreparedStatementImpl.encodeObject(item));
                    ++i;
                }
                listString.append("]");
                return listString.toString();
            }
            if (x instanceof Collection) {
                StringBuilder listString = new StringBuilder();
                listString.append("[");
                for (Object item : (Collection)x) {
                    listString.append(PreparedStatementImpl.encodeObject(item)).append(", ");
                }
                listString.delete(listString.length() - 2, listString.length());
                listString.append("]");
                return listString.toString();
            }
            if (x instanceof Map) {
                Map tmpMap = (Map)x;
                StringBuilder mapString = new StringBuilder();
                mapString.append("{");
                for (Object key : tmpMap.keySet()) {
                    mapString.append(PreparedStatementImpl.encodeObject(key)).append(": ").append(PreparedStatementImpl.encodeObject(tmpMap.get(key))).append(", ");
                }
                if (!tmpMap.isEmpty()) {
                    mapString.delete(mapString.length() - 2, mapString.length());
                }
                mapString.append("}");
                return mapString.toString();
            }
            if (x instanceof Reader) {
                int len;
                StringBuilder sb = new StringBuilder();
                Reader reader = (Reader)x;
                char[] buffer = new char[1024];
                while ((len = reader.read(buffer)) != -1) {
                    sb.append(buffer, 0, len);
                }
                return "'" + PreparedStatementImpl.escapeString(sb.toString()) + "'";
            }
            if (x instanceof InputStream) {
                int len;
                StringBuilder sb = new StringBuilder();
                InputStream is = (InputStream)x;
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    sb.append(new String(buffer, 0, len));
                }
                return "'" + PreparedStatementImpl.escapeString(sb.toString()) + "'";
            }
            if (x instanceof Object[]) {
                StringBuilder arrayString = new StringBuilder();
                arrayString.append("[");
                int i = 0;
                for (Object item : (Object[])x) {
                    if (i > 0) {
                        arrayString.append(", ");
                    }
                    arrayString.append(PreparedStatementImpl.encodeObject(item));
                    ++i;
                }
                arrayString.append("]");
                return arrayString.toString();
            }
            if (x instanceof Tuple) {
                StringBuilder tupleString = new StringBuilder();
                tupleString.append("(");
                Tuple t = (Tuple)x;
                Object[] values = t.getValues();
                int i = 0;
                for (Object item : values) {
                    if (i > 0) {
                        tupleString.append(", ");
                    }
                    tupleString.append(PreparedStatementImpl.encodeObject(item));
                    ++i;
                }
                tupleString.append(")");
                return tupleString.toString();
            }
            return PreparedStatementImpl.escapeString(x.toString());
        }
        catch (Exception e) {
            LOG.error("Error encoding object", e);
            throw new SQLException("Error encoding object", "07000", e);
        }
    }

    private static String escapeString(String x) {
        return x.replace("\\", "\\\\").replace("'", "\\'");
    }
}

