/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.opencensus.impl.internal;

import com.clickhouse.client.internal.opencensus.implcore.internal.DaemonThreadFactory;
import com.clickhouse.client.internal.opencensus.implcore.internal.EventQueue;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DisruptorEventQueue
implements EventQueue {
    private static final Logger logger = Logger.getLogger(DisruptorEventQueue.class.getName());
    private static final int DISRUPTOR_BUFFER_SIZE = 8192;
    private static final DisruptorEventQueue eventQueue = DisruptorEventQueue.create();
    private final Disruptor<DisruptorEvent> disruptor;
    private volatile DisruptorEnqueuer enqueuer;

    private DisruptorEventQueue(Disruptor<DisruptorEvent> disruptor, DisruptorEnqueuer enqueuer) {
        this.disruptor = disruptor;
        this.enqueuer = enqueuer;
    }

    private static DisruptorEventQueue create() {
        Disruptor<DisruptorEvent> disruptor = new Disruptor<DisruptorEvent>(DisruptorEventFactory.INSTANCE, 8192, new DaemonThreadFactory("OpenCensus.Disruptor"), ProducerType.MULTI, (WaitStrategy)new SleepingWaitStrategy(0, 1000000L));
        disruptor.handleEventsWith(DisruptorEventHandler.INSTANCE);
        disruptor.start();
        final RingBuffer<DisruptorEvent> ringBuffer = disruptor.getRingBuffer();
        DisruptorEnqueuer enqueuer = new DisruptorEnqueuer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enqueue(EventQueue.Entry entry) {
                long sequence = ringBuffer.next();
                try {
                    DisruptorEvent event = (DisruptorEvent)ringBuffer.get(sequence);
                    event.setEntry(entry);
                }
                finally {
                    ringBuffer.publish(sequence);
                }
            }
        };
        return new DisruptorEventQueue(disruptor, enqueuer);
    }

    public static DisruptorEventQueue getInstance() {
        return eventQueue;
    }

    @Override
    public void enqueue(EventQueue.Entry entry) {
        this.enqueuer.enqueue(entry);
    }

    @Override
    public void shutdown() {
        this.enqueuer = new DisruptorEnqueuer(){
            final AtomicBoolean logged = new AtomicBoolean(false);

            @Override
            public void enqueue(EventQueue.Entry entry) {
                if (!this.logged.getAndSet(true)) {
                    logger.log(Level.INFO, "Attempted to enqueue entry after Disruptor shutdown.");
                }
            }
        };
        this.disruptor.shutdown();
    }

    private static enum DisruptorEventHandler implements EventHandler<DisruptorEvent>
    {
        INSTANCE;


        @Override
        public void onEvent(DisruptorEvent event, long sequence, boolean endOfBatch) {
            EventQueue.Entry entry = event.getEntry();
            if (entry != null) {
                entry.process();
            }
            event.setEntry(null);
        }
    }

    private static enum DisruptorEventFactory implements EventFactory<DisruptorEvent>
    {
        INSTANCE;


        @Override
        public DisruptorEvent newInstance() {
            return new DisruptorEvent();
        }
    }

    private static final class DisruptorEvent {
        @Nullable
        private volatile EventQueue.Entry entry = null;

        private DisruptorEvent() {
        }

        void setEntry(@Nullable EventQueue.Entry entry) {
            this.entry = entry;
        }

        @Nullable
        EventQueue.Entry getEntry() {
            return this.entry;
        }
    }

    private static abstract class DisruptorEnqueuer {
        private DisruptorEnqueuer() {
        }

        public abstract void enqueue(EventQueue.Entry var1);
    }
}

