/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.api.DataTypeUtils;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.sql.SQLUtils;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.Tuple;
import com.clickhouse.jdbc.ConnectionImpl;
import com.clickhouse.jdbc.JdbcV2Wrapper;
import com.clickhouse.jdbc.StatementImpl;
import com.clickhouse.jdbc.internal.JdbcUtils;
import com.clickhouse.jdbc.internal.ParsedPreparedStatement;
import com.clickhouse.jdbc.metadata.ParameterMetaDataImpl;
import com.clickhouse.jdbc.metadata.ResultSetMetaDataImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementImpl
extends StatementImpl
implements PreparedStatement,
JdbcV2Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(PreparedStatementImpl.class);
    public static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private final Calendar defaultCalendar;
    private final String originalSql;
    private final String[] values;
    private final List<StringBuilder> batchValues;
    private final ParsedPreparedStatement parsedPreparedStatement;
    private final boolean insertStmtWithValues;
    private final String valueListTmpl;
    private final int[] paramPositionsInDataClause;
    private final int argCount;
    private final ParameterMetaData parameterMetaData;
    private ResultSetMetaData resultSetMetaData = null;
    public static final String NULL_LITERAL = "NULL";
    private static final Pattern REPLACE_Q_MARK_PATTERN = Pattern.compile("(\"[^\"]*\"|`[^`]*`|'[^']*')|(\\?)");

    public PreparedStatementImpl(ConnectionImpl connection, String sql, ParsedPreparedStatement parsedStatement) throws SQLException {
        super(connection);
        this.isPoolable = true;
        this.originalSql = sql;
        this.parsedPreparedStatement = parsedStatement;
        this.argCount = parsedStatement.getArgCount();
        this.defaultCalendar = connection.defaultCalendar;
        this.values = new String[this.argCount];
        this.parameterMetaData = new ParameterMetaDataImpl(this.values.length);
        int valueListStartPos = parsedStatement.getAssignValuesListStartPosition();
        int valueListStopPos = parsedStatement.getAssignValuesListStopPosition();
        if (parsedStatement.getAssignValuesGroups() == 1 && valueListStartPos > -1 && valueListStopPos > -1) {
            int[] positions = parsedStatement.getParamPositions();
            this.paramPositionsInDataClause = new int[this.argCount];
            for (int i = 0; i < this.argCount; ++i) {
                int p;
                this.paramPositionsInDataClause[i] = p = positions[i] - valueListStartPos;
            }
            this.valueListTmpl = this.originalSql.substring(valueListStartPos, valueListStopPos + 1);
            this.insertStmtWithValues = true;
            this.batchValues = new ArrayList<StringBuilder>();
        } else {
            this.paramPositionsInDataClause = new int[0];
            this.batchValues = Collections.emptyList();
            this.valueListTmpl = "";
            this.insertStmtWithValues = false;
        }
    }

    private String buildSQL() throws SQLException {
        StringBuilder compiledSql = new StringBuilder(this.originalSql);
        int posOffset = 0;
        int[] positions = this.parsedPreparedStatement.getParamPositions();
        for (int i = 0; i < this.argCount; ++i) {
            int p = positions[i] + posOffset;
            String val = this.values[i];
            if (val == null) {
                throw new SQLException("Parameter at position '" + i + "' is not set");
            }
            compiledSql.replace(p, p + 1, val);
            posOffset += val.length() - 1;
        }
        return compiledSql.toString();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureOpen();
        String buildSQL = this.buildSQL();
        return super.executeQueryImpl(buildSQL, this.localSettings);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.ensureOpen();
        return (int)super.executeUpdateImpl(this.buildSQL(), this.localSettings);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ensureOpen();
        this.setNull(parameterIndex, sqlType, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ensureOpen();
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x, Long.valueOf(length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ensureOpen();
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        Arrays.fill(this.values, null);
    }

    int getParametersCount() {
        return this.argCount;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = this.encodeObject(x, this.jdbcType2ClickHouseDataType(JDBCType.valueOf(targetSqlType)), null);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = this.encodeObject(x, this.jdbcType2ClickHouseDataType(JDBCType.valueOf(targetSqlType)), scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = this.encodeObject(x, this.sqlType2ClickHouseDataType(targetSqlType), null);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = this.encodeObject(x, this.sqlType2ClickHouseDataType(targetSqlType), scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureOpen();
        if (this.parsedPreparedStatement.isHasResultSet()) {
            this.currentResultSet = super.executeQueryImpl(this.buildSQL(), this.localSettings);
            return true;
        }
        this.currentUpdateCount = super.executeUpdateImpl(this.buildSQL(), this.localSettings);
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        if (this.insertStmtWithValues) {
            StringBuilder valuesClause = new StringBuilder(this.valueListTmpl);
            int posOffset = 0;
            for (int i = 0; i < this.argCount; ++i) {
                int p = this.paramPositionsInDataClause[i] + posOffset;
                valuesClause.replace(p, p + 1, this.values[i]);
                posOffset += this.values[i].length() - 1;
            }
            this.batchValues.add(valuesClause);
        } else {
            super.addBatch(this.buildSQL());
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureOpen();
        return this.executeBatchImpl().stream().mapToInt(Integer::intValue).toArray();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.ensureOpen();
        return this.executeBatchImpl().stream().mapToLong(Integer::longValue).toArray();
    }

    private List<Integer> executeBatchImpl() throws SQLException {
        if (this.insertStmtWithValues) {
            return this.executeInsertBatch();
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (String sql : this.batch) {
            results.add((int)this.executeUpdateImpl(sql, this.localSettings));
        }
        return results;
    }

    private List<Integer> executeInsertBatch() throws SQLException {
        StringBuilder insertSql = new StringBuilder(this.originalSql.substring(0, this.parsedPreparedStatement.getAssignValuesListStartPosition()));
        for (StringBuilder valuesList : this.batchValues) {
            insertSql.append((CharSequence)valuesList).append(',');
        }
        insertSql.setLength(insertSql.length() - 1);
        int updateCount = (int)super.executeUpdateImpl(insertSql.toString(), this.localSettings);
        if (updateCount == this.batchValues.size()) {
            return Collections.nCopies(this.batchValues.size(), 1);
        }
        return Collections.nCopies(this.batchValues.size(), -2);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.ensureOpen();
        this.setCharacterStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.ensureOpen();
        if (!this.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Ref is not supported.", "0A000");
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setArray(int parameterIndex, java.sql.Array x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        if (this.resultSetMetaData == null && this.currentResultSet == null) {
            if (this.parsedPreparedStatement.isHasResultSet()) {
                try {
                    String sql = PreparedStatementImpl.replaceQuestionMarks(this.originalSql, NULL_LITERAL);
                    TableSchema tSchema = this.connection.getClient().getTableSchemaFromQuery(sql);
                    this.resultSetMetaData = new ResultSetMetaDataImpl(tSchema.getColumns(), this.connection.getSchema(), this.connection.getCatalog(), tSchema.getTableName(), JdbcUtils.DATA_TYPE_CLASS_MAP);
                }
                catch (Exception e) {
                    LOG.warn("Failed to get schema for statement '{}'", (Object)this.originalSql);
                }
            }
            if (this.resultSetMetaData == null) {
                List<ClickHouseColumn> columns = IntStream.range(0, this.argCount).mapToObj(value -> ClickHouseColumn.of("v_" + value, "Nothing")).collect(Collectors.toList());
                this.resultSetMetaData = new ResultSetMetaDataImpl(columns, this.connection.getSchema(), this.connection.getCatalog(), "", JdbcUtils.DATA_TYPE_CLASS_MAP);
            }
        } else if (this.currentResultSet != null) {
            this.resultSetMetaData = this.currentResultSet.getMetaData();
        }
        return this.resultSetMetaData;
    }

    public static String replaceQuestionMarks(String sql, String replacement) {
        Matcher matcher = REPLACE_Q_MARK_PATTERN.matcher(sql);
        StringBuilder result = new StringBuilder();
        int lastPos = 0;
        while (matcher.find()) {
            String str;
            String text = matcher.group(1);
            if (text != null) {
                str = Matcher.quoteReplacement(text);
                result.append(sql, lastPos, matcher.start()).append(str);
                lastPos = matcher.end();
                continue;
            }
            if (matcher.group(2) == null) continue;
            str = Matcher.quoteReplacement(replacement);
            result.append(sql, lastPos, matcher.start()).append(str);
            lastPos = matcher.end();
        }
        result.append(sql, lastPos, sql.length());
        return result.toString();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(this.sqlDateToInstant(x, cal));
    }

    protected Instant sqlDateToInstant(Date x, Calendar cal) {
        LocalDate d = x.toLocalDate();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(d.getYear(), d.getMonthValue() - 1, d.getDayOfMonth(), 0, 0, 0);
        return c.toInstant();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(this.sqlTimeToInstant(x, cal));
    }

    protected Instant sqlTimeToInstant(Time x, Calendar cal) {
        LocalTime t = x.toLocalTime();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(1970, 0, 1, t.getHour(), t.getMinute(), t.getSecond());
        return c.toInstant();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(this.sqlTimestampToZDT(x, cal));
    }

    protected ZonedDateTime sqlTimestampToZDT(Timestamp x, Calendar cal) {
        LocalDateTime ldt = x.toLocalDateTime();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
        return c.toInstant().atZone(ZoneId.of("UTC")).withNano(x.getNanos());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.ensureOpen();
        return this.parameterMetaData;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.ensureOpen();
        throw new SQLException("ROWID type is not supported by ClickHouse.", "0A000");
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        this.ensureOpen();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.executeUpdate();
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        this.ensureOpen();
        throw new SQLException("addBatch(String) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        this.ensureOpen();
        throw new SQLException("execute(String) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureOpen();
        throw new SQLException("execute(String, int) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.ensureOpen();
        throw new SQLException("execute(String, int[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        this.ensureOpen();
        throw new SQLException("execute(String, String[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final long executeLargeUpdate(String sql) throws SQLException {
        this.ensureOpen();
        throw new SQLException("executeLargeUpdate(String) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureOpen();
        throw new SQLException("executeLargeUpdate(String, int) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.ensureOpen();
        throw new SQLException("executeLargeUpdate(String, int[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.ensureOpen();
        throw new SQLException("executeLargeUpdate(String, String[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        this.ensureOpen();
        throw new SQLException("executeQuery(String) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        this.ensureOpen();
        throw new SQLException("executeUpdate(String) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureOpen();
        throw new SQLException("executeUpdate(String, int) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.ensureOpen();
        throw new SQLException("executeUpdate(String, int[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.ensureOpen();
        throw new SQLException("executeUpdate(String, String[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    private static String encodeObject(Object x) throws SQLException {
        return PreparedStatementImpl.encodeObject(x, null);
    }

    private static String encodeObject(Object x, Long length) throws SQLException {
        LOG.trace("Encoding object: {}", x);
        try {
            if (x == null) {
                return NULL_LITERAL;
            }
            if (x instanceof String) {
                return "'" + SQLUtils.escapeSingleQuotes((String)x) + "'";
            }
            if (x instanceof Boolean) {
                return (Boolean)x != false ? "1" : "0";
            }
            if (x instanceof Date) {
                return "'" + DataTypeUtils.DATE_FORMATTER.format(((Date)x).toLocalDate()) + "'";
            }
            if (x instanceof LocalDate) {
                return "'" + DataTypeUtils.DATE_FORMATTER.format((LocalDate)x) + "'";
            }
            if (x instanceof Time) {
                return "'" + TIME_FORMATTER.format(((Time)x).toLocalTime()) + "'";
            }
            if (x instanceof LocalTime) {
                return "'" + TIME_FORMATTER.format((LocalTime)x) + "'";
            }
            if (x instanceof Timestamp) {
                return "'" + DATETIME_FORMATTER.format(((Timestamp)x).toLocalDateTime()) + "'";
            }
            if (x instanceof LocalDateTime) {
                return "'" + DATETIME_FORMATTER.format((LocalDateTime)x) + "'";
            }
            if (x instanceof OffsetDateTime) {
                return PreparedStatementImpl.encodeObject(((OffsetDateTime)x).toInstant());
            }
            if (x instanceof ZonedDateTime) {
                return PreparedStatementImpl.encodeObject(((ZonedDateTime)x).toInstant());
            }
            if (x instanceof Instant) {
                return "fromUnixTimestamp64Nano(" + (((Instant)x).getEpochSecond() * 1000000000L + (long)((Instant)x).getNano()) + ")";
            }
            if (x instanceof InetAddress) {
                return "'" + ((InetAddress)x).getHostAddress() + "'";
            }
            if (x instanceof java.sql.Array) {
                StringBuilder listString = new StringBuilder();
                listString.append("[");
                int i = 0;
                for (Object item : (Object[])((java.sql.Array)x).getArray()) {
                    if (i > 0) {
                        listString.append(", ");
                    }
                    listString.append(PreparedStatementImpl.encodeObject(item));
                    ++i;
                }
                listString.append("]");
                return listString.toString();
            }
            if (x.getClass().isArray()) {
                StringBuilder listString = new StringBuilder();
                listString.append("[");
                if (x.getClass().getComponentType().isPrimitive()) {
                    int len = Array.getLength(x);
                    for (int i = 0; i < len; ++i) {
                        if (i > 0) {
                            listString.append(", ");
                        }
                        listString.append(PreparedStatementImpl.encodeObject(Array.get(x, i)));
                    }
                } else {
                    int i = 0;
                    for (Object item : (Object[])x) {
                        if (i > 0) {
                            listString.append(", ");
                        }
                        listString.append(PreparedStatementImpl.encodeObject(item));
                        ++i;
                    }
                }
                listString.append("]");
                return listString.toString();
            }
            if (x instanceof Collection) {
                StringBuilder listString = new StringBuilder();
                listString.append("[");
                for (Object item : (Collection)x) {
                    listString.append(PreparedStatementImpl.encodeObject(item)).append(", ");
                }
                if (listString.length() > 1) {
                    listString.delete(listString.length() - 2, listString.length());
                }
                listString.append("]");
                return listString.toString();
            }
            if (x instanceof Map) {
                Map tmpMap = (Map)x;
                StringBuilder mapString = new StringBuilder();
                mapString.append("{");
                for (Object key : tmpMap.keySet()) {
                    mapString.append(PreparedStatementImpl.encodeObject(key)).append(": ").append(PreparedStatementImpl.encodeObject(tmpMap.get(key))).append(", ");
                }
                if (!tmpMap.isEmpty()) {
                    mapString.delete(mapString.length() - 2, mapString.length());
                }
                mapString.append("}");
                return mapString.toString();
            }
            if (x instanceof Reader) {
                return PreparedStatementImpl.encodeCharacterStream((Reader)x, length);
            }
            if (x instanceof InputStream) {
                return PreparedStatementImpl.encodeCharacterStream((InputStream)x, length);
            }
            if (x instanceof Object[]) {
                StringBuilder arrayString = new StringBuilder();
                arrayString.append("[");
                int i = 0;
                for (Object item : (Object[])x) {
                    if (i > 0) {
                        arrayString.append(", ");
                    }
                    arrayString.append(PreparedStatementImpl.encodeObject(item));
                    ++i;
                }
                arrayString.append("]");
                return arrayString.toString();
            }
            if (x instanceof Tuple) {
                StringBuilder tupleString = new StringBuilder();
                tupleString.append("(");
                Tuple t = (Tuple)x;
                Object[] values = t.getValues();
                int i = 0;
                for (Object item : values) {
                    if (i > 0) {
                        tupleString.append(", ");
                    }
                    tupleString.append(PreparedStatementImpl.encodeObject(item));
                    ++i;
                }
                tupleString.append(")");
                return tupleString.toString();
            }
            if (x instanceof UUID) {
                return "'" + ((UUID)x).toString() + "'";
            }
            return SQLUtils.escapeSingleQuotes(x.toString());
        }
        catch (Exception e) {
            LOG.error("Error encoding object", (Throwable)e);
            throw new SQLException("Error encoding object", "07000", e);
        }
    }

    private static String encodeCharacterStream(InputStream stream, Long length) throws SQLException {
        return PreparedStatementImpl.encodeCharacterStream(new InputStreamReader(stream, StandardCharsets.UTF_8), length);
    }

    private static String encodeCharacterStream(Reader reader, Long length) throws SQLException {
        if (reader == null) {
            throw new SQLException("Source cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        try {
            int len;
            char[] buffer = new char[1024];
            while ((len = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, len);
            }
            reader.close();
        }
        catch (IOException e) {
            LOG.error("Error reading string from input stream", (Throwable)e);
            throw new SQLException("Error reading string from input stream", "07000", e);
        }
        if (length == null) {
            return "'" + SQLUtils.escapeSingleQuotes(sb.toString()) + "'";
        }
        return "'" + SQLUtils.escapeSingleQuotes(sb.substring(0, length.intValue())) + "'";
    }

    private ClickHouseDataType jdbcType2ClickHouseDataType(JDBCType type) throws SQLException {
        ClickHouseDataType clickHouseDataType = JdbcUtils.SQL_TO_CLICKHOUSE_TYPE_MAP.get(type);
        if (clickHouseDataType == null) {
            throw new SQLException("Cannot convert " + type + " to a ClickHouse one. Consider using java.sql.JDBCType or com.clickhouse.data.ClickHouseDataType");
        }
        return clickHouseDataType;
    }

    private ClickHouseDataType sqlType2ClickHouseDataType(SQLType type) throws SQLException {
        ClickHouseDataType clickHouseDataType = null;
        if (type instanceof JDBCType) {
            clickHouseDataType = JdbcUtils.SQL_TO_CLICKHOUSE_TYPE_MAP.get(type);
        } else if (type instanceof ClickHouseDataType && JdbcUtils.INVALID_TARGET_TYPES.contains(clickHouseDataType = (ClickHouseDataType)type)) {
            throw new SQLException("Type " + clickHouseDataType + " cannot be used as target type here because requires additional parameters and API doesn't have a way to pass them. ");
        }
        if (clickHouseDataType == null) {
            throw new SQLException("Cannot convert " + type + " to a ClickHouse one. Consider using java.sql.JDBCType or com.clickhouse.data.ClickHouseDataType");
        }
        return clickHouseDataType;
    }

    private String encodeObject(Object x, ClickHouseDataType clickHouseDataType, Integer scaleOrLength) throws SQLException {
        String encodedObject = PreparedStatementImpl.encodeObject(x);
        if (clickHouseDataType != null) {
            encodedObject = encodedObject + "::" + clickHouseDataType.name();
            if (clickHouseDataType.hasParameter()) {
                if (scaleOrLength == null) {
                    throw new SQLException("Target type " + clickHouseDataType + " requires a parameter");
                }
                encodedObject = encodedObject + "(" + scaleOrLength + ")";
            }
        }
        return encodedObject;
    }
}

