/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataProcessor;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.jdbc.ClickHousePreparedStatement;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.AbstractPreparedStatement;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseParameterMetaData;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@Deprecated
public class InputBasedPreparedStatement
extends AbstractPreparedStatement
implements ClickHousePreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(InputBasedPreparedStatement.class);
    private final Calendar defaultCalendar;
    private final ZoneId timeZoneForDate;
    private final ZoneId timeZoneForTs;
    private final ClickHouseColumn[] columns;
    private final ClickHouseValue[] values;
    private final ClickHouseParameterMetaData paramMetaData;
    private final boolean[] flags;
    private int counter;
    private ClickHousePipedOutputStream stream;

    protected InputBasedPreparedStatement(ClickHouseConnectionImpl connection, ClickHouseRequest<?> request, List<ClickHouseColumn> columns, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, request, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (columns == null) {
            throw SqlExceptionUtils.clientError("Non-null column list is required");
        }
        ClickHouseConfig config = this.getConfig();
        this.defaultCalendar = connection.getDefaultCalendar();
        this.timeZoneForTs = config.getUseTimeZone().toZoneId();
        this.timeZoneForDate = config.isUseServerTimeZoneForDates() ? this.timeZoneForTs : null;
        int size = columns.size();
        this.columns = new ClickHouseColumn[size];
        this.values = new ClickHouseValue[size];
        ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(size);
        int i = 0;
        Iterator<ClickHouseColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            ClickHouseColumn col;
            this.columns[i] = col = iterator.next();
            this.values[i] = col.newValue((ClickHouseDataConfig)config);
            list.add(col);
            ++i;
        }
        this.paramMetaData = new ClickHouseParameterMetaData(Collections.unmodifiableList(list), this.mapper, connection.getTypeMap());
        this.flags = new boolean[size];
        this.counter = 0;
        this.stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(config.getWriteBufferSize(), 0, config.getSocketTimeout());
    }

    protected void ensureParams() throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.flags[i]) continue;
            list.add(String.valueOf(i + 1));
        }
        if (!list.isEmpty()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing parameter(s): %s", (Object[])new Object[]{list}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long[] executeAny(boolean asBatch) throws SQLException {
        this.ensureOpen();
        boolean continueOnError = false;
        if (asBatch) {
            if (this.counter < 1) {
                return ClickHouseValues.EMPTY_LONG_ARRAY;
            }
            continueOnError = this.getConnection().getJdbcConfig().isContinueBatchOnError();
        } else {
            try {
                if (this.counter != 0) {
                    throw SqlExceptionUtils.undeterminedExecutionError();
                }
                this.addBatch();
            }
            catch (SQLException e) {
                this.clearBatch();
                throw e;
            }
        }
        long[] results = new long[this.counter];
        long rows = 0L;
        try {
            this.stream.close();
            rows = this.executeInsert((String)this.getRequest().getStatements(false).get(0), (InputStream)this.stream.getInputStream());
            if (asBatch && this.getResultSet() != null) {
                throw SqlExceptionUtils.queryInBatchError(results);
            }
            if (this.counter == 1) {
                results[0] = rows;
            } else {
                Arrays.fill(results, 1L);
            }
        }
        catch (Exception e) {
            if (!asBatch) {
                throw SqlExceptionUtils.handle(e, new Throwable[0]);
            }
            if (rows < 1L) {
                results[0] = -3L;
            } else {
                if (rows >= (long)this.counter) {
                    rows = this.counter;
                }
                int len = (int)rows - 1;
                for (int i = 0; i < len; ++i) {
                    results[i] = 1L;
                }
                results[(int)rows] = -3L;
            }
            if (!continueOnError) {
                throw SqlExceptionUtils.batchUpdateError(e, results);
            }
            log.error((Object)"Failed to execute batch insert of %d records", new Object[]{this.counter + 1, e});
        }
        finally {
            this.clearBatch();
        }
        return results;
    }

    @Override
    protected int getMaxParameterIndex() {
        return this.values.length;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null) {
                throw e;
            }
            throw new SQLException("Query failed", "07000", e.getCause());
        }
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.newEmptyResultSet();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null) {
                throw e;
            }
            throw new SQLException("Update failed", "07000", e.getCause());
        }
        long row = this.getLargeUpdateCount();
        return row > 0L ? row : 0L;
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.flags[i] = false;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null) {
                throw e;
            }
            throw new SQLException("Execution failed", "07000", e.getCause());
        }
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        ClickHouseDataProcessor processor = this.getDataProcessor((ClickHouseOutputStream)this.stream, null, this.columns);
        int nullAsDefault = this.getNullAsDefault();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (!this.flags[i]) {
                throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing value for parameter #%d [%s]", (Object[])new Object[]{i + 1, this.columns[i]}));
            }
            ClickHouseColumn col = this.columns[i];
            ClickHouseValue val = this.values[i];
            if (col.isNestedType() || col.isNullable() || val != null && !val.isNullOrEmpty()) continue;
            if (nullAsDefault > 1 && val != null) {
                val.resetToDefault();
                continue;
            }
            if (nullAsDefault >= 1) continue;
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Cannot set null to non-nullable column #%d [%s]", (Object[])new Object[]{i + 1, col}));
        }
        for (ClickHouseValue val : this.values) {
            try {
                processor.write(val);
            }
            catch (IOException e) {
                throw SqlExceptionUtils.handle(e, new Throwable[0]);
            }
        }
        ++this.counter;
        this.clearParameters();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        try {
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.counter = 0;
        ClickHouseConfig config = this.getConfig();
        this.stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(config.getWriteBufferSize(), 0, config.getSocketTimeout());
        this.resetDataProcessor();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        Object array = x != null ? x.getArray() : x;
        this.values[idx].update(array);
        this.flags[idx] = true;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x != null) {
            LocalDate d;
            if (cal == null) {
                cal = this.defaultCalendar;
            }
            ZoneId tz = cal.getTimeZone().toZoneId();
            if (this.timeZoneForDate == null || tz.equals(this.timeZoneForDate)) {
                d = x.toLocalDate();
            } else {
                Calendar c = (Calendar)cal.clone();
                c.setTime(x);
                d = c.toInstant().atZone(tz).withZoneSameInstant(this.timeZoneForDate).toLocalDate();
            }
            this.values[idx].update(d);
        } else {
            this.values[idx].resetToNullOrEmpty();
        }
        this.flags[idx] = true;
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x != null) {
            LocalTime t;
            ZoneId tz;
            if (cal == null) {
                cal = this.defaultCalendar;
            }
            if ((tz = cal.getTimeZone().toZoneId()).equals(this.timeZoneForTs)) {
                t = x.toLocalTime();
            } else {
                Calendar c = (Calendar)cal.clone();
                c.setTime(x);
                t = c.toInstant().atZone(tz).withZoneSameInstant(this.timeZoneForTs).toLocalTime();
            }
            this.values[idx].update(t);
        } else {
            this.values[idx].resetToNullOrEmpty();
        }
        this.flags[idx] = true;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x != null) {
            LocalDateTime dt;
            ZoneId tz;
            if (cal == null) {
                cal = this.defaultCalendar;
            }
            if ((tz = cal.getTimeZone().toZoneId()).equals(this.timeZoneForTs)) {
                dt = x.toLocalDateTime();
            } else {
                Calendar c = (Calendar)cal.clone();
                c.setTime(x);
                dt = c.toInstant().atZone(tz).withNano(x.getNanos()).withZoneSameInstant(this.timeZoneForTs).toLocalDateTime();
            }
            this.values[idx].update(dt);
        } else {
            this.values[idx].resetToNullOrEmpty();
        }
        this.flags[idx] = true;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].resetToNullOrEmpty();
        this.flags[idx] = true;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.paramMetaData;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }
}

