/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.hc.core5.util;

import com.clickhouse.client.internal.org.apache.hc.core5.annotation.Contract;
import com.clickhouse.client.internal.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.clickhouse.client.internal.org.apache.hc.core5.util.Args;
import com.clickhouse.client.internal.org.apache.hc.core5.util.TimeValue;
import java.text.ParseException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class Timeout
extends TimeValue {
    public static final Timeout ZERO_MILLISECONDS = Timeout.of(0L, TimeUnit.MILLISECONDS);
    public static final Timeout ONE_MILLISECOND = Timeout.of(1L, TimeUnit.MILLISECONDS);
    public static final Timeout DISABLED = ZERO_MILLISECONDS;
    public static final Timeout INFINITE = ZERO_MILLISECONDS;

    public static Timeout defaultsToDisabled(Timeout timeout) {
        return Timeout.defaultsTo(timeout, DISABLED);
    }

    public static Timeout defaultsToInfinite(Timeout timeout) {
        return Timeout.defaultsTo(timeout, DISABLED);
    }

    public static Timeout of(Duration duration) {
        long seconds = duration.getSeconds();
        long nanoOfSecond = duration.getNano();
        if (seconds == 0L) {
            return Timeout.of(nanoOfSecond, TimeUnit.NANOSECONDS);
        }
        if (nanoOfSecond == 0L) {
            return Timeout.of(seconds, TimeUnit.SECONDS);
        }
        try {
            return Timeout.of(duration.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (ArithmeticException e) {
            try {
                return Timeout.of(duration.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (ArithmeticException e1) {
                return Timeout.of(seconds, TimeUnit.SECONDS);
            }
        }
    }

    public static Timeout of(long duration, TimeUnit timeUnit) {
        return new Timeout(duration, timeUnit);
    }

    public static Timeout ofDays(long days) {
        return Timeout.of(days, TimeUnit.DAYS);
    }

    public static Timeout ofHours(long hours) {
        return Timeout.of(hours, TimeUnit.HOURS);
    }

    public static Timeout ofMicroseconds(long microseconds) {
        return Timeout.of(microseconds, TimeUnit.MICROSECONDS);
    }

    public static Timeout ofMilliseconds(long milliseconds) {
        return Timeout.of(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static Timeout ofMinutes(long minutes) {
        return Timeout.of(minutes, TimeUnit.MINUTES);
    }

    public static Timeout ofNanoseconds(long nanoseconds) {
        return Timeout.of(nanoseconds, TimeUnit.NANOSECONDS);
    }

    public static Timeout ofSeconds(long seconds) {
        return Timeout.of(seconds, TimeUnit.SECONDS);
    }

    public static Timeout parse(String value) throws ParseException {
        return TimeValue.parse(value).toTimeout();
    }

    Timeout(long duration, TimeUnit timeUnit) {
        super(Args.notNegative(duration, "duration"), Args.notNull(timeUnit, "timeUnit"));
    }

    public boolean isDisabled() {
        return this.getDuration() == 0L;
    }

    public boolean isEnabled() {
        return !this.isDisabled();
    }
}

