/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.r2dbc.connection;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import io.r2dbc.spi.ConnectionMetadata;
import java.util.concurrent.atomic.AtomicReference;

public class ClickHouseConnectionMetadata
implements ConnectionMetadata {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseConnectionMetadata.class);
    final ClickHouseClient client;
    final ClickHouseNode server;
    private final AtomicReference<String> serverVersion = new AtomicReference<String>("");

    ClickHouseConnectionMetadata(ClickHouseClient client, ClickHouseNode server) {
        this.client = client;
        this.server = server;
    }

    public String getDatabaseProductName() {
        return "Clickhouse";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDatabaseVersion() {
        String version = this.serverVersion.get();
        if (!version.isEmpty()) return version;
        try (ClickHouseResponse resp = this.client.connect(this.server).query("SELECT version()").executeAndWait();){
            version = resp.firstRecord().getValue(0).asString();
            if (this.serverVersion.compareAndSet("", version)) return version;
            String string = this.serverVersion.get();
            return string;
        }
        catch (Exception e) {
            log.error((Object)"While fetching server version, error occured.", (Throwable)e);
        }
        return version;
    }
}

